/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table.batch.compact;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.table.stream.compact.CompactMessages;
import org.apache.flink.connector.file.table.stream.compact.CompactReader;
import org.apache.flink.connector.file.table.stream.compact.CompactWriter;
import org.apache.flink.connector.file.table.utils.CompactFileUtils;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.SupplierWithException;

public class BatchCompactOperator<T>
extends AbstractStreamOperator<CompactMessages.CompactOutput>
implements OneInputStreamOperator<CompactMessages.CoordinatorOutput, CompactMessages.CompactOutput>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    public static final String UNCOMPACTED_PREFIX = "uncompacted-";
    public static final String COMPACTED_PREFIX = "compacted-";
    public static final String ATTEMPT_PREFIX = "attempt-";
    private final SupplierWithException<FileSystem, IOException> fsFactory;
    private final CompactReader.Factory<T> readerFactory;
    private final CompactWriter.Factory<T> writerFactory;
    private transient FileSystem fileSystem;
    private transient Map<String, List<Path>> compactedFiles;

    public BatchCompactOperator(SupplierWithException<FileSystem, IOException> fsFactory, CompactReader.Factory<T> readerFactory, CompactWriter.Factory<T> writerFactory) {
        this.fsFactory = fsFactory;
        this.readerFactory = readerFactory;
        this.writerFactory = writerFactory;
    }

    public void open() throws Exception {
        this.fileSystem = (FileSystem)this.fsFactory.get();
        this.compactedFiles = new HashMap<String, List<Path>>();
    }

    public void processElement(StreamRecord<CompactMessages.CoordinatorOutput> element) throws Exception {
        CompactMessages.CoordinatorOutput value = (CompactMessages.CoordinatorOutput)element.getValue();
        if (value instanceof CompactMessages.CompactionUnit) {
            CompactMessages.CompactionUnit unit = (CompactMessages.CompactionUnit)value;
            String partition = unit.getPartition();
            List<Path> paths = unit.getPaths();
            Configuration config = this.getContainingTask().getEnvironment().getTaskManagerInfo().getConfiguration();
            Path path = null;
            if (paths.size() == 1) {
                path = paths.get(0);
            } else if (paths.size() > 1) {
                Path targetPath = BatchCompactOperator.createCompactedFile(paths, this.getRuntimeContext().getTaskInfo().getAttemptNumber());
                path = CompactFileUtils.doCompact(this.fileSystem, partition, paths, targetPath, config, this.readerFactory, this.writerFactory);
            }
            if (path != null) {
                this.compactedFiles.computeIfAbsent(partition, k -> new ArrayList()).add(path);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported input message: " + String.valueOf(value));
        }
    }

    public void endInput() throws Exception {
        this.output.collect((Object)new StreamRecord((Object)new CompactMessages.CompactOutput(this.compactedFiles)));
    }

    public void close() throws Exception {
        this.compactedFiles.clear();
    }

    private static Path createCompactedFile(List<Path> uncompactedFiles, int attemptNumber) {
        Path path = BatchCompactOperator.convertFromUncompacted(uncompactedFiles.get(0));
        return new Path(path.getParent(), BatchCompactOperator.convertToCompactWithAttempt(attemptNumber, path.getName()));
    }

    public static Path convertFromUncompacted(Path path) {
        Preconditions.checkArgument((boolean)path.getName().startsWith(UNCOMPACTED_PREFIX), (Object)("This should be uncompacted file: " + String.valueOf(path)));
        return new Path(path.getParent(), path.getName().substring(UNCOMPACTED_PREFIX.length()));
    }

    private static String convertToCompactWithAttempt(int attemptNumber, String fileName) {
        return String.format("%s%s%d-%s", COMPACTED_PREFIX, ATTEMPT_PREFIX, attemptNumber, fileName);
    }
}

