/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.connector.source;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.table.connector.ParallelismProvider;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.data.RowData;

@PublicEvolving
public interface InputFormatProvider
extends ScanTableSource.ScanRuntimeProvider,
ParallelismProvider {
    public static InputFormatProvider of(InputFormat<RowData, ?> inputFormat) {
        return InputFormatProvider.of(inputFormat, null);
    }

    public static InputFormatProvider of(final InputFormat<RowData, ?> inputFormat, final @Nullable Integer sourceParallelism) {
        return new InputFormatProvider(){

            @Override
            public InputFormat<RowData, ?> createInputFormat() {
                return inputFormat;
            }

            @Override
            public boolean isBounded() {
                return true;
            }

            @Override
            public Optional<Integer> getParallelism() {
                return Optional.ofNullable(sourceParallelism);
            }
        };
    }

    public InputFormat<RowData, ?> createInputFormat();
}

