/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.internal.ShowCreateUtil;
import org.apache.flink.table.api.internal.TableResultInternal;
import org.apache.flink.table.api.internal.TableResultUtils;
import org.apache.flink.table.catalog.ContextResolvedTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogMaterializedTable;
import org.apache.flink.table.operations.ExecutableOperation;
import org.apache.flink.table.operations.ShowOperation;

@Internal
public class ShowCreateMaterializedTableOperation
implements ShowOperation {
    private final ObjectIdentifier tableIdentifier;

    public ShowCreateMaterializedTableOperation(ObjectIdentifier sqlIdentifier) {
        this.tableIdentifier = sqlIdentifier;
    }

    @Override
    public String asSummaryString() {
        return String.format("SHOW CREATE MATERIALIZED TABLE %s", this.tableIdentifier.asSummaryString());
    }

    @Override
    public TableResultInternal execute(ExecutableOperation.Context ctx) {
        ContextResolvedTable table = ctx.getCatalogManager().getTable(this.tableIdentifier).orElseThrow(() -> new ValidationException(String.format("Could not execute SHOW CREATE MATERIALIZED TABLE. Materialized table with identifier %s does not exist.", this.tableIdentifier.asSerializableString())));
        String resultRow = ShowCreateUtil.buildShowCreateMaterializedTableRow((ResolvedCatalogMaterializedTable)table.getResolvedTable(), this.tableIdentifier, table.isTemporary());
        return TableResultUtils.buildStringArrayResult("result", new String[]{resultRow});
    }
}

