/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.raw;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.formats.raw.RawFormatDeserializationSchema;
import org.apache.flink.formats.raw.RawFormatOptions;
import org.apache.flink.formats.raw.RawFormatSerializationSchema;
import org.apache.flink.shaded.guava33.com.google.common.collect.Sets;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.DecodingFormat;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DeserializationFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class RawFormatFactory
implements DeserializationFormatFactory,
SerializationFormatFactory {
    public static final String IDENTIFIER = "raw";
    private static final Set<LogicalTypeRoot> supportedTypes = Sets.newHashSet((Object[])new LogicalTypeRoot[]{LogicalTypeRoot.CHAR, LogicalTypeRoot.VARCHAR, LogicalTypeRoot.BINARY, LogicalTypeRoot.VARBINARY, LogicalTypeRoot.RAW, LogicalTypeRoot.BOOLEAN, LogicalTypeRoot.TINYINT, LogicalTypeRoot.SMALLINT, LogicalTypeRoot.INTEGER, LogicalTypeRoot.BIGINT, LogicalTypeRoot.FLOAT, LogicalTypeRoot.DOUBLE});

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(RawFormatOptions.ENDIANNESS);
        options.add(RawFormatOptions.CHARSET);
        return options;
    }

    public DecodingFormat<DeserializationSchema<RowData>> createDecodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        final String charsetName = RawFormatFactory.validateAndGetCharsetName(formatOptions);
        final boolean isBigEndian = RawFormatFactory.isBigEndian(formatOptions);
        return new DecodingFormat<DeserializationSchema<RowData>>(){

            public DeserializationSchema<RowData> createRuntimeDecoder(DynamicTableSource.Context context, DataType producedDataType) {
                RowType physicalRowType = (RowType)producedDataType.getLogicalType();
                LogicalType fieldType = RawFormatFactory.validateAndExtractSingleField(physicalRowType);
                TypeInformation producedTypeInfo = context.createTypeInformation(producedDataType);
                return new RawFormatDeserializationSchema(fieldType, (TypeInformation<RowData>)producedTypeInfo, charsetName, isBigEndian);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    public EncodingFormat<SerializationSchema<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        FactoryUtil.validateFactoryOptions((Factory)this, (ReadableConfig)formatOptions);
        final String charsetName = RawFormatFactory.validateAndGetCharsetName(formatOptions);
        final boolean isBigEndian = RawFormatFactory.isBigEndian(formatOptions);
        return new EncodingFormat<SerializationSchema<RowData>>(){

            public SerializationSchema<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                RowType physicalRowType = (RowType)consumedDataType.getLogicalType();
                LogicalType fieldType = RawFormatFactory.validateAndExtractSingleField(physicalRowType);
                return new RawFormatSerializationSchema(fieldType, charsetName, isBigEndian);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    private static void checkFieldType(LogicalType fieldType) {
        if (!supportedTypes.contains(fieldType.getTypeRoot())) {
            throw new ValidationException(String.format("The 'raw' format doesn't supports '%s' as column type.", fieldType.asSummaryString()));
        }
    }

    private static LogicalType validateAndExtractSingleField(RowType physicalRowType) {
        if (physicalRowType.getFieldCount() != 1) {
            String schemaString = physicalRowType.getFields().stream().map(RowType.RowField::asSummaryString).collect(Collectors.joining(", "));
            throw new ValidationException(String.format("The 'raw' format only supports single physical column. However the defined schema contains multiple physical columns: [%s]", schemaString));
        }
        LogicalType fieldType = (LogicalType)physicalRowType.getChildren().get(0);
        RawFormatFactory.checkFieldType(fieldType);
        return fieldType;
    }

    private static boolean isBigEndian(ReadableConfig formatOptions) {
        String endiannessName = (String)formatOptions.get(RawFormatOptions.ENDIANNESS);
        if ("big-endian".equalsIgnoreCase(endiannessName)) {
            return true;
        }
        if ("little-endian".equalsIgnoreCase(endiannessName)) {
            return false;
        }
        throw new ValidationException(String.format("Unsupported endianness name: %s. Valid values of '%s.%s' option are 'big-endian' and 'little-endian'.", endiannessName, IDENTIFIER, RawFormatOptions.ENDIANNESS.key()));
    }

    private static String validateAndGetCharsetName(ReadableConfig formatOptions) {
        String charsetName = (String)formatOptions.get(RawFormatOptions.CHARSET);
        try {
            Charset.forName(charsetName);
        }
        catch (Exception e) {
            throw new ValidationException(String.format("Unsupported '%s.%s' name: %s.", IDENTIFIER, RawFormatOptions.CHARSET.key(), charsetName), (Throwable)e);
        }
        return charsetName;
    }
}

