/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.correlate.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.types.Row;

public class DelegatingAsyncTableResultFuture
implements BiConsumer<Collection<Object>, Throwable> {
    private final ResultFuture<Object> delegatedResultFuture;
    private final Function<Collection<Object>, Collection<Object>> wrapFunction;
    private final CompletableFuture<Collection<Object>> completableFuture;

    public DelegatingAsyncTableResultFuture(ResultFuture<Object> delegatedResultFuture, boolean needsWrapping, boolean isInternalResultType) {
        this.delegatedResultFuture = delegatedResultFuture;
        this.wrapFunction = needsWrapping ? (isInternalResultType ? this::wrapInternal : this::wrapExternal) : outs -> outs;
        this.completableFuture = new CompletableFuture();
        this.completableFuture.whenComplete((BiConsumer)this);
    }

    @Override
    public void accept(Collection<Object> outs, Throwable throwable) {
        if (throwable != null) {
            this.delegatedResultFuture.completeExceptionally(throwable);
        } else {
            this.delegatedResultFuture.complete(this.wrapFunction.apply(outs));
        }
    }

    private Collection<Object> wrapInternal(Collection<Object> outs) {
        ArrayList<Object> wrapped = new ArrayList<Object>();
        for (Object value : outs) {
            wrapped.add(GenericRowData.of((Object[])new Object[]{value}));
        }
        return wrapped;
    }

    private Collection<Object> wrapExternal(Collection<Object> outs) {
        ArrayList<Object> wrapped = new ArrayList<Object>();
        for (Object value : outs) {
            wrapped.add(Row.of((Object[])new Object[]{value}));
        }
        return wrapped;
    }

    public CompletableFuture<Collection<Object>> getCompletableFuture() {
        return this.completableFuture;
    }
}

