/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.over;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.metrics.Counter;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.functions.KeyedProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.generated.AggsHandleFunction;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.operators.over.RowTimeRangeUnboundedPrecedingFunction;
import org.apache.flink.table.runtime.operators.over.RowTimeRowsUnboundedPrecedingFunction;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowTimeUnboundedPrecedingOverFunctionV2<K>
extends KeyedProcessFunctionWithCleanupState<K, RowData, RowData> {
    public static final int SECOND_OVER_VERSION = 2;
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RowTimeUnboundedPrecedingOverFunctionV2.class);
    private final boolean isRowsWindow;
    private final GeneratedAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private final LogicalType[] inputFieldTypes;
    private final int rowTimeIdx;
    protected transient JoinedRowData output;
    private transient ValueState<RowData> accState;
    private transient MapState<Long, List<RowData>> inputState;
    protected transient AggsHandleFunction function;
    private transient Counter numLateRecordsDropped;

    @VisibleForTesting
    protected Counter getCounter() {
        return this.numLateRecordsDropped;
    }

    public RowTimeUnboundedPrecedingOverFunctionV2(boolean isRowsWindow, long minRetentionTime, long maxRetentionTime, GeneratedAggsHandleFunction genAggsHandler, LogicalType[] accTypes, LogicalType[] inputFieldTypes, int rowTimeIdx) {
        super(minRetentionTime, maxRetentionTime);
        this.isRowsWindow = isRowsWindow;
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.inputFieldTypes = inputFieldTypes;
        this.rowTimeIdx = rowTimeIdx;
    }

    public void open(OpenContext openContext) throws Exception {
        this.function = (AggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext()));
        this.output = new JoinedRowData();
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        ValueStateDescriptor accStateDesc = new ValueStateDescriptor("accState", accTypeInfo);
        this.accState = this.getRuntimeContext().getState(accStateDesc);
        InternalTypeInfo<RowData> inputType = InternalTypeInfo.ofFields(this.inputFieldTypes);
        ListTypeInfo rowListTypeInfo = new ListTypeInfo(inputType);
        MapStateDescriptor inputStateDesc = new MapStateDescriptor("inputState", Types.LONG, (TypeInformation)rowListTypeInfo);
        this.inputState = this.getRuntimeContext().getMapState(inputStateDesc);
        this.initCleanupTimeState("RowTimeUnboundedOverCleanupTime");
        this.numLateRecordsDropped = this.getRuntimeContext().getMetricGroup().counter("numLateRecordsDropped");
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long timestamp = input.getLong(this.rowTimeIdx);
        long curWatermark = ctx.timerService().currentWatermark();
        if (timestamp <= curWatermark) {
            this.numLateRecordsDropped.inc();
            return;
        }
        ArrayList<RowData> rowList = (ArrayList<RowData>)this.inputState.get((Object)timestamp);
        if (rowList == null) {
            rowList = new ArrayList<RowData>();
            ctx.timerService().registerEventTimeTimer(timestamp);
        }
        rowList.add(input);
        this.inputState.put((Object)timestamp, rowList);
    }

    public void onTimer(long timestamp, KeyedProcessFunction.OnTimerContext ctx, Collector<RowData> out) throws Exception {
        if (this.isProcessingTimeTimer(ctx)) {
            this.cleanupState(ctx);
            return;
        }
        RowData lastAccumulator = (RowData)this.accState.value();
        if (lastAccumulator == null) {
            lastAccumulator = this.function.createAccumulators();
        }
        this.function.setAccumulators(lastAccumulator);
        this.processElementsWithSameTimestamp(timestamp, out);
        lastAccumulator = this.function.getAccumulators();
        this.accState.update((Object)lastAccumulator);
        this.registerProcessingCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    private void processElementsWithSameTimestamp(long timestamp, Collector<RowData> out) throws Exception {
        List curRowList = (List)this.inputState.get((Object)timestamp);
        if (curRowList == null) {
            LOG.warn("The state is cleared because of state ttl. This will result in incorrect result. You can increase the state ttl to avoid this.");
        } else if (this.isRowsWindow) {
            RowTimeRowsUnboundedPrecedingFunction.processElementsWithSameTimestampRows(this.function, this.output, curRowList, out);
        } else {
            RowTimeRangeUnboundedPrecedingFunction.processElementsWithSameTimestampRange(this.function, this.output, curRowList, out);
        }
        this.inputState.remove((Object)timestamp);
    }

    private void cleanupState(KeyedProcessFunction.OnTimerContext ctx) throws Exception {
        if (this.stateCleaningEnabled) {
            if (this.inputState.isEmpty()) {
                this.cleanupState(new State[]{this.inputState, this.accState});
                this.function.cleanup();
            } else {
                this.registerProcessingCleanupTimer((KeyedProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
            }
        }
    }

    public void close() throws Exception {
        if (null != this.function) {
            this.function.close();
        }
    }
}

