/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.dropwizard.metrics;

import com.codahale.metrics.Snapshot;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import org.apache.flink.metrics.HistogramStatistics;

class HistogramStatisticsWrapper
extends Snapshot {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final HistogramStatistics histogramStatistics;

    HistogramStatisticsWrapper(HistogramStatistics histogramStatistics) {
        this.histogramStatistics = histogramStatistics;
    }

    @Override
    public double getValue(double quantile) {
        return this.histogramStatistics.getQuantile(quantile);
    }

    @Override
    public long[] getValues() {
        return this.histogramStatistics.getValues();
    }

    @Override
    public int size() {
        return this.histogramStatistics.size();
    }

    @Override
    public long getMax() {
        return this.histogramStatistics.getMax();
    }

    @Override
    public double getMean() {
        return this.histogramStatistics.getMean();
    }

    @Override
    public long getMin() {
        return this.histogramStatistics.getMin();
    }

    @Override
    public double getStdDev() {
        return this.histogramStatistics.getStdDev();
    }

    @Override
    public void dump(OutputStream output) {
        try (PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(output, UTF_8));){
            long[] lArray = this.histogramStatistics.getValues();
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long value = lArray[i];
                printWriter.printf("%d%n", value);
            }
        }
    }
}

