/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coprocessor.example;

import java.io.IOException;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.retry.RetryForever;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.ScanOptions;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ZooKeeperScanPolicyObserver
implements RegionCoprocessor,
RegionObserver {
    public static final String ZK_ENSEMBLE_KEY = "ZooKeeperScanPolicyObserver.zookeeper.ensemble";
    public static final String ZK_SESSION_TIMEOUT_KEY = "ZooKeeperScanPolicyObserver.zookeeper.session.timeout";
    public static final int ZK_SESSION_TIMEOUT_DEFAULT = 30000;
    public static final String NODE = "/backup/example/lastbackup";
    private static final String ZKKEY = "ZK";
    private NodeCache cache;

    public Optional<RegionObserver> getRegionObserver() {
        return Optional.of(this);
    }

    public void start(CoprocessorEnvironment env) throws IOException {
        RegionCoprocessorEnvironment renv = (RegionCoprocessorEnvironment)env;
        try {
            this.cache = ((ZKDataHolder)renv.getSharedData().computeIfAbsent(ZKKEY, k -> {
                String ensemble = renv.getConfiguration().get(ZK_ENSEMBLE_KEY);
                int sessionTimeout = renv.getConfiguration().getInt(ZK_SESSION_TIMEOUT_KEY, 30000);
                return new ZKDataHolder(ensemble, sessionTimeout);
            })).acquire();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void stop(CoprocessorEnvironment env) throws IOException {
        RegionCoprocessorEnvironment renv = (RegionCoprocessorEnvironment)env;
        this.cache = null;
        ((ZKDataHolder)renv.getSharedData().get(ZKKEY)).release();
    }

    private OptionalLong getExpireBefore() {
        ChildData data = this.cache.getCurrentData();
        if (data == null) {
            return OptionalLong.empty();
        }
        byte[] bytes = data.getData();
        if (bytes == null || bytes.length != 8) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(Bytes.toLong((byte[])bytes));
    }

    private void resetTTL(ScanOptions options) {
        OptionalLong expireBefore = this.getExpireBefore();
        if (!expireBefore.isPresent()) {
            return;
        }
        options.setTTL(EnvironmentEdgeManager.currentTime() - expireBefore.getAsLong());
    }

    public void preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanOptions options, FlushLifeCycleTracker tracker) throws IOException {
        this.resetTTL(options);
    }

    public void preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, ScanType scanType, ScanOptions options, CompactionLifeCycleTracker tracker, CompactionRequest request) throws IOException {
        this.resetTTL(options);
    }

    private static final class ZKDataHolder {
        private final String ensemble;
        private final int sessionTimeout;
        private CuratorFramework client;
        private NodeCache cache;
        private int ref;

        public ZKDataHolder(String ensemble, int sessionTimeout) {
            this.ensemble = ensemble;
            this.sessionTimeout = sessionTimeout;
        }

        private void create() throws Exception {
            this.client = CuratorFrameworkFactory.builder().connectString(this.ensemble).sessionTimeoutMs(this.sessionTimeout).retryPolicy((RetryPolicy)new RetryForever(1000)).canBeReadOnly(true).build();
            this.client.start();
            this.cache = new NodeCache(this.client, ZooKeeperScanPolicyObserver.NODE);
            this.cache.start(true);
        }

        private void close() {
            if (this.cache != null) {
                try {
                    this.cache.close();
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                this.cache = null;
            }
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }

        public synchronized NodeCache acquire() throws Exception {
            if (this.ref == 0) {
                try {
                    this.create();
                }
                catch (Exception e) {
                    this.close();
                    throw e;
                }
            }
            ++this.ref;
            return this.cache;
        }

        public synchronized void release() {
            --this.ref;
            if (this.ref == 0) {
                this.close();
            }
        }
    }
}

