/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class Get
extends Query
implements Row {
    private static final Logger LOG = LoggerFactory.getLogger(Get.class);
    private byte[] row = null;
    private int maxVersions = 1;
    private boolean cacheBlocks = true;
    private int storeLimit = -1;
    private int storeOffset = 0;
    private TimeRange tr = TimeRange.allTime();
    private boolean checkExistenceOnly = false;
    private boolean closestRowBefore = false;
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);

    public Get(byte[] row) {
        Mutation.checkRow(row);
        this.row = row;
    }

    public Get(Get get) {
        this(get.getRow());
        this.setFilter(get.getFilter());
        this.setReplicaId(get.getReplicaId());
        this.setConsistency(get.getConsistency());
        this.cacheBlocks = get.getCacheBlocks();
        this.maxVersions = get.getMaxVersions();
        this.storeLimit = get.getMaxResultsPerColumnFamily();
        this.storeOffset = get.getRowOffsetPerColumnFamily();
        this.tr = get.getTimeRange();
        this.checkExistenceOnly = get.isCheckExistenceOnly();
        this.loadColumnFamiliesOnDemand = get.getLoadColumnFamiliesOnDemandValue();
        Map<byte[], NavigableSet<byte[]>> fams = get.getFamilyMap();
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : fams.entrySet()) {
            byte[] fam = entry.getKey();
            NavigableSet<byte[]> cols = entry.getValue();
            if (cols != null && cols.size() > 0) {
                for (byte[] col : cols) {
                    this.addColumn(fam, col);
                }
                continue;
            }
            this.addFamily(fam);
        }
        for (Map.Entry<Object, Object> entry : get.getAttributesMap().entrySet()) {
            this.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : get.getColumnFamilyTimeRange().entrySet()) {
            TimeRange tr = (TimeRange)entry.getValue();
            this.setColumnFamilyTimeRange((byte[])entry.getKey(), tr.getMin(), tr.getMax());
        }
        super.setPriority(get.getPriority());
    }

    public Get(byte[] row, int rowOffset, int rowLength) {
        Mutation.checkRow(row, rowOffset, rowLength);
        this.row = Bytes.copy((byte[])row, (int)rowOffset, (int)rowLength);
    }

    public Get(ByteBuffer row) {
        Mutation.checkRow(row);
        this.row = new byte[row.remaining()];
        row.get(this.row);
    }

    public boolean isCheckExistenceOnly() {
        return this.checkExistenceOnly;
    }

    public Get setCheckExistenceOnly(boolean checkExistenceOnly) {
        this.checkExistenceOnly = checkExistenceOnly;
        return this;
    }

    @Deprecated
    public boolean isClosestRowBefore() {
        return this.closestRowBefore;
    }

    @Deprecated
    public Get setClosestRowBefore(boolean closestRowBefore) {
        return this;
    }

    public Get addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public Get addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            this.familyMap.put(family, set);
        }
        if (qualifier == null) {
            qualifier = HConstants.EMPTY_BYTE_ARRAY;
        }
        set.add(qualifier);
        return this;
    }

    public Get setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    @Deprecated
    public Get setTimeStamp(long timestamp) throws IOException {
        return this.setTimestamp(timestamp);
    }

    public Get setTimestamp(long timestamp) {
        try {
            this.tr = new TimeRange(timestamp, timestamp + 1L);
        }
        catch (Exception e) {
            LOG.error("TimeRange failed, likely caused by integer overflow. ", (Throwable)e);
            throw e;
        }
        return this;
    }

    @Override
    public Get setColumnFamilyTimeRange(byte[] cf, long minStamp, long maxStamp) {
        super.setColumnFamilyTimeRange(cf, minStamp, maxStamp);
        return this;
    }

    @Deprecated
    public Get setMaxVersions() {
        return this.readAllVersions();
    }

    @Deprecated
    public Get setMaxVersions(int maxVersions) throws IOException {
        return this.readVersions(maxVersions);
    }

    public Get readAllVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public Get readVersions(int versions) throws IOException {
        if (versions <= 0) {
            throw new IOException("versions must be positive");
        }
        this.maxVersions = versions;
        return this;
    }

    @Override
    public Get setLoadColumnFamiliesOnDemand(boolean value) {
        super.setLoadColumnFamiliesOnDemand(value);
        return this;
    }

    public Get setMaxResultsPerColumnFamily(int limit) {
        this.storeLimit = limit;
        return this;
    }

    public Get setRowOffsetPerColumnFamily(int offset) {
        this.storeOffset = offset;
        return this;
    }

    @Override
    public Get setFilter(Filter filter) {
        super.setFilter(filter);
        return this;
    }

    public Get setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
        return this;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public int getMaxResultsPerColumnFamily() {
        return this.storeLimit;
    }

    public int getRowOffsetPerColumnFamily() {
        return this.storeOffset;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    public Set<byte[]> familySet() {
        return this.familyMap.keySet();
    }

    public int numFamilies() {
        return this.familyMap.size();
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>(this.familyMap.entrySet().size());
        map.put("families", families);
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary((byte[])entry.getKey()));
        }
        return map;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = this.getFingerprint();
        HashMap columns = new HashMap();
        map.put("families", columns);
        map.put("row", Bytes.toStringBinary((byte[])this.row));
        map.put("maxVersions", this.maxVersions);
        map.put("cacheBlocks", this.cacheBlocks);
        ArrayList<Long> timeRange = new ArrayList<Long>(2);
        timeRange.add(this.tr.getMin());
        timeRange.add(this.tr.getMax());
        map.put("timeRange", timeRange);
        int colCount = 0;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            ArrayList<String> familyList = new ArrayList<String>();
            columns.put(Bytes.toStringBinary((byte[])entry.getKey()), familyList);
            if (entry.getValue() == null) {
                ++colCount;
                --maxCols;
                familyList.add("ALL");
                continue;
            }
            colCount += entry.getValue().size();
            if (maxCols <= 0) continue;
            for (byte[] column : entry.getValue()) {
                if (--maxCols <= 0) continue;
                familyList.add(Bytes.toStringBinary((byte[])column));
            }
        }
        map.put("totalColumns", colCount);
        if (this.filter != null) {
            map.put("filter", this.filter.toString());
        }
        if (this.getId() != null) {
            map.put("id", this.getId());
        }
        map.put("storeLimit", this.storeLimit);
        map.put("storeOffset", this.storeOffset);
        map.put("checkExistenceOnly", this.checkExistenceOnly);
        map.put("targetReplicaId", this.targetReplicaId);
        map.put("consistency", (Object)this.consistency);
        map.put("loadColumnFamiliesOnDemand", this.loadColumnFamiliesOnDemand);
        if (!this.colFamTimeRangeMap.isEmpty()) {
            Map<String, List> colFamTimeRangeMapStr = this.colFamTimeRangeMap.entrySet().stream().collect(Collectors.toMap(e -> Bytes.toStringBinary((byte[])((byte[])e.getKey())), e -> {
                TimeRange value = (TimeRange)e.getValue();
                ArrayList<Long> rangeList = new ArrayList<Long>();
                rangeList.add(value.getMin());
                rangeList.add(value.getMax());
                return rangeList;
            }));
            map.put("colFamTimeRangeMap", colFamTimeRangeMapStr);
        }
        map.put("priority", this.getPriority());
        return map;
    }

    @Override
    public int compareTo(Row other) {
        return Bytes.compareTo((byte[])this.getRow(), (byte[])other.getRow());
    }

    public int hashCode() {
        return Bytes.hashCode((byte[])this.getRow());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Row)) {
            return false;
        }
        Row other = (Row)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public Get setAttribute(String name, byte[] value) {
        super.setAttribute(name, value);
        return this;
    }

    @Override
    public Get setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public Get setAuthorizations(Authorizations authorizations) {
        super.setAuthorizations(authorizations);
        return this;
    }

    @Override
    public Get setACL(Map<String, Permission> perms) {
        super.setACL(perms);
        return this;
    }

    @Override
    public Get setACL(String user, Permission perms) {
        super.setACL(user, perms);
        return this;
    }

    @Override
    public Get setConsistency(Consistency consistency) {
        super.setConsistency(consistency);
        return this;
    }

    @Override
    public Get setReplicaId(int Id) {
        super.setReplicaId(Id);
        return this;
    }

    @Override
    public Get setIsolationLevel(IsolationLevel level) {
        super.setIsolationLevel(level);
        return this;
    }

    @Override
    public Get setPriority(int priority) {
        super.setPriority(priority);
        return this;
    }
}

