/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.procedure2.store.wal.BitSetNode;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureStoreTracker;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestBitSetNode {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestBitSetNode.class);

    @Test
    public void testGetActiveMaxMinProcId() {
        BitSetNode node = new BitSetNode(5L, false);
        Assert.assertEquals((long)5L, (long)node.getActiveMinProcId());
        Assert.assertEquals((long)5L, (long)node.getActiveMaxProcId());
        node.insertOrUpdate(10L);
        Assert.assertEquals((long)5L, (long)node.getActiveMinProcId());
        Assert.assertEquals((long)10L, (long)node.getActiveMaxProcId());
        node.insertOrUpdate(1L);
        Assert.assertEquals((long)1L, (long)node.getActiveMinProcId());
        Assert.assertEquals((long)10L, (long)node.getActiveMaxProcId());
        node.delete(10L);
        Assert.assertEquals((long)1L, (long)node.getActiveMinProcId());
        Assert.assertEquals((long)5L, (long)node.getActiveMaxProcId());
        node.delete(1L);
        Assert.assertEquals((long)5L, (long)node.getActiveMinProcId());
        Assert.assertEquals((long)5L, (long)node.getActiveMaxProcId());
        node.delete(5L);
        Assert.assertEquals((long)-1L, (long)node.getActiveMinProcId());
        Assert.assertEquals((long)-1L, (long)node.getActiveMaxProcId());
    }

    @Test
    public void testGrow() {
        BitSetNode node = new BitSetNode(1000L, false);
        Assert.assertTrue((boolean)node.canGrow(1024L));
        Assert.assertTrue((boolean)node.canGrow(900L));
        Assert.assertTrue((boolean)node.canGrow(1100L));
        Assert.assertFalse((boolean)node.canGrow(100L));
        Assert.assertFalse((boolean)node.canGrow(10000L));
        node.grow(1100L);
        Assert.assertTrue((boolean)node.contains(1100L));
        Assert.assertTrue((boolean)node.isModified(1000L));
        node.grow(900L);
        Assert.assertTrue((boolean)node.contains(900L));
        Assert.assertTrue((boolean)node.isModified(1000L));
        for (long i = node.getStart(); i <= node.getEnd(); ++i) {
            if (i != 1000L) {
                Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.YES, (Object)node.isDeleted(i));
                continue;
            }
            Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.NO, (Object)node.isDeleted(i));
        }
    }

    @Test
    public void testMerge() {
        BitSetNode node = new BitSetNode(1000L, false);
        Assert.assertTrue((boolean)node.canMerge(new BitSetNode(1200L, false)));
        Assert.assertFalse((boolean)node.canMerge(new BitSetNode(10000L, false)));
        BitSetNode rightNode = new BitSetNode(1200L, false);
        node.merge(rightNode);
        Assert.assertTrue((boolean)node.isModified(1000L));
        Assert.assertTrue((boolean)node.isModified(1200L));
        for (long i = node.getStart(); i <= node.getEnd(); ++i) {
            if (i != 1000L && i != 1200L) {
                Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.YES, (Object)node.isDeleted(i));
                continue;
            }
            Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.NO, (Object)node.isDeleted(i));
        }
    }
}

