/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableBuilder;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.MultiTableInputFormatBase;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={SmallTests.class})
public class TestMultiTableInputFormatBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMultiTableInputFormatBase.class);
    @Rule
    public final TestName name = new TestName();

    @Test
    public void testMRSplitsConnectionCount() throws IOException {
        MultiTableInputFormatBase mtif = new MultiTableInputFormatBase(){

            public RecordReader<ImmutableBytesWritable, Result> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                return super.createRecordReader(split, context);
            }
        };
        JobContext mockedJobContext = (JobContext)Mockito.mock(JobContext.class);
        Configuration c = HBaseConfiguration.create();
        c.set("hbase.client.connection.impl", MRSplitsConnection.class.getName());
        Mockito.when((Object)mockedJobContext.getConfiguration()).thenReturn((Object)c);
        ArrayList<Scan> scans = new ArrayList<Scan>();
        for (int i = 0; i < 10; ++i) {
            Scan scan = new Scan();
            String tableName = this.name.getMethodName() + i;
            scan.setAttribute("scan.attributes.table.name", Bytes.toBytes((String)tableName));
            scans.add(scan);
        }
        mtif.setScans(scans);
        List splits = mtif.getSplits(mockedJobContext);
        Assert.assertTrue((splits.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)MRSplitsConnection.creations.get());
    }

    public static class MRSplitsConnection
    implements Connection {
        private final Configuration configuration;
        static final AtomicInteger creations = new AtomicInteger(0);

        MRSplitsConnection(Configuration conf, ExecutorService pool, User user) throws IOException {
            this.configuration = conf;
            creations.incrementAndGet();
        }

        public void abort(String why, Throwable e) {
        }

        public boolean isAborted() {
            return false;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
            return null;
        }

        public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
            return null;
        }

        public RegionLocator getRegionLocator(TableName tableName) throws IOException {
            byte[][] startKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"zzz")};
            byte[][] endKeys = new byte[][]{Bytes.toBytes((String)"aaaa"), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"zzz"), HConstants.EMPTY_BYTE_ARRAY};
            final TreeMap<byte[], HRegionLocation> map = new TreeMap<byte[], HRegionLocation>(Bytes.BYTES_COMPARATOR);
            for (byte[] startKey : startKeys) {
                HRegionLocation hrl = new HRegionLocation(RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(startKey).build(), ServerName.valueOf((String)Bytes.toString((byte[])startKey), (int)0, (long)0L));
                map.put(startKey, hrl);
            }
            ArrayList locations = new ArrayList(map.values());
            RegionLocator mockedRegionLocator = (RegionLocator)Mockito.mock(RegionLocator.class);
            Mockito.when((Object)mockedRegionLocator.getRegionLocation((byte[])Mockito.any(byte[].class), Mockito.anyBoolean())).thenAnswer((Answer)new Answer<HRegionLocation>(){

                public HRegionLocation answer(InvocationOnMock invocationOnMock) throws Throwable {
                    Object[] args = invocationOnMock.getArguments();
                    byte[] key = (byte[])args[0];
                    return (HRegionLocation)map.get(key);
                }
            });
            Mockito.when((Object)mockedRegionLocator.getAllRegionLocations()).thenReturn(locations);
            Mockito.when((Object)mockedRegionLocator.getStartEndKeys()).thenReturn((Object)new Pair((Object)startKeys, (Object)endKeys));
            Mockito.when((Object)mockedRegionLocator.getName()).thenReturn((Object)tableName);
            return mockedRegionLocator;
        }

        public Admin getAdmin() throws IOException {
            Admin admin = (Admin)Mockito.mock(Admin.class);
            Mockito.when((Object)admin.getConfiguration()).thenReturn((Object)this.getConfiguration());
            return admin;
        }

        public Table getTable(TableName tableName) throws IOException {
            Table table = (Table)Mockito.mock(Table.class);
            Mockito.when((Object)table.getName()).thenReturn((Object)tableName);
            return table;
        }

        public void close() throws IOException {
        }

        public boolean isClosed() {
            return false;
        }

        public TableBuilder getTableBuilder(TableName tableName, ExecutorService pool) {
            return (TableBuilder)Mockito.mock(TableBuilder.class);
        }

        public void clearRegionLocationCache() {
        }

        public String getClusterId() {
            return null;
        }
    }
}

