/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication;
import org.apache.hadoop.hbase.mapreduce.replication.VerifyReplicationRecompareRunnable;
import org.apache.hadoop.hbase.testclassification.ReplicationTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.counters.GenericCounter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@Category(value={ReplicationTests.class, SmallTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class TestVerifyReplicationRecompareRunnable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestVerifyReplicationRecompareRunnable.class);
    @Mock
    private Table sourceTable;
    @Mock
    private Table replicatedTable;
    @Mock
    private Mapper.Context context;

    static Result genResult(int cols) {
        KeyValue[] kvs = new KeyValue[cols];
        for (int i = 0; i < cols; ++i) {
            kvs[i] = new KeyValue(TestVerifyReplicationRecompareRunnable.genBytes(), TestVerifyReplicationRecompareRunnable.genBytes(), TestVerifyReplicationRecompareRunnable.genBytes(), System.currentTimeMillis(), TestVerifyReplicationRecompareRunnable.genBytes());
        }
        return Result.create((Cell[])kvs);
    }

    static byte[] genBytes() {
        return Bytes.toBytes((int)ThreadLocalRandom.current().nextInt());
    }

    @Before
    public void setUp() {
        for (VerifyReplication.Verifier.Counters counter : VerifyReplication.Verifier.Counters.values()) {
            GenericCounter emptyCounter = new GenericCounter(counter.name(), counter.name());
            Mockito.when((Object)this.context.getCounter((Enum)counter)).thenReturn((Object)emptyCounter);
        }
    }

    @Test
    public void itRecomparesGoodRow() throws IOException {
        Result result = TestVerifyReplicationRecompareRunnable.genResult(2);
        Mockito.when((Object)this.sourceTable.get((Get)ArgumentMatchers.any(Get.class))).thenReturn((Object)result);
        Mockito.when((Object)this.replicatedTable.get((Get)ArgumentMatchers.any(Get.class))).thenReturn((Object)result);
        VerifyReplicationRecompareRunnable runnable = new VerifyReplicationRecompareRunnable(this.context, TestVerifyReplicationRecompareRunnable.genResult(5), null, VerifyReplication.Verifier.Counters.ONLY_IN_SOURCE_TABLE_ROWS, "", new Scan(), this.sourceTable, this.replicatedTable, 3, 1, 0, true);
        runnable.run();
        Assert.assertEquals((long)0L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
        Assert.assertEquals((long)0L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.ONLY_IN_SOURCE_TABLE_ROWS).getValue());
        Assert.assertEquals((long)1L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)1L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.SOURCE_ROW_CHANGED).getValue());
        Assert.assertEquals((long)1L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.PEER_ROW_CHANGED).getValue());
        Assert.assertEquals((long)2L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.RECOMPARES).getValue());
    }

    @Test
    public void itRecomparesBadRow() throws IOException {
        Result replicatedResult = TestVerifyReplicationRecompareRunnable.genResult(1);
        Mockito.when((Object)this.sourceTable.get((Get)ArgumentMatchers.any(Get.class))).thenReturn((Object)TestVerifyReplicationRecompareRunnable.genResult(5));
        Mockito.when((Object)this.replicatedTable.get((Get)ArgumentMatchers.any(Get.class))).thenReturn((Object)replicatedResult);
        VerifyReplicationRecompareRunnable runnable = new VerifyReplicationRecompareRunnable(this.context, TestVerifyReplicationRecompareRunnable.genResult(5), replicatedResult, VerifyReplication.Verifier.Counters.ONLY_IN_SOURCE_TABLE_ROWS, "", new Scan(), this.sourceTable, this.replicatedTable, 1, 1, 0, true);
        runnable.run();
        Assert.assertEquals((long)1L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
        Assert.assertEquals((long)1L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.ONLY_IN_SOURCE_TABLE_ROWS).getValue());
        Assert.assertEquals((long)0L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.GOODROWS).getValue());
        Assert.assertEquals((long)1L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.SOURCE_ROW_CHANGED).getValue());
        Assert.assertEquals((long)0L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.PEER_ROW_CHANGED).getValue());
        Assert.assertEquals((long)1L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.RECOMPARES).getValue());
    }

    @Test
    public void itHandlesExceptionOnRecompare() throws IOException {
        Mockito.when((Object)this.sourceTable.get((Get)ArgumentMatchers.any(Get.class))).thenThrow(new Throwable[]{new IOException("Error!")});
        Mockito.when((Object)this.replicatedTable.get((Get)ArgumentMatchers.any(Get.class))).thenReturn((Object)TestVerifyReplicationRecompareRunnable.genResult(5));
        VerifyReplicationRecompareRunnable runnable = new VerifyReplicationRecompareRunnable(this.context, TestVerifyReplicationRecompareRunnable.genResult(5), null, VerifyReplication.Verifier.Counters.ONLY_IN_SOURCE_TABLE_ROWS, "", new Scan(), this.sourceTable, this.replicatedTable, 1, 1, 0, true);
        runnable.run();
        Assert.assertEquals((long)1L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.BADROWS).getValue());
        Assert.assertEquals((long)1L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.ONLY_IN_SOURCE_TABLE_ROWS).getValue());
        Assert.assertEquals((long)1L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.FAILED_RECOMPARE).getValue());
        Assert.assertEquals((long)1L, (long)this.context.getCounter((Enum)VerifyReplication.Verifier.Counters.RECOMPARES).getValue());
    }
}

