/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;

public class TimestampTestBase {
    private static final long T0 = 10L;
    private static final long T1 = 100L;
    private static final long T2 = 200L;
    public static final byte[] FAMILY_NAME = Bytes.toBytes((String)"colfamily11");
    private static final byte[] QUALIFIER_NAME = Bytes.toBytes((String)"contents");
    private static final byte[] ROW = Bytes.toBytes((String)"row");

    public static void doTestDelete(Table table, FlushCache flusher) throws IOException {
        TimestampTestBase.put(table, 10L);
        TimestampTestBase.put(table, 100L);
        TimestampTestBase.put(table, 200L);
        TimestampTestBase.put(table);
        TimestampTestBase.assertVersions(table, new long[]{Long.MAX_VALUE, 200L, 100L});
        TimestampTestBase.delete(table);
        TimestampTestBase.assertVersions(table, new long[]{200L, 100L, 10L});
        flusher.flushcache();
        TimestampTestBase.assertVersions(table, new long[]{200L, 100L, 10L});
        TimestampTestBase.put(table);
        TimestampTestBase.assertVersions(table, new long[]{Long.MAX_VALUE, 200L, 100L});
        TimestampTestBase.delete(table, 200L);
        TimestampTestBase.assertVersions(table, new long[]{Long.MAX_VALUE, 100L, 10L});
        flusher.flushcache();
        TimestampTestBase.assertVersions(table, new long[]{Long.MAX_VALUE, 100L, 10L});
        TimestampTestBase.put(table, 200L);
        TimestampTestBase.delete(table, 100L);
        TimestampTestBase.put(table, 100L);
        Delete delete = new Delete(ROW);
        delete.addColumns(FAMILY_NAME, QUALIFIER_NAME, 200L);
        table.delete(delete);
        TimestampTestBase.assertOnlyLatest(table, Long.MAX_VALUE);
        flusher.flushcache();
        TimestampTestBase.assertOnlyLatest(table, Long.MAX_VALUE);
    }

    private static void assertOnlyLatest(Table incommon, long currentTime) throws IOException {
        Get get = null;
        get = new Get(ROW);
        get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
        get.setMaxVersions(3);
        Result result = incommon.get(get);
        Assert.assertEquals((long)1L, (long)result.size());
        long time = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)result.rawCells()[0]));
        Assert.assertEquals((long)time, (long)currentTime);
    }

    public static void assertVersions(Table incommon, long[] tss) throws IOException {
        Get get = null;
        get = new Get(ROW);
        get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
        Result r = incommon.get(get);
        byte[] bytes = r.getValue(FAMILY_NAME, QUALIFIER_NAME);
        long t = Bytes.toLong((byte[])bytes);
        Assert.assertEquals((long)tss[0], (long)t);
        get = new Get(ROW);
        get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
        get.setMaxVersions(tss.length);
        Result result = incommon.get(get);
        Cell[] kvs = result.rawCells();
        Assert.assertEquals((long)kvs.length, (long)tss.length);
        for (int i = 0; i < kvs.length; ++i) {
            t = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)kvs[i]));
            Assert.assertEquals((long)tss[i], (long)t);
        }
        long maxStamp = kvs[0].getTimestamp();
        get = new Get(ROW);
        get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
        get.setTimeRange(0L, maxStamp);
        get.setMaxVersions(kvs.length - 1);
        result = incommon.get(get);
        kvs = result.rawCells();
        Assert.assertEquals((long)kvs.length, (long)(tss.length - 1));
        for (int i = 1; i < kvs.length; ++i) {
            t = Bytes.toLong((byte[])CellUtil.cloneValue((Cell)kvs[i - 1]));
            Assert.assertEquals((long)tss[i], (long)t);
        }
        TimestampTestBase.assertScanContentTimestamp(incommon, tss[0]);
    }

    public static void doTestTimestampScanning(Table incommon, FlushCache flusher) throws IOException {
        TimestampTestBase.put(incommon, 10L);
        TimestampTestBase.put(incommon, 100L);
        TimestampTestBase.put(incommon, Long.MAX_VALUE);
        int count = TimestampTestBase.assertScanContentTimestamp(incommon, Long.MAX_VALUE);
        Assert.assertEquals((long)count, (long)TimestampTestBase.assertScanContentTimestamp(incommon, 10L));
        Assert.assertEquals((long)count, (long)TimestampTestBase.assertScanContentTimestamp(incommon, 100L));
        flusher.flushcache();
        Assert.assertEquals((long)count, (long)TimestampTestBase.assertScanContentTimestamp(incommon, 10L));
        Assert.assertEquals((long)count, (long)TimestampTestBase.assertScanContentTimestamp(incommon, 100L));
    }

    public static int assertScanContentTimestamp(Table in, long ts) throws IOException {
        Scan scan = new Scan(HConstants.EMPTY_START_ROW);
        scan.addFamily(FAMILY_NAME);
        scan.setTimeRange(0L, ts);
        ResultScanner scanner = in.getScanner(scan);
        int count = 0;
        scanner.close();
        return count;
    }

    public static void put(Table loader, long ts) throws IOException {
        TimestampTestBase.put(loader, Bytes.toBytes((long)ts), ts);
    }

    public static void put(Table loader) throws IOException {
        long ts = Long.MAX_VALUE;
        TimestampTestBase.put(loader, Bytes.toBytes((long)ts), ts);
    }

    public static void put(Table loader, byte[] bytes, long ts) throws IOException {
        Put put = new Put(ROW, ts);
        put.setDurability(Durability.SKIP_WAL);
        put.addColumn(FAMILY_NAME, QUALIFIER_NAME, bytes);
        loader.put(put);
    }

    public static void delete(Table loader) throws IOException {
        TimestampTestBase.delete(loader, null);
    }

    public static void delete(Table loader, byte[] column) throws IOException {
        TimestampTestBase.delete(loader, column, Long.MAX_VALUE);
    }

    public static void delete(Table loader, long ts) throws IOException {
        TimestampTestBase.delete(loader, null, ts);
    }

    public static void delete(Table loader, byte[] column, long ts) throws IOException {
        Delete delete = ts == Long.MAX_VALUE ? new Delete(ROW) : new Delete(ROW, ts);
        delete.addColumn(FAMILY_NAME, QUALIFIER_NAME, ts);
        loader.delete(delete);
    }

    public static Result get(Table loader) throws IOException {
        return loader.get(new Get(ROW));
    }

    static interface FlushCache {
        public void flushcache() throws IOException;
    }
}

