/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CheckAndMutate;
import org.apache.hadoop.hbase.client.CheckAndMutateResult;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedWithDetailsException;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.MultiRowMutationEndpoint;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.MultiRowMutationProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FromClientSide3TestBase {
    private static final Logger LOG = LoggerFactory.getLogger(FromClientSide3TestBase.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static int WAITTABLE_MILLIS;
    private static byte[] FAMILY;
    private static int SLAVES;
    private static byte[] ROW;
    private static byte[] ANOTHERROW;
    private static byte[] QUALIFIER;
    private static byte[] VALUE;
    private static byte[] COL_QUAL;
    private static byte[] VAL_BYTES;
    private static byte[] ROW_BYTES;
    private TableName tableName;

    protected static void startCluster() throws Exception {
        WAITTABLE_MILLIS = 10000;
        FAMILY = Bytes.toBytes((String)"testFamily");
        SLAVES = 3;
        ROW = Bytes.toBytes((String)"testRow");
        ANOTHERROW = Bytes.toBytes((String)"anotherrow");
        QUALIFIER = Bytes.toBytes((String)"testQualifier");
        VALUE = Bytes.toBytes((String)"testValue");
        COL_QUAL = Bytes.toBytes((String)"f1");
        VAL_BYTES = Bytes.toBytes((String)"v1");
        ROW_BYTES = Bytes.toBytes((String)"r1");
        TEST_UTIL.startMiniCluster(SLAVES);
    }

    @AfterAll
    public static void shutdownCluster() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.tableName = TableName.valueOf((String)((Method)testInfo.getTestMethod().get()).getName());
    }

    @AfterEach
    public void tearDown() throws Exception {
        for (TableDescriptor htd : TEST_UTIL.getAdmin().listTableDescriptors()) {
            LOG.info("Tear down, remove table=" + htd.getTableName());
            TEST_UTIL.deleteTable(htd.getTableName());
        }
    }

    private void randomCFPuts(Table table, byte[] row, byte[] family, int nPuts) throws Exception {
        Put put = new Put(row);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < nPuts; ++i) {
            byte[] qualifier = Bytes.toBytes((int)((Random)rand).nextInt());
            byte[] value = Bytes.toBytes((int)((Random)rand).nextInt());
            put.addColumn(family, qualifier, value);
        }
        table.put(put);
    }

    private void performMultiplePutAndFlush(HBaseAdmin admin, Table table, byte[] row, byte[] family, int nFlushes, int nPuts) throws Exception {
        try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(table.getName());){
            HRegionLocation loc = locator.getRegionLocation(row, true);
            AdminProtos.AdminService.BlockingInterface server = ((ClusterConnection)admin.getConnection()).getAdmin(loc.getServerName());
            byte[] regName = loc.getRegionInfo().getRegionName();
            for (int i = 0; i < nFlushes; ++i) {
                this.randomCFPuts(table, row, family, nPuts);
                List sf = org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regName, (byte[])FAMILY);
                int sfCount = sf.size();
                admin.flush(table.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Cell> toList(ResultScanner scanner) {
        try {
            ArrayList cells = new ArrayList();
            for (Result r : scanner) {
                cells.addAll(r.listCells());
            }
            ArrayList arrayList = cells;
            return arrayList;
        }
        finally {
            scanner.close();
        }
    }

    @Test
    public void testScanAfterDeletingSpecifiedRow() throws IOException, InterruptedException {
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            byte[] row = Bytes.toBytes((String)"SpecifiedRow");
            byte[] value0 = Bytes.toBytes((String)"value_0");
            byte[] value1 = Bytes.toBytes((String)"value_1");
            Put put = new Put(row);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            Delete d = new Delete(row);
            table.delete(d);
            put = new Put(row);
            put.addColumn(FAMILY, null, value0);
            table.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, null, value1);
            table.put(put);
            List<Cell> cells = FromClientSide3TestBase.toList(table.getScanner(new Scan()));
            Assertions.assertEquals((int)1, (int)cells.size());
            Assertions.assertEquals((Object)"value_1", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cells.get(0))));
            cells = FromClientSide3TestBase.toList(table.getScanner(new Scan().addFamily(FAMILY)));
            Assertions.assertEquals((int)1, (int)cells.size());
            Assertions.assertEquals((Object)"value_1", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cells.get(0))));
            cells = FromClientSide3TestBase.toList(table.getScanner(new Scan().addColumn(FAMILY, QUALIFIER)));
            Assertions.assertEquals((int)0, (int)cells.size());
            TEST_UTIL.getAdmin().flush(this.tableName);
            cells = FromClientSide3TestBase.toList(table.getScanner(new Scan()));
            Assertions.assertEquals((int)1, (int)cells.size());
            Assertions.assertEquals((Object)"value_1", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cells.get(0))));
            cells = FromClientSide3TestBase.toList(table.getScanner(new Scan().addFamily(FAMILY)));
            Assertions.assertEquals((int)1, (int)cells.size());
            Assertions.assertEquals((Object)"value_1", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)cells.get(0))));
            cells = FromClientSide3TestBase.toList(table.getScanner(new Scan().addColumn(FAMILY, QUALIFIER)));
            Assertions.assertEquals((int)0, (int)cells.size());
        }
    }

    @Test
    public void testScanAfterDeletingSpecifiedRowV2() throws IOException, InterruptedException {
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            byte[] row = Bytes.toBytes((String)"SpecifiedRow");
            byte[] qual0 = Bytes.toBytes((String)"qual0");
            byte[] qual1 = Bytes.toBytes((String)"qual1");
            long now = EnvironmentEdgeManager.currentTime();
            Delete d = new Delete(row, now);
            table.delete(d);
            Put put = new Put(row);
            put.addColumn(FAMILY, null, now + 1L, VALUE);
            table.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qual1, now + 2L, qual1);
            table.put(put);
            put = new Put(row);
            put.addColumn(FAMILY, qual0, now + 3L, qual0);
            table.put(put);
            Result r = table.get(new Get(row));
            Assertions.assertEquals((int)3, (int)r.size(), (String)r.toString());
            Assertions.assertEquals((Object)"testValue", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            Assertions.assertEquals((Object)"qual0", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[1])));
            Assertions.assertEquals((Object)"qual1", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[2])));
            TEST_UTIL.getAdmin().flush(this.tableName);
            r = table.get(new Get(row));
            Assertions.assertEquals((int)3, (int)r.size());
            Assertions.assertEquals((Object)"testValue", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[0])));
            Assertions.assertEquals((Object)"qual0", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[1])));
            Assertions.assertEquals((Object)"qual1", (Object)Bytes.toString((byte[])CellUtil.cloneValue((Cell)r.rawCells()[2])));
        }
    }

    @Test
    public void testAdvancedConfigOverride() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compaction.min", 3);
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            try (Admin admin = TEST_UTIL.getAdmin();){
                ClusterConnection connection = (ClusterConnection)TEST_UTIL.getConnection();
                byte[] row = Bytes.toBytes((int)ThreadLocalRandom.current().nextInt());
                this.performMultiplePutAndFlush((HBaseAdmin)admin, table, row, FAMILY, 3, 100);
                try (RegionLocator locator = TEST_UTIL.getConnection().getRegionLocator(this.tableName);){
                    HRegionLocation loc = locator.getRegionLocation(row, true);
                    byte[] regionName = loc.getRegionInfo().getRegionName();
                    AdminProtos.AdminService.BlockingInterface server = connection.getAdmin(loc.getServerName());
                    Assertions.assertTrue((org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() > 1 ? 1 : 0) != 0);
                    admin.compact(this.tableName);
                    for (int i = 0; i < 250; ++i) {
                        loc = locator.getRegionLocation(row, true);
                        if (!loc.getRegionInfo().isOffline()) {
                            regionName = loc.getRegionInfo().getRegionName();
                            server = connection.getAdmin(loc.getServerName());
                            if (org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() <= 1) break;
                        }
                        Thread.sleep(40L);
                    }
                    Assertions.assertTrue((org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() <= 1 ? 1 : 0) != 0);
                    LOG.info("hbase.hstore.compaction.min should now be 5");
                    HTableDescriptor htd = new HTableDescriptor(table.getTableDescriptor());
                    htd.setValue("hbase.hstore.compaction.min", String.valueOf(5));
                    admin.modifyTable(this.tableName, (TableDescriptor)htd);
                    Pair st = admin.getAlterStatus(this.tableName);
                    while (null != st && (Integer)st.getFirst() > 0) {
                        LOG.debug(st.getFirst() + " regions left to update");
                        Thread.sleep(40L);
                        st = admin.getAlterStatus(this.tableName);
                    }
                    LOG.info("alter status finished");
                    this.performMultiplePutAndFlush((HBaseAdmin)admin, table, row, FAMILY, 3, 10);
                    admin.compact(this.tableName);
                    Thread.sleep(10000L);
                    loc = locator.getRegionLocation(row, true);
                    regionName = loc.getRegionInfo().getRegionName();
                    server = connection.getAdmin(loc.getServerName());
                    int sfCount = org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size();
                    Assertions.assertTrue((sfCount > 1 ? 1 : 0) != 0);
                    LOG.info("hbase.hstore.compaction.min should now be 2");
                    HColumnDescriptor hcd = new HColumnDescriptor(htd.getFamily(FAMILY));
                    hcd.setValue("hbase.hstore.compaction.min", String.valueOf(2));
                    htd.modifyFamily(hcd);
                    admin.modifyTable(this.tableName, (TableDescriptor)htd);
                    st = admin.getAlterStatus(this.tableName);
                    while (null != st && (Integer)st.getFirst() > 0) {
                        LOG.debug(st.getFirst() + " regions left to update");
                        Thread.sleep(40L);
                        st = admin.getAlterStatus(this.tableName);
                    }
                    LOG.info("alter status finished");
                    admin.compact(this.tableName);
                    for (int i = 0; i < 250; ++i) {
                        loc = locator.getRegionLocation(row, true);
                        regionName = loc.getRegionInfo().getRegionName();
                        try {
                            server = connection.getAdmin(loc.getServerName());
                            if (org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() < sfCount) {
                                break;
                            }
                        }
                        catch (Exception e) {
                            LOG.debug("Waiting for region to come online: " + Bytes.toString((byte[])regionName));
                        }
                        Thread.sleep(40L);
                    }
                    Assertions.assertTrue((org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil.getStoreFiles((AdminProtos.AdminService.BlockingInterface)server, (byte[])regionName, (byte[])FAMILY).size() < sfCount ? 1 : 0) != 0);
                    LOG.info("Removing CF config value");
                    LOG.info("hbase.hstore.compaction.min should now be 5");
                    hcd = new HColumnDescriptor(htd.getFamily(FAMILY));
                    hcd.setValue("hbase.hstore.compaction.min", null);
                    htd.modifyFamily(hcd);
                    admin.modifyTable(this.tableName, (TableDescriptor)htd);
                    st = admin.getAlterStatus(this.tableName);
                    while (null != st && (Integer)st.getFirst() > 0) {
                        LOG.debug(st.getFirst() + " regions left to update");
                        Thread.sleep(40L);
                        st = admin.getAlterStatus(this.tableName);
                    }
                    LOG.info("alter status finished");
                    Assertions.assertNull((Object)table.getTableDescriptor().getFamily(FAMILY).getValue("hbase.hstore.compaction.min"));
                }
            }
        }
    }

    @Test
    public void testHTableBatchWithEmptyPut() throws IOException, InterruptedException {
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            ArrayList<Put> actions = new ArrayList<Put>();
            Object[] results = new Object[2];
            Put put1 = new Put(ROW);
            actions.add(put1);
            Put put2 = new Put(ANOTHERROW);
            put2.addColumn(FAMILY, QUALIFIER, VALUE);
            actions.add(put2);
            table.batch(actions, results);
            Assertions.fail((String)"Empty Put should have failed the batch call");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testHTableWithLargeBatch() throws IOException, InterruptedException {
        int sixtyFourK = 65536;
        ArrayList<Put> actions = new ArrayList<Put>();
        Object[] results = new Object[(sixtyFourK + 1) * 2];
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            for (int i = 0; i < sixtyFourK + 1; ++i) {
                Put put1 = new Put(ROW);
                put1.addColumn(FAMILY, QUALIFIER, VALUE);
                actions.add(put1);
                Put put2 = new Put(ANOTHERROW);
                put2.addColumn(FAMILY, QUALIFIER, VALUE);
                actions.add(put2);
            }
            table.batch(actions, results);
        }
    }

    @Test
    public void testBatchWithRowMutation() throws Exception {
        LOG.info("Starting testBatchWithRowMutation");
        byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b")};
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            RowMutations arm = RowMutations.of(Collections.singletonList(new Put(ROW).addColumn(FAMILY, QUALIFIERS[0], VALUE)));
            Object[] batchResult = new Object[1];
            table.batch(Arrays.asList(arm), batchResult);
            Get g = new Get(ROW);
            Result r = table.get(g);
            Assertions.assertEquals((int)0, (int)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIERS[0])));
            arm = RowMutations.of(Arrays.asList(new Put(ROW).addColumn(FAMILY, QUALIFIERS[1], VALUE), new Delete(ROW).addColumns(FAMILY, QUALIFIERS[0])));
            table.batch(Arrays.asList(arm), batchResult);
            r = table.get(g);
            Assertions.assertEquals((int)0, (int)Bytes.compareTo((byte[])VALUE, (byte[])r.getValue(FAMILY, QUALIFIERS[1])));
            Assertions.assertNull((Object)r.getValue(FAMILY, QUALIFIERS[0]));
            try {
                arm = RowMutations.of(Collections.singletonList(new Put(ROW).addColumn(new byte[]{98, 111, 103, 117, 115}, QUALIFIERS[0], VALUE)));
                table.batch(Arrays.asList(arm), batchResult);
                Assertions.fail((String)"Expected RetriesExhaustedWithDetailsException with NoSuchColumnFamilyException");
            }
            catch (RetriesExhaustedWithDetailsException e) {
                String msg = e.getMessage();
                Assertions.assertTrue((boolean)msg.contains("NoSuchColumnFamilyException"));
            }
        }
    }

    @Test
    public void testBatchWithCheckAndMutate() throws Exception {
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            byte[] row1 = Bytes.toBytes((String)"row1");
            byte[] row2 = Bytes.toBytes((String)"row2");
            byte[] row3 = Bytes.toBytes((String)"row3");
            byte[] row4 = Bytes.toBytes((String)"row4");
            byte[] row5 = Bytes.toBytes((String)"row5");
            byte[] row6 = Bytes.toBytes((String)"row6");
            byte[] row7 = Bytes.toBytes((String)"row7");
            table.put(Arrays.asList(new Put(row1).addColumn(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")), new Put(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")), new Put(row3).addColumn(FAMILY, Bytes.toBytes((String)"C"), Bytes.toBytes((String)"c")), new Put(row4).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d")), new Put(row5).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"e")), new Put(row6).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((long)10L)), new Put(row7).addColumn(FAMILY, Bytes.toBytes((String)"G"), Bytes.toBytes((String)"g"))));
            CheckAndMutate checkAndMutate1 = CheckAndMutate.newBuilder((byte[])row1).ifEquals(FAMILY, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"a")).build(new RowMutations(row1).add((Mutation)new Put(row1).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"g"))).add((Mutation)new Delete(row1).addColumns(FAMILY, Bytes.toBytes((String)"A"))).add((Mutation)new Increment(row1).addColumn(FAMILY, Bytes.toBytes((String)"C"), 3L)).add((Mutation)new Append(row1).addColumn(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"d"))));
            Get get = new Get(row2).addColumn(FAMILY, Bytes.toBytes((String)"B"));
            RowMutations mutations = new RowMutations(row3).add((Mutation)new Delete(row3).addColumns(FAMILY, Bytes.toBytes((String)"C"))).add((Mutation)new Put(row3).addColumn(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((String)"f"))).add((Mutation)new Increment(row3).addColumn(FAMILY, Bytes.toBytes((String)"A"), 5L)).add((Mutation)new Append(row3).addColumn(FAMILY, Bytes.toBytes((String)"B"), Bytes.toBytes((String)"b")));
            CheckAndMutate checkAndMutate2 = CheckAndMutate.newBuilder((byte[])row4).ifEquals(FAMILY, Bytes.toBytes((String)"D"), Bytes.toBytes((String)"a")).build(new Put(row4).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"h")));
            Put put = new Put(row5).addColumn(FAMILY, Bytes.toBytes((String)"E"), Bytes.toBytes((String)"f"));
            CheckAndMutate checkAndMutate3 = CheckAndMutate.newBuilder((byte[])row6).ifEquals(FAMILY, Bytes.toBytes((String)"F"), Bytes.toBytes((long)10L)).build(new Increment(row6).addColumn(FAMILY, Bytes.toBytes((String)"F"), 1L));
            CheckAndMutate checkAndMutate4 = CheckAndMutate.newBuilder((byte[])row7).ifEquals(FAMILY, Bytes.toBytes((String)"G"), Bytes.toBytes((String)"g")).build(new Append(row7).addColumn(FAMILY, Bytes.toBytes((String)"G"), Bytes.toBytes((String)"g")));
            List<Row> actions = Arrays.asList(checkAndMutate1, get, mutations, checkAndMutate2, put, checkAndMutate3, checkAndMutate4);
            Object[] results = new Object[actions.size()];
            table.batch(actions, results);
            CheckAndMutateResult checkAndMutateResult = (CheckAndMutateResult)results[0];
            Assertions.assertTrue((boolean)checkAndMutateResult.isSuccess());
            Assertions.assertEquals((long)3L, (long)Bytes.toLong((byte[])checkAndMutateResult.getResult().getValue(FAMILY, Bytes.toBytes((String)"C"))));
            Assertions.assertEquals((Object)"d", (Object)Bytes.toString((byte[])checkAndMutateResult.getResult().getValue(FAMILY, Bytes.toBytes((String)"D"))));
            Assertions.assertEquals((Object)"b", (Object)Bytes.toString((byte[])((Result)results[1]).getValue(FAMILY, Bytes.toBytes((String)"B"))));
            Result result = (Result)results[2];
            Assertions.assertTrue((boolean)result.getExists());
            Assertions.assertEquals((long)5L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))));
            Assertions.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            checkAndMutateResult = (CheckAndMutateResult)results[3];
            Assertions.assertFalse((boolean)checkAndMutateResult.isSuccess());
            Assertions.assertNull((Object)checkAndMutateResult.getResult());
            Assertions.assertTrue((boolean)((Result)results[4]).isEmpty());
            checkAndMutateResult = (CheckAndMutateResult)results[5];
            Assertions.assertTrue((boolean)checkAndMutateResult.isSuccess());
            Assertions.assertEquals((long)11L, (long)Bytes.toLong((byte[])checkAndMutateResult.getResult().getValue(FAMILY, Bytes.toBytes((String)"F"))));
            checkAndMutateResult = (CheckAndMutateResult)results[6];
            Assertions.assertTrue((boolean)checkAndMutateResult.isSuccess());
            Assertions.assertEquals((Object)"gg", (Object)Bytes.toString((byte[])checkAndMutateResult.getResult().getValue(FAMILY, Bytes.toBytes((String)"G"))));
            result = table.get(new Get(row1));
            Assertions.assertEquals((Object)"g", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            Assertions.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"A")));
            Assertions.assertEquals((long)3L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
            Assertions.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            result = table.get(new Get(row3));
            Assertions.assertNull((Object)result.getValue(FAMILY, Bytes.toBytes((String)"C")));
            Assertions.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
            Assertions.assertNull((Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"C"))));
            Assertions.assertEquals((long)5L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"A"))));
            Assertions.assertEquals((Object)"b", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"B"))));
            result = table.get(new Get(row4));
            Assertions.assertEquals((Object)"d", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"D"))));
            result = table.get(new Get(row5));
            Assertions.assertEquals((Object)"f", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"E"))));
            result = table.get(new Get(row6));
            Assertions.assertEquals((long)11L, (long)Bytes.toLong((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"F"))));
            result = table.get(new Get(row7));
            Assertions.assertEquals((Object)"gg", (Object)Bytes.toString((byte[])result.getValue(FAMILY, Bytes.toBytes((String)"G"))));
        }
    }

    @Test
    public void testHTableExistsMethodSingleRegionSingleGet() throws IOException, InterruptedException {
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            Get get = new Get(ROW);
            boolean exist = table.exists(get);
            Assertions.assertFalse((boolean)exist);
            table.put(put);
            exist = table.exists(get);
            Assertions.assertTrue((boolean)exist);
        }
    }

    @Test
    public void testHTableExistsMethodSingleRegionMultipleGets() throws IOException, InterruptedException {
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            ArrayList<Get> gets = new ArrayList<Get>();
            gets.add(new Get(ROW));
            gets.add(new Get(ANOTHERROW));
            boolean[] results = table.exists(gets);
            Assertions.assertTrue((boolean)results[0]);
            Assertions.assertFalse((boolean)results[1]);
        }
    }

    @Test
    public void testHTableExistsBeforeGet() throws IOException, InterruptedException {
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            Get get = new Get(ROW);
            boolean exist = table.exists(get);
            Assertions.assertEquals((Object)true, (Object)exist);
            Result result = table.get(get);
            Assertions.assertEquals((Object)false, (Object)result.isEmpty());
            Assertions.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result.getValue(FAMILY, QUALIFIER)));
        }
    }

    @Test
    public void testHTableExistsAllBeforeGet() throws IOException, InterruptedException {
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            byte[] ROW2 = Bytes.add((byte[])ROW, (byte[])Bytes.toBytes((String)"2"));
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            put = new Put(ROW2);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            Get get = new Get(ROW);
            Get get2 = new Get(ROW2);
            ArrayList<Get> getList = new ArrayList<Get>(2);
            getList.add(get);
            getList.add(get2);
            boolean[] exists = table.existsAll(getList);
            Assertions.assertEquals((Object)true, (Object)exists[0]);
            Assertions.assertEquals((Object)true, (Object)exists[1]);
            Result[] result = table.get(getList);
            Assertions.assertEquals((Object)false, (Object)result[0].isEmpty());
            Assertions.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result[0].getValue(FAMILY, QUALIFIER)));
            Assertions.assertEquals((Object)false, (Object)result[1].isEmpty());
            Assertions.assertTrue((boolean)Bytes.equals((byte[])VALUE, (byte[])result[1].getValue(FAMILY, QUALIFIER)));
        }
    }

    @Test
    public void testHTableExistsMethodMultipleRegionsSingleGet() throws Exception {
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY}, 1, new byte[]{0}, new byte[]{-1}, 255);){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            Get get = new Get(ROW);
            boolean exist = table.exists(get);
            Assertions.assertFalse((boolean)exist);
            table.put(put);
            exist = table.exists(get);
            Assertions.assertTrue((boolean)exist);
        }
    }

    @Test
    public void testHTableExistsMethodMultipleRegionsMultipleGets() throws Exception {
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY}, 1, new byte[]{0}, new byte[]{-1}, 255);){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            Put put = new Put(ROW);
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            ArrayList<Get> gets = new ArrayList<Get>();
            gets.add(new Get(ANOTHERROW));
            gets.add(new Get(Bytes.add((byte[])ROW, (byte[])new byte[]{0})));
            gets.add(new Get(ROW));
            gets.add(new Get(Bytes.add((byte[])ANOTHERROW, (byte[])new byte[]{0})));
            LOG.info("Calling exists");
            boolean[] results = table.existsAll(gets);
            Assertions.assertFalse((boolean)results[0]);
            Assertions.assertFalse((boolean)results[1]);
            Assertions.assertTrue((boolean)results[2]);
            Assertions.assertFalse((boolean)results[3]);
            put = new Put(new byte[]{0});
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            gets = new ArrayList();
            gets.add(new Get(new byte[]{0}));
            gets.add(new Get(new byte[]{0, 0}));
            results = table.existsAll(gets);
            Assertions.assertTrue((boolean)results[0]);
            Assertions.assertFalse((boolean)results[1]);
            put = new Put(new byte[]{-1, -1});
            put.addColumn(FAMILY, QUALIFIER, VALUE);
            table.put(put);
            gets = new ArrayList();
            gets.add(new Get(new byte[]{-1}));
            gets.add(new Get(new byte[]{-1, -1}));
            gets.add(new Get(new byte[]{-1, -1, -1}));
            results = table.existsAll(gets);
            Assertions.assertFalse((boolean)results[0]);
            Assertions.assertTrue((boolean)results[1]);
            Assertions.assertFalse((boolean)results[2]);
        }
    }

    @Test
    public void testGetEmptyRow() throws Exception {
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            Put put = new Put(ROW_BYTES);
            put.addColumn(FAMILY, COL_QUAL, VAL_BYTES);
            table.put(put);
            Result res = null;
            try {
                res = table.get(new Get(new byte[0]));
                Assertions.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Assertions.assertTrue((res == null ? 1 : 0) != 0);
            res = table.get(new Get(Bytes.toBytes((String)"r1-not-exist")));
            Assertions.assertTrue((res.isEmpty() ? 1 : 0) != 0);
            res = table.get(new Get(ROW_BYTES));
            Assertions.assertTrue((boolean)Arrays.equals(res.getValue(FAMILY, COL_QUAL), VAL_BYTES));
        }
    }

    @Test
    public void testConnectionDefaultUsesCodec() throws Exception {
        ClusterConnection con = (ClusterConnection)TEST_UTIL.getConnection();
        Assertions.assertTrue((boolean)con.hasCellBlockSupport());
    }

    @Test
    public void testPutWithPreBatchMutate() throws Exception {
        this.testPreBatchMutate(this.tableName, () -> {
            try (Table t = TEST_UTIL.getConnection().getTable(this.tableName);){
                Put put = new Put(ROW);
                put.addColumn(FAMILY, QUALIFIER, VALUE);
                t.put(put);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    @Test
    public void testRowMutationsWithPreBatchMutate() throws Exception {
        this.testPreBatchMutate(this.tableName, () -> {
            try (Table t = TEST_UTIL.getConnection().getTable(this.tableName);){
                RowMutations rm = new RowMutations(ROW, 1);
                Put put = new Put(ROW);
                put.addColumn(FAMILY, QUALIFIER, VALUE);
                rm.add(put);
                t.mutateRow(rm);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private void testPreBatchMutate(TableName tableName, Runnable rn) throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tableName);
        desc.addCoprocessor(WaitingForScanObserver.class.getName());
        desc.addFamily(new HColumnDescriptor(FAMILY));
        TEST_UTIL.getAdmin().createTable((TableDescriptor)desc);
        ExecutorService service = Executors.newFixedThreadPool(2);
        service.execute(rn);
        ArrayList cells = new ArrayList();
        service.execute(() -> {
            try {
                TimeUnit.SECONDS.sleep(3L);
                try (Table t = TEST_UTIL.getConnection().getTable(tableName);){
                    Scan scan = new Scan();
                    try (ResultScanner scanner = t.getScanner(scan);){
                        for (Result r : scanner) {
                            cells.addAll(Arrays.asList(r.rawCells()));
                        }
                    }
                }
            }
            catch (IOException | InterruptedException ex) {
                throw new RuntimeException(ex);
            }
        });
        service.shutdown();
        service.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        Assertions.assertEquals((int)0, (int)cells.size(), (String)"The write is blocking by RegionObserver#postBatchMutate, so the data is invisible to reader");
        TEST_UTIL.deleteTable(tableName);
    }

    @Test
    public void testLockLeakWithDelta() throws Exception, Throwable {
        HTableDescriptor desc = new HTableDescriptor(this.tableName);
        desc.addCoprocessor(WaitingForMultiMutationsObserver.class.getName());
        desc.setConfiguration("hbase.rowlock.wait.duration", String.valueOf(5000));
        desc.addFamily(new HColumnDescriptor(FAMILY));
        TEST_UTIL.getAdmin().createTable((TableDescriptor)desc);
        TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
        Configuration copy = new Configuration(TEST_UTIL.getConfiguration());
        copy.setInt("hbase.client.retries.number", 2);
        try (Connection con = ConnectionFactory.createConnection((Configuration)copy);){
            HRegion region = FromClientSide3TestBase.find(this.tableName);
            region.setTimeoutForWriteLock(10L);
            ExecutorService putService = Executors.newSingleThreadExecutor();
            putService.execute(() -> {
                try (Table table = con.getTable(this.tableName);){
                    Put put = new Put(ROW);
                    put.addColumn(FAMILY, QUALIFIER, VALUE);
                    table.put(put);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
            ExecutorService appendService = Executors.newSingleThreadExecutor();
            appendService.execute(() -> {
                Append append = new Append(ROW);
                append.addColumn(FAMILY, QUALIFIER, VALUE);
                try (Table table = con.getTable(this.tableName);){
                    table.append(append);
                    Assertions.fail((String)"The APPEND should fail because the target lock is blocked by previous put");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            appendService.shutdown();
            appendService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            WaitingForMultiMutationsObserver observer = FromClientSide3TestBase.find(this.tableName, WaitingForMultiMutationsObserver.class);
            observer.latch.countDown();
            putService.shutdown();
            putService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            try (Table table = con.getTable(this.tableName);){
                Result r = table.get(new Get(ROW));
                Assertions.assertFalse((boolean)r.isEmpty());
                Assertions.assertTrue((boolean)Bytes.equals((byte[])r.getValue(FAMILY, QUALIFIER), (byte[])VALUE));
            }
        }
        HRegion region = FromClientSide3TestBase.find(this.tableName);
        int readLockCount = region.getReadLockCount();
        LOG.info("readLockCount:" + readLockCount);
        Assertions.assertEquals((int)0, (int)readLockCount);
    }

    @Test
    public void testMultiRowMutations() throws Exception, Throwable {
        HTableDescriptor desc = new HTableDescriptor(this.tableName);
        desc.addCoprocessor(MultiRowMutationEndpoint.class.getName());
        desc.addCoprocessor(WaitingForMultiMutationsObserver.class.getName());
        desc.setConfiguration("hbase.rowlock.wait.duration", String.valueOf(5000));
        desc.addFamily(new HColumnDescriptor(FAMILY));
        TEST_UTIL.getAdmin().createTable((TableDescriptor)desc);
        TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
        Configuration copy = new Configuration(TEST_UTIL.getConfiguration());
        copy.setInt("hbase.client.retries.number", 2);
        try (Connection con = ConnectionFactory.createConnection((Configuration)copy);){
            byte[] row = Bytes.toBytes((String)"ROW-0");
            byte[] rowLocked = Bytes.toBytes((String)"ROW-1");
            byte[] value0 = Bytes.toBytes((String)"VALUE-0");
            byte[] value1 = Bytes.toBytes((String)"VALUE-1");
            byte[] value2 = Bytes.toBytes((String)"VALUE-2");
            FromClientSide3TestBase.assertNoLocks(this.tableName);
            ExecutorService putService = Executors.newSingleThreadExecutor();
            putService.execute(() -> {
                try (Table table = con.getTable(this.tableName);){
                    Put put0 = new Put(rowLocked);
                    put0.addColumn(FAMILY, QUALIFIER, value0);
                    table.put(put0);
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            });
            ExecutorService cpService = Executors.newSingleThreadExecutor();
            cpService.execute(() -> {
                boolean threw;
                Put put1 = new Put(row);
                Put put2 = new Put(rowLocked);
                put1.addColumn(FAMILY, QUALIFIER, value1);
                put2.addColumn(FAMILY, QUALIFIER, value2);
                try (Table table = con.getTable(this.tableName);){
                    MultiRowMutationProtos.MutateRowsRequest request = MultiRowMutationProtos.MutateRowsRequest.newBuilder().addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)put1)).addMutationRequest(ProtobufUtil.toMutation((ClientProtos.MutationProto.MutationType)ClientProtos.MutationProto.MutationType.PUT, (Mutation)put2)).build();
                    table.coprocessorService(MultiRowMutationProtos.MultiRowMutationService.class, ROW, ROW, exe -> {
                        ServerRpcController controller = new ServerRpcController();
                        CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                        exe.mutateRows((RpcController)controller, request, (RpcCallback)rpcCallback);
                        return (MultiRowMutationProtos.MutateRowsResponse)rpcCallback.get();
                    });
                    threw = false;
                }
                catch (Throwable ex) {
                    threw = true;
                }
                if (!threw) {
                    Assertions.fail((String)"This cp should fail because the target lock is blocked by previous put");
                }
            });
            cpService.shutdown();
            cpService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            WaitingForMultiMutationsObserver observer = FromClientSide3TestBase.find(this.tableName, WaitingForMultiMutationsObserver.class);
            observer.latch.countDown();
            putService.shutdown();
            putService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            try (Table table = con.getTable(this.tableName);){
                Get g0 = new Get(row);
                Get g1 = new Get(rowLocked);
                Result r0 = table.get(g0);
                Result r1 = table.get(g1);
                Assertions.assertTrue((boolean)r0.isEmpty());
                Assertions.assertFalse((boolean)r1.isEmpty());
                Assertions.assertTrue((boolean)Bytes.equals((byte[])r1.getValue(FAMILY, QUALIFIER), (byte[])value0));
            }
            FromClientSide3TestBase.assertNoLocks(this.tableName);
        }
    }

    @Test
    public void testMVCCUsingMVCCPreAssign() throws IOException, InterruptedException {
        try (Table table = TEST_UTIL.createTable(this.tableName, (byte[][])new byte[][]{FAMILY});){
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            Put put = new Put(Bytes.toBytes((String)"0"));
            put.addColumn(FAMILY, Bytes.toBytes((String)""), Bytes.toBytes((String)"0"));
            table.put(put);
            put = new Put(Bytes.toBytes((String)"00"));
            put.addColumn(FAMILY, Bytes.toBytes((String)""), Bytes.toBytes((String)"0"));
            table.put(put);
            Scan scan = new Scan();
            scan.setTimeRange(0L, Long.MAX_VALUE);
            scan.setCaching(1);
            ResultScanner scanner = table.getScanner(scan);
            int rowNum = scanner.next() != null ? 1 : 0;
            for (int i = 1; i < 1000; ++i) {
                put = new Put(Bytes.toBytes((String)String.valueOf(i)));
                put.setDurability(Durability.ASYNC_WAL);
                put.addColumn(FAMILY, Bytes.toBytes((String)""), Bytes.toBytes((int)i));
                table.put(put);
            }
            for (Result result : scanner) {
                ++rowNum;
            }
            Assertions.assertEquals((int)2, (int)rowNum);
            scanner = table.getScanner(scan);
            rowNum = 0;
            for (Result result : scanner) {
                ++rowNum;
            }
            Assertions.assertEquals((int)1001, (int)rowNum);
        }
    }

    @Test
    public void testPutThenGetWithMultipleThreads() throws Exception {
        int THREAD_NUM = 20;
        int ROUND_NUM = 10;
        for (int round = 0; round < 10; ++round) {
            ArrayList<Thread> threads = new ArrayList<Thread>(20);
            final AtomicInteger successCnt = new AtomicInteger(0);
            try (final Table ht = TEST_UTIL.createTable(this.tableName, FAMILY);){
                TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
                int i = 0;
                while (i < 20) {
                    final int index = i++;
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            byte[] row = Bytes.toBytes((String)("row-" + index));
                            byte[] value = Bytes.toBytes((String)("v" + index));
                            try {
                                Put put = new Put(row);
                                put.addColumn(FAMILY, QUALIFIER, value);
                                ht.put(put);
                                Get get = new Get(row);
                                Result result = ht.get(get);
                                byte[] returnedValue = result.getValue(FAMILY, QUALIFIER);
                                if (Bytes.equals((byte[])value, (byte[])returnedValue)) {
                                    successCnt.getAndIncrement();
                                } else {
                                    LOG.error("Should be equal but not, original value: " + Bytes.toString((byte[])value) + ", returned value: " + (returnedValue == null ? "null" : Bytes.toString((byte[])returnedValue)));
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                    threads.add(t);
                }
                for (Thread t : threads) {
                    t.start();
                }
                for (Thread t : threads) {
                    t.join();
                }
                Assertions.assertEquals((int)20, (int)successCnt.get(), (String)("Not equal in round " + round));
            }
            TEST_UTIL.deleteTable(this.tableName);
        }
    }

    private static void assertNoLocks(TableName tableName) throws IOException, InterruptedException {
        HRegion region = FromClientSide3TestBase.find(tableName);
        Assertions.assertEquals((int)0, (int)region.getLockedRows().size());
    }

    private static HRegion find(TableName tableName) throws IOException, InterruptedException {
        HRegionServer rs = TEST_UTIL.getRSForFirstRegionInTable(tableName);
        List regions = rs.getRegions(tableName);
        Assertions.assertEquals((int)1, (int)regions.size());
        return (HRegion)regions.get(0);
    }

    private static <T extends RegionObserver> T find(TableName tableName, Class<T> clz) throws IOException, InterruptedException {
        HRegion region = FromClientSide3TestBase.find(tableName);
        Coprocessor cp = region.getCoprocessorHost().findCoprocessor(clz.getName());
        Assertions.assertTrue((boolean)clz.isInstance(cp), (String)("The cp instance should be " + clz.getName() + ", current instance is " + cp.getClass().getName()));
        return (T)((RegionObserver)clz.cast(cp));
    }

    static byte[] generateHugeValue(int size) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        byte[] value = new byte[size];
        for (int i = 0; i < value.length; ++i) {
            value[i] = (byte)((Random)rand).nextInt(256);
        }
        return value;
    }

    @Test
    public void testScanWithBatchSizeReturnIncompleteCells() throws IOException, InterruptedException {
        TableDescriptor hd = TableDescriptorBuilder.newBuilder((TableName)this.tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY).setMaxVersions(3).build()).build();
        try (Table table = TEST_UTIL.createTable(hd, (byte[][])null);){
            Result result;
            ArrayList<Result> list;
            TEST_UTIL.waitTableAvailable(this.tableName, (long)WAITTABLE_MILLIS);
            Put put = new Put(ROW);
            put.addColumn(FAMILY, Bytes.toBytes((int)0), FromClientSide3TestBase.generateHugeValue(0x300000));
            table.put(put);
            put = new Put(ROW);
            put.addColumn(FAMILY, Bytes.toBytes((int)1), FromClientSide3TestBase.generateHugeValue(0x400000));
            table.put(put);
            for (int i = 2; i < 5; ++i) {
                for (int version = 0; version < 2; ++version) {
                    put = new Put(ROW);
                    put.addColumn(FAMILY, Bytes.toBytes((int)i), FromClientSide3TestBase.generateHugeValue(1024));
                    table.put(put);
                }
            }
            Scan scan = new Scan();
            scan.withStartRow(ROW).withStopRow(ROW, true).addFamily(FAMILY).setBatch(3).setMaxResultSize(0x400000L);
            try (ResultScanner scanner = table.getScanner(scan);){
                list = new ArrayList<Result>();
                while ((result = scanner.next()) != null) {
                    list.add(result);
                }
                Assertions.assertEquals((int)5, (int)list.stream().mapToInt(Result::size).sum());
                Assertions.assertEquals((int)2, (int)list.size());
                Assertions.assertEquals((int)3, (int)((Result)list.get(0)).size());
                Assertions.assertEquals((int)2, (int)((Result)list.get(1)).size());
            }
            scan = new Scan();
            scan.withStartRow(ROW).withStopRow(ROW, true).addFamily(FAMILY).setBatch(2).setMaxResultSize(0x400000L);
            scanner = table.getScanner(scan);
            var8_13 = null;
            try {
                list = new ArrayList();
                while ((result = scanner.next()) != null) {
                    list.add(result);
                }
                Assertions.assertEquals((int)5, (int)list.stream().mapToInt(Result::size).sum());
                Assertions.assertEquals((int)3, (int)list.size());
                Assertions.assertEquals((int)2, (int)((Result)list.get(0)).size());
                Assertions.assertEquals((int)2, (int)((Result)list.get(1)).size());
                Assertions.assertEquals((int)1, (int)((Result)list.get(2)).size());
            }
            catch (Throwable throwable) {
                var8_13 = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (var8_13 != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            var8_13.addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
    }

    public static class WaitingForScanObserver
    implements RegionCoprocessor,
    RegionObserver {
        private final CountDownLatch latch = new CountDownLatch(1);

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            try {
                this.latch.await();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }

        public RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> e, Scan scan, RegionScanner s) throws IOException {
            this.latch.countDown();
            return s;
        }
    }

    public static class WaitingForMultiMutationsObserver
    implements RegionCoprocessor,
    RegionObserver {
        final CountDownLatch latch = new CountDownLatch(1);

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            try {
                this.latch.await();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
    }
}

