/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.HBaseRpcControllerImpl;
import org.apache.hadoop.hbase.ipc.NettyRpcClient;
import org.apache.hadoop.hbase.ipc.NettyRpcServer;
import org.apache.hadoop.hbase.ipc.NettyServerRpcConnection;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcResponse;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.TestProtobufRpcServiceImpl;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestProtos;
import org.apache.hadoop.hbase.shaded.ipc.protobuf.generated.TestRpcServiceProtos;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RPCTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RPCTests.class, MediumTests.class})
public class TestNettyChannelWritability {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNettyChannelWritability.class);
    private static final MetricsAssertHelper METRICS_ASSERT = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);
    private static final byte[] CELL_BYTES = Bytes.toBytes((String)"xyz");
    private static final KeyValue CELL = new KeyValue(CELL_BYTES, CELL_BYTES, CELL_BYTES, CELL_BYTES);

    @Test
    public void testNettyWritableWatermarks() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.server.netty.writable.watermark.low", 1);
        conf.setInt("hbase.server.netty.writable.watermark.high", 2);
        NettyRpcServer rpcServer = this.createRpcServer(conf, 0);
        try {
            this.sendAndReceive(conf, rpcServer, 5);
            METRICS_ASSERT.assertCounterGt("unwritableTime_numOps", 0L, (BaseSource)rpcServer.metrics.getMetricsSource());
        }
        finally {
            rpcServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNettyWritableFatalThreshold() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.server.netty.writable.watermark.fatal", 1);
        NettyRpcServer rpcServer = this.createRpcServer(conf, 3);
        try {
            CompletionException exception = (CompletionException)Assert.assertThrows(CompletionException.class, () -> this.sendAndReceive(conf, rpcServer, 5));
            Assert.assertTrue((boolean)(exception.getCause().getCause() instanceof ServiceException));
            METRICS_ASSERT.assertCounterGt("maxOutboundBytesExceeded", 0L, (BaseSource)rpcServer.metrics.getMetricsSource());
        }
        finally {
            rpcServer.stop();
        }
    }

    private void sendAndReceive(Configuration conf, NettyRpcServer rpcServer, int requestCount) throws Exception {
        ArrayList<KeyValue> cells = new ArrayList<KeyValue>();
        int count = 3;
        for (int i = 0; i < count; ++i) {
            cells.add(CELL);
        }
        try (NettyRpcClient client = new NettyRpcClient(conf);){
            rpcServer.start();
            TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub = TestProtobufRpcServiceImpl.newBlockingStub((RpcClient)client, rpcServer.getListenerAddress());
            CompletableFuture[] futures = new CompletableFuture[requestCount];
            for (int i = 0; i < requestCount; ++i) {
                futures[i] = CompletableFuture.runAsync(() -> {
                    try {
                        this.sendMessage(cells, stub);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            CompletableFuture.allOf(futures).join();
        }
    }

    private void sendMessage(List<Cell> cells, TestRpcServiceProtos.TestProtobufRpcProto.BlockingInterface stub) throws Exception {
        HBaseRpcControllerImpl pcrc = new HBaseRpcControllerImpl(CellUtil.createCellScanner(cells));
        String message = "hello";
        Assert.assertEquals((Object)message, (Object)stub.echo((RpcController)pcrc, TestProtos.EchoRequestProto.newBuilder().setMessage(message).build()).getMessage());
        int index = 0;
        CellScanner cellScanner = pcrc.cellScanner();
        Assert.assertNotNull((Object)cellScanner);
        while (cellScanner.advance()) {
            Assert.assertEquals((Object)CELL, (Object)cellScanner.current());
            ++index;
        }
        Assert.assertEquals((long)cells.size(), (long)index);
    }

    private NettyRpcServer createRpcServer(Configuration conf, final int flushAfter) throws IOException {
        String name = "testRpcServer";
        ArrayList services = Lists.newArrayList((Object[])new RpcServer.BlockingServiceAndInterface[]{new RpcServer.BlockingServiceAndInterface(TestProtobufRpcServiceImpl.SERVICE, null)});
        InetSocketAddress bindAddress = new InetSocketAddress("localhost", 0);
        FifoRpcScheduler scheduler = new FifoRpcScheduler(conf, 1);
        final AtomicInteger writeCount = new AtomicInteger(0);
        return new NettyRpcServer(null, name, services, bindAddress, conf, (RpcScheduler)scheduler, true){

            protected NettyServerRpcConnection createNettyServerRpcConnection(Channel channel) {
                return new NettyServerRpcConnection(this, channel){

                    protected void doRespond(RpcResponse resp) {
                        if (writeCount.incrementAndGet() >= flushAfter) {
                            super.doRespond(resp);
                        } else {
                            this.channel.write((Object)resp);
                        }
                    }
                };
            }
        };
    }
}

