/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.StartMiniClusterOption;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={LargeTests.class})
public class TestRecreateCluster {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRecreateCluster.class);
    @Rule
    public TestName name = new TestName();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final int NUM_RS = 3;
    private static final long TIMEOUT_MS = Duration.ofMinutes(1L).toMillis();
    private static final long MASTER_INIT_TIMEOUT_MS = Duration.ofSeconds(45L).toMillis();

    @Before
    public void setup() throws Exception {
        TEST_UTIL.getConfiguration().setLong("hbase.master.init.timeout.localHBaseCluster", MASTER_INIT_TIMEOUT_MS);
        TEST_UTIL.startMiniCluster(StartMiniClusterOption.builder().numRegionServers(3).numDataNodes(3).createWALDir(true).build());
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRecreateCluster_UserTableDisabled_ReuseWALsAndZNodes() throws Exception {
        this.validateRecreateClusterWithUserDisabled(false, false);
    }

    @Test
    public void testRecreateCluster_UserTableEnabled_ReuseWALsAndZNodes() throws Exception {
        this.validateRecreateClusterWithUserTableEnabled(false, false);
    }

    @Test
    public void testRecreateCluster_UserTableEnabled_CleanupZNodes() throws Exception {
        this.validateRecreateClusterWithUserTableEnabled(false, true);
    }

    @Test
    public void testRecreateCluster_UserTableEnabled_CleanupWALAndZNodes() throws Exception {
        this.validateRecreateClusterWithUserTableEnabled(true, true);
    }

    private void validateRecreateClusterWithUserDisabled(boolean cleanupWALs, boolean cleanUpZNodes) throws Exception {
        TableName tableName = TableName.valueOf((String)"t1");
        this.prepareDataBeforeRecreate(TEST_UTIL, tableName);
        TEST_UTIL.getAdmin().disableTable(tableName);
        TEST_UTIL.waitTableDisabled(tableName.getName());
        this.restartHBaseCluster(cleanupWALs, cleanUpZNodes);
        TEST_UTIL.getAdmin().enableTable(tableName);
        this.validateDataAfterRecreate(TEST_UTIL, tableName);
    }

    private void validateRecreateClusterWithUserTableEnabled(boolean cleanupWALs, boolean cleanUpZNodes) throws Exception {
        TableName tableName = TableName.valueOf((String)"t1");
        this.prepareDataBeforeRecreate(TEST_UTIL, tableName);
        this.restartHBaseCluster(cleanupWALs, cleanUpZNodes);
        this.validateDataAfterRecreate(TEST_UTIL, tableName);
    }

    private void restartHBaseCluster(boolean cleanUpWALs, boolean cleanUpZnodes) throws Exception {
        TEST_UTIL.getMiniHBaseCluster().flushcache(TableName.META_TABLE_NAME);
        TEST_UTIL.getMiniHBaseCluster().flushcache();
        List oldServers = TEST_UTIL.getHBaseCluster().getMaster().getServerManager().getOnlineServersList();
        TEST_UTIL.waitFor(TIMEOUT_MS, () -> TEST_UTIL.getHBaseCluster().getMaster().getProcedures().stream().filter(p -> p.isFinished()).findAny().isPresent());
        Path walRootDirPath = TEST_UTIL.getMiniHBaseCluster().getMaster().getWALRootDir();
        Path rootDirPath = CommonFSUtils.getRootDir((Configuration)TEST_UTIL.getConfiguration());
        TEST_UTIL.shutdownMiniHBaseCluster();
        if (cleanUpWALs) {
            TEST_UTIL.getDFSCluster().getFileSystem().delete(walRootDirPath, true);
        }
        if (cleanUpZnodes) {
            ZKUtil.deleteChildrenRecursively((ZKWatcher)TEST_UTIL.getZooKeeperWatcher(), (String)TestRecreateCluster.TEST_UTIL.getZooKeeperWatcher().getZNodePaths().baseZNode);
            TEST_UTIL.shutdownMiniZKCluster();
            TEST_UTIL.startMiniZKCluster();
        }
        TEST_UTIL.restartHBaseCluster(3);
        TEST_UTIL.waitFor(TIMEOUT_MS, () -> TEST_UTIL.getMiniHBaseCluster().getNumLiveRegionServers() == 3);
        List newServers = TEST_UTIL.getHBaseCluster().getMaster().getServerManager().getOnlineServersList();
        Assert.assertFalse((boolean)newServers.stream().filter(newServer -> oldServers.contains(newServer)).findAny().isPresent());
    }

    private void prepareDataBeforeRecreate(HBaseTestingUtility testUtil, TableName tableName) throws Exception {
        Table table = testUtil.createTable(tableName, "f");
        Put put = new Put(Bytes.toBytes((String)"r1"));
        put.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"v"));
        table.put(put);
        this.ensureTableNotColocatedWithSystemTable(tableName, TableName.NAMESPACE_TABLE_NAME);
    }

    private void ensureTableNotColocatedWithSystemTable(TableName userTable, TableName systemTable) throws IOException, InterruptedException {
        MiniHBaseCluster hbaseCluster = TEST_UTIL.getHBaseCluster();
        Assert.assertTrue((String)"Please start more than 1 regionserver", (hbaseCluster.getRegionServerThreads().size() > 1 ? 1 : 0) != 0);
        int userTableServerNum = this.getServerNumForTableWithOnlyOneRegion(userTable);
        int systemTableServerNum = this.getServerNumForTableWithOnlyOneRegion(systemTable);
        if (userTableServerNum != systemTableServerNum) {
            return;
        }
        int destServerNum = (systemTableServerNum + 1) % 3;
        Assert.assertTrue((systemTableServerNum != destServerNum ? 1 : 0) != 0);
        HRegionServer systemTableServer = hbaseCluster.getRegionServer(systemTableServerNum);
        HRegionServer destServer = hbaseCluster.getRegionServer(destServerNum);
        Assert.assertTrue((!systemTableServer.equals(destServer) ? 1 : 0) != 0);
        hbaseCluster.waitForRegionServerToStart(destServer.getServerName().getHostname(), destServer.getServerName().getPort(), TIMEOUT_MS);
        TEST_UTIL.moveRegionAndWait((RegionInfo)TEST_UTIL.getAdmin().getRegions(userTable).get(0), destServer.getServerName());
    }

    private int getServerNumForTableWithOnlyOneRegion(TableName tableName) throws IOException {
        List tableRegionInfos = TEST_UTIL.getAdmin().getRegions(tableName);
        Assert.assertEquals((long)1L, (long)tableRegionInfos.size());
        return TEST_UTIL.getHBaseCluster().getServerWith(((RegionInfo)tableRegionInfos.get(0)).getRegionName());
    }

    private void validateDataAfterRecreate(HBaseTestingUtility testUtil, TableName tableName) throws Exception {
        Table t1 = testUtil.getConnection().getTable(tableName);
        Get get = new Get(Bytes.toBytes((String)"r1"));
        get.addColumn(Bytes.toBytes((String)"f"), Bytes.toBytes((String)"c"));
        Result result = t1.get(get);
        Assert.assertTrue((boolean)result.advance());
        Cell cell = result.current();
        Assert.assertEquals((Object)"v", (Object)Bytes.toString((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength()));
        Assert.assertFalse((boolean)result.advance());
    }
}

