/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.master.procedure.EnableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.SnapshotProcedure;
import org.apache.hadoop.hbase.master.procedure.TestSnapshotProcedure;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotProcedureConcurrently
extends TestSnapshotProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotProcedureConcurrently.class);

    @Test
    public void testRunningTwoSnapshotProcedureOnSameTable() throws Exception {
        String newSnapshotName = this.SNAPSHOT_NAME + "_2";
        SnapshotProtos.SnapshotDescription snapshotProto2 = SnapshotProtos.SnapshotDescription.newBuilder((SnapshotProtos.SnapshotDescription)this.snapshotProto).setName(newSnapshotName).build();
        ProcedureExecutor procExec = this.master.getMasterProcedureExecutor();
        MasterProcedureEnv env = (MasterProcedureEnv)procExec.getEnvironment();
        SnapshotProcedure sp1 = new SnapshotProcedure(env, this.snapshotProto);
        SnapshotProcedure sp2 = new SnapshotProcedure(env, snapshotProto2);
        SnapshotProcedure spySp1 = this.getDelayedOnSpecificStateSnapshotProcedure(sp1, (MasterProcedureEnv)procExec.getEnvironment(), MasterProcedureProtos.SnapshotState.SNAPSHOT_SNAPSHOT_ONLINE_REGIONS);
        SnapshotProcedure spySp2 = this.getDelayedOnSpecificStateSnapshotProcedure(sp2, (MasterProcedureEnv)procExec.getEnvironment(), MasterProcedureProtos.SnapshotState.SNAPSHOT_SNAPSHOT_ONLINE_REGIONS);
        long procId1 = procExec.submitProcedure((Procedure)spySp1);
        long procId2 = procExec.submitProcedure((Procedure)spySp2);
        TEST_UTIL.waitFor(2000L, () -> env.getMasterServices().getProcedures().stream().map(Procedure::getProcId).collect(Collectors.toList()).containsAll(Arrays.asList(procId1, procId2)));
        Assert.assertFalse((boolean)procExec.isFinished(procId1));
        Assert.assertFalse((boolean)procExec.isFinished(procId2));
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)this.master.getMasterProcedureExecutor(), (long)procId1);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)this.master.getMasterProcedureExecutor(), (long)procId2);
        List snapshots = this.master.getSnapshotManager().getCompletedSnapshots();
        Assert.assertEquals((long)2L, (long)snapshots.size());
        snapshots.sort(Comparator.comparing(SnapshotProtos.SnapshotDescription::getName));
        Assert.assertEquals((Object)this.SNAPSHOT_NAME, (Object)((SnapshotProtos.SnapshotDescription)snapshots.get(0)).getName());
        Assert.assertEquals((Object)newSnapshotName, (Object)((SnapshotProtos.SnapshotDescription)snapshots.get(1)).getName());
        SnapshotTestingUtils.confirmSnapshotValid(TEST_UTIL, this.snapshotProto, this.TABLE_NAME, this.CF);
        SnapshotTestingUtils.confirmSnapshotValid(TEST_UTIL, snapshotProto2, this.TABLE_NAME, this.CF);
    }

    @Test
    public void testTakeZkCoordinatedSnapshotAndProcedureCoordinatedSnapshotBoth() throws Exception {
        String newSnapshotName = this.SNAPSHOT_NAME + "_2";
        Thread first = new Thread("procedure-snapshot"){

            @Override
            public void run() {
                try {
                    TestSnapshotProcedure.TEST_UTIL.getAdmin().snapshot(TestSnapshotProcedureConcurrently.this.snapshot);
                }
                catch (IOException e) {
                    TestSnapshotProcedure.LOG.error("procedure snapshot failed", (Throwable)e);
                    Assert.fail((String)"procedure snapshot failed");
                }
            }
        };
        first.start();
        Thread.sleep(1000L);
        SnapshotManager sm = this.master.getSnapshotManager();
        TEST_UTIL.waitFor(2000L, 50L, () -> !sm.isTakingSnapshot(this.TABLE_NAME) && sm.isTableTakingAnySnapshot(this.TABLE_NAME));
        TEST_UTIL.getConfiguration().setBoolean("hbase.snapshot.zk.coordinated", true);
        SnapshotDescription snapshotOnSameTable = new SnapshotDescription(newSnapshotName, this.TABLE_NAME, SnapshotType.SKIPFLUSH);
        final SnapshotProtos.SnapshotDescription snapshotOnSameTableProto = ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)snapshotOnSameTable);
        Thread second = new Thread("zk-snapshot"){

            @Override
            public void run() {
                try {
                    TestSnapshotProcedureConcurrently.this.master.getSnapshotManager().takeSnapshot(snapshotOnSameTableProto);
                }
                catch (IOException e) {
                    TestSnapshotProcedure.LOG.error("zk snapshot failed", (Throwable)e);
                    Assert.fail((String)"zk snapshot failed");
                }
            }
        };
        second.start();
        TEST_UTIL.waitFor(2000L, () -> sm.isTakingSnapshot(this.TABLE_NAME));
        TEST_UTIL.waitFor(60000L, () -> sm.isSnapshotDone(snapshotOnSameTableProto) && !sm.isTakingAnySnapshot());
        SnapshotTestingUtils.confirmSnapshotValid(TEST_UTIL, this.snapshotProto, this.TABLE_NAME, this.CF);
        SnapshotTestingUtils.confirmSnapshotValid(TEST_UTIL, snapshotOnSameTableProto, this.TABLE_NAME, this.CF);
    }

    @Test
    public void testItFailsIfTableIsNotDisabledOrEnabled() throws Exception {
        ProcedureExecutor executor = this.master.getMasterProcedureExecutor();
        MasterProcedureEnv env = (MasterProcedureEnv)executor.getEnvironment();
        TEST_UTIL.getAdmin().disableTable(this.TABLE_NAME);
        TestEnableTableProcedure enableTable = new TestEnableTableProcedure((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment(), this.TABLE_NAME);
        long enableProcId = executor.submitProcedure((Procedure)enableTable);
        TEST_UTIL.waitFor(60000L, () -> {
            Procedure proc = executor.getProcedure(enableProcId);
            if (proc == null) {
                return false;
            }
            return ((TestEnableTableProcedure)proc).getProcedureState() == MasterProcedureProtos.EnableTableState.ENABLE_TABLE_MARK_REGIONS_ONLINE;
        });
        SnapshotProcedure snapshotProc = new SnapshotProcedure(env, this.snapshotProto);
        long snapshotProcId = executor.submitProcedure((Procedure)snapshotProc);
        TEST_UTIL.waitTableEnabled(this.TABLE_NAME);
        TEST_UTIL.waitFor(60000L, () -> executor.getProcedure(snapshotProcId) != null);
        TEST_UTIL.waitFor(60000L, () -> executor.getProcedure(snapshotProcId) == null);
        SnapshotTestingUtils.confirmSnapshotValid(TEST_UTIL, this.snapshotProto, this.TABLE_NAME, this.CF);
    }

    public static class TestEnableTableProcedure
    extends EnableTableProcedure {
        public TestEnableTableProcedure() {
        }

        public TestEnableTableProcedure(MasterProcedureEnv env, TableName tableName) {
            super(env, tableName);
        }

        public MasterProcedureProtos.EnableTableState getProcedureState() {
            return this.getState(this.stateCount);
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.EnableTableState state) throws InterruptedException {
            if (state == MasterProcedureProtos.EnableTableState.ENABLE_TABLE_MARK_REGIONS_ONLINE) {
                Thread.sleep(10000L);
            }
            return super.executeFromState(env, state);
        }
    }
}

