/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.procedure.SnapshotRegionProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestSnapshotRegionProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotRegionProcedure.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotRegionProcedure.class);
    private static HBaseTestingUtility TEST_UTIL;
    private HMaster master;
    private TableName tableName;
    private SnapshotProtos.SnapshotDescription snapshotProto;
    private Path workingDir;
    private FileSystem workingDirFs;

    @Before
    public void setup() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.procedure.remote.dispatcher.delay.msec", 10000);
        conf.setInt("hbase.procedure.remote.dispatcher.max.queue.size", 128);
        TEST_UTIL.startMiniCluster(3);
        this.master = TEST_UTIL.getHBaseCluster().getMaster();
        this.tableName = TableName.valueOf((byte[])Bytes.toBytes((String)"SRPTestTable"));
        byte[] cf = Bytes.toBytes((String)"cf");
        String SNAPSHOT_NAME = "SnapshotRegionProcedureTest";
        SnapshotDescription snapshot = new SnapshotDescription(SNAPSHOT_NAME, this.tableName, SnapshotType.FLUSH);
        this.snapshotProto = ProtobufUtil.createHBaseProtosSnapshotDesc((SnapshotDescription)snapshot);
        this.snapshotProto = SnapshotDescriptionUtils.validate((SnapshotProtos.SnapshotDescription)this.snapshotProto, (Configuration)this.master.getConfiguration());
        byte[][] splitKeys = new RegionSplitter.HexStringSplit().split(10);
        Table table = TEST_UTIL.createTable(this.tableName, cf, splitKeys);
        TEST_UTIL.loadTable(table, cf, false);
        Path rootDir = CommonFSUtils.getRootDir((Configuration)conf);
        this.workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((SnapshotProtos.SnapshotDescription)this.snapshotProto, (Path)rootDir, (Configuration)conf);
        this.workingDirFs = this.workingDir.getFileSystem(conf);
        if (!this.workingDirFs.exists(this.workingDir)) {
            this.workingDirFs.mkdirs(this.workingDir);
        }
    }

    private boolean assertRegionManifestGenerated(RegionInfo region) throws Exception {
        String regionManifest = "region-manifest." + region.getEncodedName();
        Path targetPath = new Path(this.workingDir, regionManifest);
        return this.workingDirFs.exists(targetPath);
    }

    @Test
    public void testSimpleSnapshotRegion() throws Exception {
        ProcedureExecutor procExec = this.master.getMasterProcedureExecutor();
        List regions = this.master.getAssignmentManager().getTableRegionsAndLocations(this.tableName, true);
        Assert.assertEquals((long)10L, (long)regions.size());
        Pair region = (Pair)regions.get(0);
        SnapshotRegionProcedure srp = new SnapshotRegionProcedure(this.snapshotProto, (RegionInfo)region.getFirst());
        long procId = procExec.submitProcedure((Procedure)srp);
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        Assert.assertTrue((boolean)this.assertRegionManifestGenerated((RegionInfo)region.getFirst()));
    }

    @Test
    public void testRegionServerCrashWhileTakingSnapshotRegion() throws Exception {
        ProcedureExecutor procExec = this.master.getMasterProcedureExecutor();
        List regions = this.master.getAssignmentManager().getTableRegionsAndLocations(this.tableName, true);
        Assert.assertEquals((long)10L, (long)regions.size());
        Pair pair = (Pair)regions.get(0);
        SnapshotRegionProcedure srp = new SnapshotRegionProcedure(this.snapshotProto, (RegionInfo)pair.getFirst());
        long procId = procExec.submitProcedure((Procedure)srp);
        TEST_UTIL.getHBaseCluster().killRegionServer((ServerName)pair.getSecond());
        TEST_UTIL.waitFor(60000L, () -> !((ServerName)pair.getSecond()).equals((Object)this.master.getAssignmentManager().getRegionStates().getRegionStateNode((RegionInfo)pair.getFirst()).getRegionLocation()));
        TEST_UTIL.waitFor(60000L, () -> srp.inRetrying());
        ProcedureTestingUtility.waitProcedure((ProcedureExecutor)procExec, (long)procId);
        Assert.assertTrue((boolean)this.assertRegionManifestGenerated((RegionInfo)pair.getFirst()));
    }

    @After
    public void teardown() throws Exception {
        if (this.master != null) {
            ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate((ProcedureExecutor)this.master.getMasterProcedureExecutor(), (boolean)false);
        }
        TEST_UTIL.shutdownMiniCluster();
    }
}

