/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.region;

import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.ipc.RpcCall;
import org.apache.hadoop.hbase.ipc.RpcCallback;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStoreTestBase;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStoreTestProcedure;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestRegionProcedureStore
extends RegionProcedureStoreTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionProcedureStore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestRegionProcedureStore.class);

    private void verifyProcIdsOnRestart(Set<Long> procIds) throws Exception {
        LOG.debug("expected: " + procIds);
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        ProcedureTestingUtility.storeRestart((ProcedureStore)this.store, (boolean)true, (ProcedureStore.ProcedureLoader)loader);
        Assert.assertEquals((long)procIds.size(), (long)loader.getLoadedCount());
        Assert.assertEquals((long)0L, (long)loader.getCorruptedCount());
    }

    @Test
    public void testLoad() throws Exception {
        HashSet<Long> procIds = new HashSet<Long>();
        RegionProcedureStoreTestProcedure proc1 = new RegionProcedureStoreTestProcedure();
        procIds.add(proc1.getProcId());
        this.store.insert((Procedure)proc1, null);
        RegionProcedureStoreTestProcedure proc2 = new RegionProcedureStoreTestProcedure();
        RegionProcedureStoreTestProcedure proc3 = new RegionProcedureStoreTestProcedure();
        proc3.setParent((Procedure<?>)proc2);
        RegionProcedureStoreTestProcedure proc4 = new RegionProcedureStoreTestProcedure();
        proc4.setParent((Procedure<?>)proc2);
        procIds.add(proc2.getProcId());
        procIds.add(proc3.getProcId());
        procIds.add(proc4.getProcId());
        this.store.insert((Procedure)proc2, new Procedure[]{proc3, proc4});
        this.verifyProcIdsOnRestart(procIds);
        proc1.finish();
        this.store.update((Procedure)proc1);
        proc4.finish();
        this.store.update((Procedure)proc4);
        this.store.delete(proc4.getProcId());
        procIds.remove(proc4.getProcId());
        this.verifyProcIdsOnRestart(procIds);
    }

    @Test
    public void testCleanup() throws Exception {
        RegionProcedureStoreTestProcedure proc1 = new RegionProcedureStoreTestProcedure();
        this.store.insert((Procedure)proc1, null);
        RegionProcedureStoreTestProcedure proc2 = new RegionProcedureStoreTestProcedure();
        this.store.insert((Procedure)proc2, null);
        RegionProcedureStoreTestProcedure proc3 = new RegionProcedureStoreTestProcedure();
        this.store.insert((Procedure)proc3, null);
        ProcedureTestingUtility.LoadCounter loader = new ProcedureTestingUtility.LoadCounter();
        this.store.load((ProcedureStore.ProcedureLoader)loader);
        Assert.assertEquals((long)proc3.getProcId(), (long)loader.getMaxProcId());
        Assert.assertEquals((long)3L, (long)loader.getRunnableCount());
        this.store.delete(proc3.getProcId());
        this.store.delete(proc2.getProcId());
        loader = new ProcedureTestingUtility.LoadCounter();
        this.store.load((ProcedureStore.ProcedureLoader)loader);
        Assert.assertEquals((long)proc3.getProcId(), (long)loader.getMaxProcId());
        Assert.assertEquals((long)1L, (long)loader.getRunnableCount());
        Assert.assertTrue((boolean)this.store.region.get(new Get(Bytes.toBytes((long)proc3.getProcId())).setCheckExistenceOnly(true)).getExists());
        Assert.assertTrue((boolean)this.store.region.get(new Get(Bytes.toBytes((long)proc2.getProcId())).setCheckExistenceOnly(true)).getExists());
        this.store.cleanup();
        Assert.assertTrue((boolean)this.store.region.get(new Get(Bytes.toBytes((long)proc3.getProcId())).setCheckExistenceOnly(true)).getExists());
        Assert.assertFalse((boolean)this.store.region.get(new Get(Bytes.toBytes((long)proc2.getProcId())).setCheckExistenceOnly(true)).getExists());
        RegionProcedureStoreTestProcedure proc4 = new RegionProcedureStoreTestProcedure();
        this.store.insert((Procedure)proc4, null);
        this.store.cleanup();
        Assert.assertFalse((boolean)this.store.region.get(new Get(Bytes.toBytes((long)proc3.getProcId())).setCheckExistenceOnly(true)).getExists());
    }

    @Test
    public void testInsertWithRpcCall() throws Exception {
        RpcServer.setCurrentCall((RpcCall)this.newRpcCallWithDeadline());
        RegionProcedureStoreTestProcedure proc1 = new RegionProcedureStoreTestProcedure();
        this.store.insert((Procedure)proc1, null);
        RpcServer.setCurrentCall(null);
    }

    private RpcCall newRpcCallWithDeadline() {
        return new RpcCall(){

            public long getDeadline() {
                return EnvironmentEdgeManager.currentTime();
            }

            public BlockingService getService() {
                return null;
            }

            public Descriptors.MethodDescriptor getMethod() {
                return null;
            }

            public Message getParam() {
                return null;
            }

            public CellScanner getCellScanner() {
                return null;
            }

            public long getReceiveTime() {
                return 0L;
            }

            public long getStartTime() {
                return 0L;
            }

            public void setStartTime(long startTime) {
            }

            public int getTimeout() {
                return 0;
            }

            public int getPriority() {
                return 0;
            }

            public long getSize() {
                return 0L;
            }

            public RPCProtos.RequestHeader getHeader() {
                return null;
            }

            public Map<String, byte[]> getConnectionAttributes() {
                return null;
            }

            public Map<String, byte[]> getRequestAttributes() {
                return null;
            }

            public byte[] getRequestAttribute(String key) {
                return null;
            }

            public int getRemotePort() {
                return 0;
            }

            public void setResponse(Message param, CellScanner cells, Throwable errorThrowable, String error) {
            }

            public void sendResponseIfReady() throws IOException {
            }

            public void cleanup() {
            }

            public String toShortString() {
                return null;
            }

            public long disconnectSince() {
                return 0L;
            }

            public boolean isClientCellBlockSupported() {
                return false;
            }

            public Optional<User> getRequestUser() {
                return Optional.empty();
            }

            public Optional<X509Certificate[]> getClientCertificateChain() {
                return Optional.empty();
            }

            public InetAddress getRemoteAddress() {
                return null;
            }

            public HBaseProtos.VersionInfo getClientVersionInfo() {
                return null;
            }

            public void setCallBack(RpcCallback callback) {
            }

            public boolean isRetryImmediatelySupported() {
                return false;
            }

            public long getResponseCellSize() {
                return 0L;
            }

            public void incrementResponseCellSize(long cellSize) {
            }

            public long getBlockBytesScanned() {
                return 0L;
            }

            public void incrementBlockBytesScanned(long blockSize) {
            }

            public long getResponseExceptionSize() {
                return 0L;
            }

            public void incrementResponseExceptionSize(long exceptionSize) {
            }
        };
    }
}

