/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.ThrottleQuotaTestUtil;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestDefaultAtomicQuota {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDefaultAtomicQuota.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName TABLE_NAME = TableName.valueOf((String)UUID.randomUUID().toString());
    private static final int REFRESH_TIME = 5;
    private static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");

    @AfterClass
    public static void tearDown() throws Exception {
        ThrottleQuotaTestUtil.clearQuotaCache(TEST_UTIL);
        EnvironmentEdgeManager.reset();
        TEST_UTIL.deleteTable(TABLE_NAME);
        TEST_UTIL.shutdownMiniCluster();
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 5);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.default.user.machine.atomic.read.size", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.default.user.machine.atomic.request.num", 1);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.default.user.machine.atomic.write.size", 1);
        TEST_UTIL.getConfiguration().setFloat("hfile.block.cache.size", 0.0f);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
        TEST_UTIL.createTable(TABLE_NAME, FAMILY);
        TEST_UTIL.waitTableAvailable(TABLE_NAME);
        TEST_UTIL.flush(TABLE_NAME);
    }

    @Test
    public void testDefaultAtomicReadLimits() throws Exception {
        TEST_UTIL.waitFor(60000L, () -> this.runIncTest(100) < 100L);
        this.configureLenientThrottle(ThrottleType.ATOMIC_READ_SIZE);
        this.configureLenientThrottle(ThrottleType.ATOMIC_REQUEST_NUMBER);
        this.refreshQuotas();
        TEST_UTIL.waitFor(60000L, () -> this.runIncTest(100) == 100L);
        this.unsetQuota();
        TEST_UTIL.waitFor(60000L, () -> this.runIncTest(100) < 100L);
    }

    @Test
    public void testDefaultAtomicWriteLimits() throws Exception {
        TEST_UTIL.waitFor(60000L, () -> this.runIncTest(100) < 100L);
        this.configureLenientThrottle(ThrottleType.ATOMIC_WRITE_SIZE);
        this.refreshQuotas();
        TEST_UTIL.waitFor(60000L, () -> this.runIncTest(100) == 100L);
        this.unsetQuota();
        TEST_UTIL.waitFor(60000L, () -> this.runIncTest(100) < 100L);
    }

    private void configureLenientThrottle(ThrottleType throttleType) throws IOException {
        try (Admin admin = TEST_UTIL.getAdmin();){
            admin.setQuota(QuotaSettingsFactory.throttleUser((String)TestDefaultAtomicQuota.getUserName(), (ThrottleType)throttleType, (long)100000L, (TimeUnit)TimeUnit.SECONDS));
        }
    }

    private static String getUserName() throws IOException {
        return User.getCurrent().getShortName();
    }

    private void refreshQuotas() throws Exception {
        ThrottleQuotaTestUtil.triggerUserCacheRefresh(TEST_UTIL, false, TABLE_NAME);
        ThrottleQuotaTestUtil.waitMinuteQuota();
    }

    private void unsetQuota() throws Exception {
        try (Admin admin = TEST_UTIL.getAdmin();){
            admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)TestDefaultAtomicQuota.getUserName()));
        }
        this.refreshQuotas();
    }

    private long runIncTest(int attempts) throws Exception {
        this.refreshQuotas();
        try (Table table = this.getTable();){
            long l = ThrottleQuotaTestUtil.doIncrements(attempts, FAMILY, QUALIFIER, table);
            return l;
        }
    }

    private Table getTable() throws IOException {
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 1);
        return TEST_UTIL.getConnection().getTableBuilder(TABLE_NAME, null).setOperationTimeout(250).build();
    }
}

