/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaScope;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.RegionServerRpcQuotaManager;
import org.apache.hadoop.hbase.quotas.SpaceLimitSettings;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.quotas.ThrottleSettings;
import org.apache.hadoop.hbase.quotas.ThrottleType;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClientTests.class, LargeTests.class})
public class TestQuotaAdmin {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestQuotaAdmin.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestQuotaAdmin.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final TableName[] TABLE_NAMES = new TableName[]{TableName.valueOf((String)"TestQuotaAdmin0"), TableName.valueOf((String)"TestQuotaAdmin1"), TableName.valueOf((String)"TestQuotaAdmin2")};
    private static final String[] NAMESPACES = new String[]{"NAMESPACE01", "NAMESPACE02", "NAMESPACE03"};

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        TEST_UTIL.getConfiguration().setInt("hbase.quota.refresh.period", 2000);
        TEST_UTIL.getConfiguration().setInt("hbase.hstore.compactionThreshold", 10);
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 100);
        TEST_UTIL.getConfiguration().setInt("hbase.client.pause", 250);
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 6);
        TEST_UTIL.getConfiguration().setBoolean("hbase.master.enabletable.roundrobin", true);
        TEST_UTIL.startMiniCluster(1);
        TEST_UTIL.waitTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
    }

    @After
    public void clearQuotaTable() throws Exception {
        if (TEST_UTIL.getAdmin().tableExists(QuotaUtil.QUOTA_TABLE_NAME)) {
            TEST_UTIL.getAdmin().disableTable(QuotaUtil.QUOTA_TABLE_NAME);
            TEST_UTIL.getAdmin().truncateTable(QuotaUtil.QUOTA_TABLE_NAME, false);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testThrottleType() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.READ_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.WRITE_NUMBER, (long)12L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)true));
        try (QuotaRetriever scanner = new QuotaRetriever(TEST_UTIL.getConnection());){
            int countThrottle = 0;
            int countGlobalBypass = 0;
            block13: for (QuotaSettings settings : scanner) {
                switch (settings.getQuotaType()) {
                    case THROTTLE: {
                        ThrottleSettings throttle = (ThrottleSettings)settings;
                        if (throttle.getSoftLimit() == 6L) {
                            Assert.assertEquals((Object)ThrottleType.READ_NUMBER, (Object)throttle.getThrottleType());
                        } else if (throttle.getSoftLimit() == 12L) {
                            Assert.assertEquals((Object)ThrottleType.WRITE_NUMBER, (Object)throttle.getThrottleType());
                        } else {
                            Assert.fail((String)"should not come here, because don't set quota with this limit");
                        }
                        Assert.assertEquals((Object)userName, (Object)throttle.getUserName());
                        Assert.assertEquals(null, (Object)throttle.getTableName());
                        Assert.assertEquals(null, (Object)throttle.getNamespace());
                        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)throttle.getTimeUnit()));
                        ++countThrottle;
                        continue block13;
                    }
                    case GLOBAL_BYPASS: {
                        ++countGlobalBypass;
                        continue block13;
                    }
                }
                Assert.fail((String)("unexpected settings type: " + settings.getQuotaType()));
            }
            Assert.assertEquals((long)2L, (long)countThrottle);
            Assert.assertEquals((long)1L, (long)countGlobalBypass);
        }
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        this.assertNumResults(1, null);
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)false));
        this.assertNumResults(0, null);
    }

    @Test
    public void testSimpleScan() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)true));
        try (QuotaRetriever scanner = new QuotaRetriever(TEST_UTIL.getConnection());){
            int countThrottle = 0;
            int countGlobalBypass = 0;
            block13: for (QuotaSettings settings : scanner) {
                LOG.debug(Objects.toString(settings));
                switch (settings.getQuotaType()) {
                    case THROTTLE: {
                        ThrottleSettings throttle = (ThrottleSettings)settings;
                        Assert.assertEquals((Object)userName, (Object)throttle.getUserName());
                        Assert.assertEquals(null, (Object)throttle.getTableName());
                        Assert.assertEquals(null, (Object)throttle.getNamespace());
                        Assert.assertEquals(null, (Object)throttle.getRegionServer());
                        Assert.assertEquals((long)6L, (long)throttle.getSoftLimit());
                        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)throttle.getTimeUnit()));
                        ++countThrottle;
                        continue block13;
                    }
                    case GLOBAL_BYPASS: {
                        ++countGlobalBypass;
                        continue block13;
                    }
                }
                Assert.fail((String)("unexpected settings type: " + settings.getQuotaType()));
            }
            Assert.assertEquals((long)1L, (long)countThrottle);
            Assert.assertEquals((long)1L, (long)countGlobalBypass);
        }
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName));
        this.assertNumResults(1, null);
        admin.setQuota(QuotaSettingsFactory.bypassGlobals((String)userName, (boolean)false));
        this.assertNumResults(0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiQuotaThrottling() throws Exception {
        byte[] FAMILY = Bytes.toBytes((String)"testFamily");
        byte[] ROW = Bytes.toBytes((String)"testRow");
        byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
        byte[] VALUE = Bytes.toBytes((String)"testValue");
        Admin admin = TEST_UTIL.getAdmin();
        TableName tableName = TableName.valueOf((String)"testMultiQuotaThrottling");
        TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build();
        admin.createTable(desc);
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)tableName, (ThrottleType)ThrottleType.WRITE_NUMBER, (long)6L, (TimeUnit)TimeUnit.SECONDS));
        Thread.sleep(1000L);
        TEST_UTIL.getRSForFirstRegionInTable(tableName).getRegionServerRpcQuotaManager().getQuotaCache().triggerCacheRefresh();
        Thread.sleep(1000L);
        try (Table t = TEST_UTIL.getConnection().getTable(tableName);){
            int size = 5;
            ArrayList<Put> actions = new ArrayList<Put>();
            Object[] results = new Object[size];
            for (int i = 0; i < size; ++i) {
                Put put1 = new Put(ROW);
                put1.addColumn(FAMILY, QUALIFIER, VALUE);
                actions.add(put1);
            }
            t.batch(actions, results);
            t.batch(actions, results);
        }
    }

    @Test
    public void testQuotaRetrieverFilter() throws Exception {
        String[] users;
        Admin admin = TEST_UTIL.getAdmin();
        TableName[] tables = new TableName[]{TableName.valueOf((String)"T0"), TableName.valueOf((String)"T01"), TableName.valueOf((String)"NS0:T2")};
        String[] namespaces = new String[]{"NS0", "NS01", "NS2"};
        for (String string : users = new String[]{"User0", "User01", "User2"}) {
            admin.setQuota(QuotaSettingsFactory.throttleUser((String)string, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)1L, (TimeUnit)TimeUnit.MINUTES));
            for (TableName tableName : tables) {
                admin.setQuota(QuotaSettingsFactory.throttleUser((String)string, (TableName)tableName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)2L, (TimeUnit)TimeUnit.MINUTES));
            }
            for (String string2 : namespaces) {
                admin.setQuota(QuotaSettingsFactory.throttleUser((String)string, (String)string2, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)3L, (TimeUnit)TimeUnit.MINUTES));
            }
        }
        this.assertNumResults(21, null);
        for (String string : tables) {
            admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)string, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)4L, (TimeUnit)TimeUnit.MINUTES));
        }
        this.assertNumResults(24, null);
        for (String string : namespaces) {
            admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)string, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)5L, (TimeUnit)TimeUnit.MINUTES));
        }
        this.assertNumResults(27, null);
        this.assertNumResults(7, new QuotaFilter().setUserFilter("User0"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User"));
        this.assertNumResults(21, new QuotaFilter().setUserFilter("User.*"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setTableFilter("T0"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setTableFilter("NS.*"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User.*").setTableFilter("T"));
        this.assertNumResults(6, new QuotaFilter().setUserFilter("User.*").setTableFilter("T.*"));
        this.assertNumResults(3, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS0"));
        this.assertNumResults(0, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS"));
        this.assertNumResults(9, new QuotaFilter().setUserFilter("User.*").setNamespaceFilter("NS.*"));
        this.assertNumResults(6, new QuotaFilter().setUserFilter("User.*").setTableFilter("T0").setNamespaceFilter("NS0"));
        this.assertNumResults(1, new QuotaFilter().setTableFilter("T0"));
        this.assertNumResults(0, new QuotaFilter().setTableFilter("T"));
        this.assertNumResults(2, new QuotaFilter().setTableFilter("T.*"));
        this.assertNumResults(3, new QuotaFilter().setTableFilter(".*T.*"));
        this.assertNumResults(1, new QuotaFilter().setNamespaceFilter("NS0"));
        this.assertNumResults(0, new QuotaFilter().setNamespaceFilter("NS"));
        this.assertNumResults(3, new QuotaFilter().setNamespaceFilter("NS.*"));
        for (String string : users) {
            admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)string));
            for (TableName tableName : tables) {
                admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)string, (TableName)tableName));
            }
            for (String string3 : namespaces) {
                admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)string, (String)string3));
            }
        }
        this.assertNumResults(6, null);
        for (String string : tables) {
            admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)string));
        }
        this.assertNumResults(3, null);
        for (String string : namespaces) {
            admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)string));
        }
        this.assertNumResults(0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetGetRemoveSpaceQuota() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        TableName tn = TableName.valueOf((String)"sq_table1");
        long sizeLimit = 0x50000000000L;
        SpaceViolationPolicy violationPolicy = SpaceViolationPolicy.NO_WRITES;
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x50000000000L, (SpaceViolationPolicy)violationPolicy);
        admin.setQuota(settings);
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner scanner = quotaTable.getScanner(new Scan());){
            Result r = (Result)Iterables.getOnlyElement((Iterable)scanner);
            CellScanner cells = r.cellScanner();
            Assert.assertTrue((String)"Expected to find a cell", (boolean)cells.advance());
            this.assertSpaceQuota(0x50000000000L, violationPolicy, cells.current());
        }
        var8_7 = null;
        try (QuotaRetriever scanner = new QuotaRetriever(admin.getConnection());){
            this.assertSpaceQuota(0x50000000000L, violationPolicy, (QuotaSettings)Iterables.getOnlyElement((Iterable)scanner));
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        QuotaSettings removeQuota = QuotaSettingsFactory.removeTableSpaceLimit((TableName)tn);
        admin.setQuota(removeQuota);
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner rs = quotaTable.getScanner(new Scan());){
            Assert.assertNull((String)"Did not expect to find a quota entry", (Object)rs.next());
        }
        var9_8 = null;
        try (QuotaRetriever scanner = new QuotaRetriever(admin.getConnection());){
            Assert.assertNull((String)"Did not expect to find a quota entry", (Object)scanner.next());
        }
        catch (Throwable throwable) {
            var9_8 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetModifyRemoveSpaceQuota() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        TableName tn = TableName.valueOf((String)"sq_table2");
        long originalSizeLimit = 0x50000000000L;
        SpaceViolationPolicy violationPolicy = SpaceViolationPolicy.NO_WRITES;
        QuotaSettings settings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x50000000000L, (SpaceViolationPolicy)violationPolicy);
        admin.setQuota(settings);
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner scanner = quotaTable.getScanner(new Scan());){
            Result r = (Result)Iterables.getOnlyElement((Iterable)scanner);
            CellScanner cells = r.cellScanner();
            Assert.assertTrue((String)"Expected to find a cell", (boolean)cells.advance());
            this.assertSpaceQuota(0x50000000000L, violationPolicy, cells.current());
        }
        var8_8 = null;
        try (QuotaRetriever quotaScanner = new QuotaRetriever(admin.getConnection());){
            this.assertSpaceQuota(0x50000000000L, violationPolicy, (QuotaSettings)Iterables.getOnlyElement((Iterable)quotaScanner));
        }
        catch (Throwable scanner) {
            var8_8 = scanner;
            throw scanner;
        }
        long newSizeLimit = 0x10000000000L;
        SpaceViolationPolicy newViolationPolicy = SpaceViolationPolicy.NO_WRITES_COMPACTIONS;
        QuotaSettings newSettings = QuotaSettingsFactory.limitTableSpace((TableName)tn, (long)0x10000000000L, (SpaceViolationPolicy)newViolationPolicy);
        admin.setQuota(newSettings);
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner scanner = quotaTable.getScanner(new Scan());){
            Result r = (Result)Iterables.getOnlyElement((Iterable)scanner);
            CellScanner cells = r.cellScanner();
            Assert.assertTrue((String)"Expected to find a cell", (boolean)cells.advance());
            this.assertSpaceQuota(0x10000000000L, newViolationPolicy, cells.current());
        }
        var12_17 = null;
        try (QuotaRetriever quotaScanner = new QuotaRetriever(admin.getConnection());){
            this.assertSpaceQuota(0x10000000000L, newViolationPolicy, (QuotaSettings)Iterables.getOnlyElement((Iterable)quotaScanner));
        }
        catch (Throwable throwable) {
            var12_17 = throwable;
            throw throwable;
        }
        QuotaSettings removeQuota = QuotaSettingsFactory.removeTableSpaceLimit((TableName)tn);
        admin.setQuota(removeQuota);
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner scanner = quotaTable.getScanner(new Scan());){
            Assert.assertNull((String)"Did not expect to find a quota entry", (Object)scanner.next());
        }
        var13_19 = null;
        try (QuotaRetriever quotaScanner = new QuotaRetriever(admin.getConnection());){
            Assert.assertNull((String)"Did not expect to find a quota entry", (Object)quotaScanner.next());
        }
        catch (Throwable throwable) {
            var13_19 = throwable;
            throw throwable;
        }
    }

    private void assertNumResults(int expected, QuotaFilter filter) throws Exception {
        Assert.assertEquals((long)expected, (long)this.countResults(filter));
    }

    @Test
    public void testSetGetRemoveRPCQuota() throws Exception {
        this.testSetGetRemoveRPCQuota(ThrottleType.REQUEST_SIZE);
        this.testSetGetRemoveRPCQuota(ThrottleType.REQUEST_CAPACITY_UNIT);
    }

    private void testSetGetRemoveRPCQuota(ThrottleType throttleType) throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        TableName tn = TableName.valueOf((String)"sq_table1");
        QuotaSettings settings = QuotaSettingsFactory.throttleTable((TableName)tn, (ThrottleType)throttleType, (long)2L, (TimeUnit)TimeUnit.HOURS);
        admin.setQuota(settings);
        this.verifyRecordPresentInQuotaTable(throttleType, 2L, TimeUnit.HOURS);
        this.verifyFetchableViaAPI(admin, throttleType, 2L, TimeUnit.HOURS);
        QuotaSettings removeQuota = QuotaSettingsFactory.unthrottleTable((TableName)tn);
        admin.setQuota(removeQuota);
        this.verifyRecordNotPresentInQuotaTable();
        this.verifyNotFetchableViaAPI(admin);
    }

    @Test
    public void testSetModifyRemoveRPCQuota() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        TableName tn = TableName.valueOf((String)"sq_table1");
        QuotaSettings settings = QuotaSettingsFactory.throttleTable((TableName)tn, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)2L, (TimeUnit)TimeUnit.HOURS);
        admin.setQuota(settings);
        this.verifyRecordPresentInQuotaTable(ThrottleType.REQUEST_SIZE, 2L, TimeUnit.HOURS);
        this.verifyFetchableViaAPI(admin, ThrottleType.REQUEST_SIZE, 2L, TimeUnit.HOURS);
        QuotaSettings newSettings = QuotaSettingsFactory.throttleTable((TableName)tn, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)3L, (TimeUnit)TimeUnit.DAYS);
        admin.setQuota(newSettings);
        this.verifyRecordPresentInQuotaTable(ThrottleType.REQUEST_SIZE, 3L, TimeUnit.DAYS);
        this.verifyFetchableViaAPI(admin, ThrottleType.REQUEST_SIZE, 3L, TimeUnit.DAYS);
        QuotaSettings removeQuota = QuotaSettingsFactory.unthrottleTable((TableName)tn);
        admin.setQuota(removeQuota);
        this.verifyRecordNotPresentInQuotaTable();
        this.verifyNotFetchableViaAPI(admin);
    }

    @Test
    public void testSetAndRemoveRegionServerQuota() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String regionServer = "all";
        QuotaFilter rsFilter = new QuotaFilter().setRegionServerFilter(regionServer);
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)regionServer, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)10L, (TimeUnit)TimeUnit.MINUTES));
        this.assertNumResults(1, rsFilter);
        this.verifyRecordPresentInQuotaTable(ThrottleType.REQUEST_NUMBER, 10L, TimeUnit.MINUTES);
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)regionServer, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)20L, (TimeUnit)TimeUnit.MINUTES));
        this.assertNumResults(1, rsFilter);
        this.verifyRecordPresentInQuotaTable(ThrottleType.REQUEST_NUMBER, 20L, TimeUnit.MINUTES);
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)regionServer, (ThrottleType)ThrottleType.READ_NUMBER, (long)30L, (TimeUnit)TimeUnit.SECONDS));
        int count = 0;
        try (QuotaRetriever scanner = new QuotaRetriever(TEST_UTIL.getConnection(), rsFilter);){
            for (QuotaSettings settings : scanner) {
                Assert.assertTrue((settings.getQuotaType() == QuotaType.THROTTLE ? 1 : 0) != 0);
                ThrottleSettings throttleSettings = (ThrottleSettings)settings;
                Assert.assertEquals((Object)regionServer, (Object)throttleSettings.getRegionServer());
                ++count;
                if (throttleSettings.getThrottleType() == ThrottleType.REQUEST_NUMBER) {
                    Assert.assertEquals((long)20L, (long)throttleSettings.getSoftLimit());
                    Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)throttleSettings.getTimeUnit()));
                    continue;
                }
                if (throttleSettings.getThrottleType() != ThrottleType.READ_NUMBER) continue;
                Assert.assertEquals((long)30L, (long)throttleSettings.getSoftLimit());
                Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)throttleSettings.getTimeUnit()));
            }
        }
        Assert.assertEquals((long)2L, (long)count);
        admin.setQuota(QuotaSettingsFactory.unthrottleRegionServer((String)regionServer));
        this.assertNumResults(0, new QuotaFilter().setRegionServerFilter(regionServer));
    }

    @Test
    public void testRpcThrottleWhenStartup() throws IOException, InterruptedException {
        TEST_UTIL.getAdmin().switchRpcThrottle(false);
        Assert.assertFalse((boolean)TEST_UTIL.getAdmin().isRpcThrottleEnabled());
        TEST_UTIL.killMiniHBaseCluster();
        TEST_UTIL.startMiniHBaseCluster();
        Assert.assertFalse((boolean)TEST_UTIL.getAdmin().isRpcThrottleEnabled());
        for (JVMClusterUtil.RegionServerThread rs : TEST_UTIL.getHBaseCluster().getRegionServerThreads()) {
            RegionServerRpcQuotaManager quotaManager = rs.getRegionServer().getRegionServerRpcQuotaManager();
            Assert.assertFalse((boolean)quotaManager.isRpcThrottleEnabled());
        }
        TEST_UTIL.getAdmin().switchRpcThrottle(true);
        Assert.assertTrue((boolean)TEST_UTIL.getAdmin().isRpcThrottleEnabled());
    }

    @Test
    public void testSwitchRpcThrottle() throws IOException {
        Admin admin = TEST_UTIL.getAdmin();
        this.testSwitchRpcThrottle(admin, true, true);
        this.testSwitchRpcThrottle(admin, true, false);
        this.testSwitchRpcThrottle(admin, false, false);
        this.testSwitchRpcThrottle(admin, false, true);
    }

    @Test
    public void testSwitchExceedThrottleQuota() throws IOException {
        String regionServer = "all";
        Admin admin = TEST_UTIL.getAdmin();
        try {
            admin.exceedThrottleQuotaSwitch(true);
            Assert.fail((String)"should not come here, because can't enable exceed throttle quota if there is no region server quota");
        }
        catch (IOException e) {
            LOG.warn("Expected exception", (Throwable)e);
        }
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)regionServer, (ThrottleType)ThrottleType.WRITE_NUMBER, (long)100L, (TimeUnit)TimeUnit.SECONDS));
        try {
            admin.exceedThrottleQuotaSwitch(true);
            Assert.fail((String)"should not come here, because can't enable exceed throttle quota if there is no read region server quota");
        }
        catch (IOException e) {
            LOG.warn("Expected exception", (Throwable)e);
        }
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)regionServer, (ThrottleType)ThrottleType.READ_NUMBER, (long)20L, (TimeUnit)TimeUnit.MINUTES));
        try {
            admin.exceedThrottleQuotaSwitch(true);
            Assert.fail((String)"should not come here, because can't enable exceed throttle quota because not all region server quota are in seconds time unit");
        }
        catch (IOException e) {
            LOG.warn("Expected exception", (Throwable)e);
        }
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)regionServer, (ThrottleType)ThrottleType.READ_NUMBER, (long)20L, (TimeUnit)TimeUnit.SECONDS));
        Assert.assertFalse((boolean)admin.exceedThrottleQuotaSwitch(true));
        Assert.assertTrue((boolean)admin.exceedThrottleQuotaSwitch(true));
        Assert.assertTrue((boolean)admin.exceedThrottleQuotaSwitch(false));
        Assert.assertFalse((boolean)admin.exceedThrottleQuotaSwitch(false));
        Assert.assertEquals((long)2L, (long)admin.getQuota(new QuotaFilter()).size());
        admin.setQuota(QuotaSettingsFactory.unthrottleRegionServer((String)regionServer));
    }

    @Test
    public void testQuotaScope() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String user = "user1";
        String namespace = "testQuotaScope_ns";
        TableName tableName = TableName.valueOf((String)"testQuotaScope");
        QuotaFilter filter = new QuotaFilter();
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)namespace, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)10L, (TimeUnit)TimeUnit.MINUTES, (QuotaScope)QuotaScope.CLUSTER));
        this.assertNumResults(1, filter);
        this.verifyRecordPresentInQuotaTable(ThrottleType.REQUEST_NUMBER, 10L, TimeUnit.MINUTES, QuotaScope.CLUSTER);
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)namespace, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)10L, (TimeUnit)TimeUnit.MINUTES, (QuotaScope)QuotaScope.MACHINE));
        this.assertNumResults(1, filter);
        this.verifyRecordPresentInQuotaTable(ThrottleType.REQUEST_NUMBER, 10L, TimeUnit.MINUTES, QuotaScope.MACHINE);
        admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)namespace));
        this.assertNumResults(0, filter);
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)tableName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)10L, (TimeUnit)TimeUnit.MINUTES, (QuotaScope)QuotaScope.CLUSTER));
        this.verifyRecordPresentInQuotaTable(ThrottleType.REQUEST_NUMBER, 10L, TimeUnit.MINUTES, QuotaScope.CLUSTER);
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)tableName));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)user, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)10L, (TimeUnit)TimeUnit.MINUTES, (QuotaScope)QuotaScope.CLUSTER));
        this.verifyRecordPresentInQuotaTable(ThrottleType.REQUEST_NUMBER, 10L, TimeUnit.MINUTES, QuotaScope.CLUSTER);
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)user));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)user, (TableName)tableName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)10L, (TimeUnit)TimeUnit.MINUTES, (QuotaScope)QuotaScope.CLUSTER));
        this.verifyRecordPresentInQuotaTable(ThrottleType.REQUEST_NUMBER, 10L, TimeUnit.MINUTES, QuotaScope.CLUSTER);
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)user));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)user, (String)namespace, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)10L, (TimeUnit)TimeUnit.MINUTES, (QuotaScope)QuotaScope.CLUSTER));
        this.verifyRecordPresentInQuotaTable(ThrottleType.REQUEST_NUMBER, 10L, TimeUnit.MINUTES, QuotaScope.CLUSTER);
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)user));
    }

    private void testSwitchRpcThrottle(Admin admin, boolean oldRpcThrottle, boolean newRpcThrottle) throws IOException {
        boolean state = admin.switchRpcThrottle(newRpcThrottle);
        Assert.assertEquals((Object)oldRpcThrottle, (Object)state);
        Assert.assertEquals((Object)newRpcThrottle, (Object)admin.isRpcThrottleEnabled());
        TEST_UTIL.getHBaseCluster().getRegionServerThreads().stream().forEach(rs -> Assert.assertEquals((Object)newRpcThrottle, (Object)rs.getRegionServer().getRegionServerRpcQuotaManager().isRpcThrottleEnabled()));
    }

    private void verifyRecordPresentInQuotaTable(ThrottleType type, long limit, TimeUnit tu) throws Exception {
        this.verifyRecordPresentInQuotaTable(type, limit, tu, QuotaScope.MACHINE);
    }

    private void verifyRecordPresentInQuotaTable(ThrottleType type, long limit, TimeUnit tu, QuotaScope scope) throws Exception {
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner scanner = quotaTable.getScanner(new Scan());){
            Result r = (Result)Iterables.getOnlyElement((Iterable)scanner);
            CellScanner cells = r.cellScanner();
            Assert.assertTrue((String)"Expected to find a cell", (boolean)cells.advance());
            this.assertRPCQuota(type, limit, tu, scope, cells.current());
        }
    }

    private void verifyRecordNotPresentInQuotaTable() throws Exception {
        try (Table quotaTable = TEST_UTIL.getConnection().getTable(QuotaTableUtil.QUOTA_TABLE_NAME);
             ResultScanner scanner = quotaTable.getScanner(new Scan());){
            Assert.assertNull((String)"Did not expect to find a quota entry", (Object)scanner.next());
        }
    }

    private void verifyFetchableViaAPI(Admin admin, ThrottleType type, long limit, TimeUnit tu) throws Exception {
        try (QuotaRetriever quotaScanner = new QuotaRetriever(admin.getConnection());){
            this.assertRPCQuota(type, limit, tu, (QuotaSettings)Iterables.getOnlyElement((Iterable)quotaScanner));
        }
    }

    private void verifyNotFetchableViaAPI(Admin admin) throws Exception {
        try (QuotaRetriever quotaScanner = new QuotaRetriever(admin.getConnection());){
            Assert.assertNull((String)"Did not expect to find a quota entry", (Object)quotaScanner.next());
        }
    }

    private void assertRPCQuota(ThrottleType type, long limit, TimeUnit tu, QuotaScope scope, Cell cell) throws Exception {
        QuotaProtos.Quotas q = QuotaTableUtil.quotasFromData((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
        Assert.assertTrue((String)"Quota should have rpc quota defined", (boolean)q.hasThrottle());
        QuotaProtos.Throttle rpcQuota = q.getThrottle();
        QuotaProtos.TimedQuota t = null;
        switch (type) {
            case REQUEST_SIZE: {
                Assert.assertTrue((boolean)rpcQuota.hasReqSize());
                t = rpcQuota.getReqSize();
                break;
            }
            case READ_NUMBER: {
                Assert.assertTrue((boolean)rpcQuota.hasReadNum());
                t = rpcQuota.getReadNum();
                break;
            }
            case READ_SIZE: {
                Assert.assertTrue((boolean)rpcQuota.hasReadSize());
                t = rpcQuota.getReadSize();
                break;
            }
            case REQUEST_NUMBER: {
                Assert.assertTrue((boolean)rpcQuota.hasReqNum());
                t = rpcQuota.getReqNum();
                break;
            }
            case WRITE_NUMBER: {
                Assert.assertTrue((boolean)rpcQuota.hasWriteNum());
                t = rpcQuota.getWriteNum();
                break;
            }
            case WRITE_SIZE: {
                Assert.assertTrue((boolean)rpcQuota.hasWriteSize());
                t = rpcQuota.getWriteSize();
                break;
            }
            case REQUEST_CAPACITY_UNIT: {
                Assert.assertTrue((boolean)rpcQuota.hasReqCapacityUnit());
                t = rpcQuota.getReqCapacityUnit();
                break;
            }
            case READ_CAPACITY_UNIT: {
                Assert.assertTrue((boolean)rpcQuota.hasReadCapacityUnit());
                t = rpcQuota.getReadCapacityUnit();
                break;
            }
            case WRITE_CAPACITY_UNIT: {
                Assert.assertTrue((boolean)rpcQuota.hasWriteCapacityUnit());
                t = rpcQuota.getWriteCapacityUnit();
                break;
            }
            case ATOMIC_READ_SIZE: {
                Assert.assertTrue((boolean)rpcQuota.hasAtomicReadSize());
                t = rpcQuota.getAtomicReadSize();
                break;
            }
            case ATOMIC_REQUEST_NUMBER: {
                Assert.assertTrue((boolean)rpcQuota.hasAtomicReqNum());
                t = rpcQuota.getAtomicReqNum();
                break;
            }
        }
        Assert.assertEquals((Object)scope, (Object)ProtobufUtil.toQuotaScope((QuotaProtos.QuotaScope)t.getScope()));
        Assert.assertEquals((long)t.getSoftLimit(), (long)limit);
        Assert.assertEquals((Object)t.getTimeUnit(), (Object)ProtobufUtil.toProtoTimeUnit((TimeUnit)tu));
    }

    private void assertRPCQuota(ThrottleType type, long limit, TimeUnit tu, QuotaSettings actualSettings) throws Exception {
        Assert.assertTrue((String)("The actual QuotaSettings was not an instance of " + ThrottleSettings.class + " but of " + actualSettings.getClass()), (boolean)(actualSettings instanceof ThrottleSettings));
        QuotaProtos.ThrottleRequest throttleRequest = ((ThrottleSettings)actualSettings).getProto();
        Assert.assertEquals((long)limit, (long)throttleRequest.getTimedQuota().getSoftLimit());
        Assert.assertEquals((Object)ProtobufUtil.toProtoTimeUnit((TimeUnit)tu), (Object)throttleRequest.getTimedQuota().getTimeUnit());
        Assert.assertEquals((Object)ProtobufUtil.toProtoThrottleType((ThrottleType)type), (Object)throttleRequest.getType());
    }

    private void assertSpaceQuota(long sizeLimit, SpaceViolationPolicy violationPolicy, Cell cell) throws Exception {
        QuotaProtos.Quotas q = QuotaTableUtil.quotasFromData((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength());
        Assert.assertTrue((String)"Quota should have space quota defined", (boolean)q.hasSpace());
        QuotaProtos.SpaceQuota spaceQuota = q.getSpace();
        Assert.assertEquals((long)sizeLimit, (long)spaceQuota.getSoftLimit());
        Assert.assertEquals((Object)violationPolicy, (Object)ProtobufUtil.toViolationPolicy((QuotaProtos.SpaceViolationPolicy)spaceQuota.getViolationPolicy()));
    }

    private void assertSpaceQuota(long sizeLimit, SpaceViolationPolicy violationPolicy, QuotaSettings actualSettings) {
        Assert.assertTrue((String)("The actual QuotaSettings was not an instance of " + SpaceLimitSettings.class + " but of " + actualSettings.getClass()), (boolean)(actualSettings instanceof SpaceLimitSettings));
        QuotaProtos.SpaceLimitRequest spaceLimitRequest = ((SpaceLimitSettings)actualSettings).getProto();
        Assert.assertEquals((long)sizeLimit, (long)spaceLimitRequest.getQuota().getSoftLimit());
        Assert.assertEquals((Object)violationPolicy, (Object)ProtobufUtil.toViolationPolicy((QuotaProtos.SpaceViolationPolicy)spaceLimitRequest.getQuota().getViolationPolicy()));
    }

    private int countResults(QuotaFilter filter) throws Exception {
        try (QuotaRetriever scanner = new QuotaRetriever(TEST_UTIL.getConnection(), filter);){
            int count = 0;
            for (QuotaSettings settings : scanner) {
                LOG.debug(Objects.toString(settings));
                ++count;
            }
            int n = count;
            return n;
        }
    }

    @Test
    public void testUserUnThrottleByType() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        String userName01 = "user01";
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName01, (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName01, (ThrottleType)ThrottleType.REQUEST_SIZE, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.unthrottleUserByThrottleType((String)userName, (ThrottleType)ThrottleType.REQUEST_NUMBER));
        Assert.assertEquals((long)3L, (long)this.getQuotaSettingCount(admin));
        admin.setQuota(QuotaSettingsFactory.unthrottleUserByThrottleType((String)userName, (ThrottleType)ThrottleType.REQUEST_SIZE));
        Assert.assertEquals((long)2L, (long)this.getQuotaSettingCount(admin));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName01));
        Assert.assertEquals((long)0L, (long)this.getQuotaSettingCount(admin));
    }

    @Test
    public void testUserTableUnThrottleByType() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        String userName01 = "user01";
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_SIZE, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName01, (TableName)TABLE_NAMES[1], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName01, (TableName)TABLE_NAMES[1], (ThrottleType)ThrottleType.REQUEST_SIZE, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.unthrottleUserByThrottleType((String)userName, (TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER));
        Assert.assertEquals((long)3L, (long)this.getQuotaSettingCount(admin));
        admin.setQuota(QuotaSettingsFactory.unthrottleUserByThrottleType((String)userName, (TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_SIZE));
        Assert.assertEquals((long)2L, (long)this.getQuotaSettingCount(admin));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName01));
        Assert.assertEquals((long)0L, (long)this.getQuotaSettingCount(admin));
    }

    @Test
    public void testUserNameSpaceUnThrottleByType() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        String userName01 = "user01";
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (String)NAMESPACES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName, (String)NAMESPACES[0], (ThrottleType)ThrottleType.REQUEST_SIZE, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName01, (String)NAMESPACES[1], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleUser((String)userName01, (String)NAMESPACES[1], (ThrottleType)ThrottleType.REQUEST_SIZE, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.unthrottleUserByThrottleType((String)userName, (String)NAMESPACES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER));
        Assert.assertEquals((long)3L, (long)this.getQuotaSettingCount(admin));
        admin.setQuota(QuotaSettingsFactory.unthrottleUserByThrottleType((String)userName, (String)NAMESPACES[0], (ThrottleType)ThrottleType.REQUEST_SIZE));
        Assert.assertEquals((long)2L, (long)this.getQuotaSettingCount(admin));
        admin.setQuota(QuotaSettingsFactory.unthrottleUser((String)userName01));
        Assert.assertEquals((long)0L, (long)this.getQuotaSettingCount(admin));
    }

    @Test
    public void testTableUnThrottleByType() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_SIZE, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[1], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleTable((TableName)TABLE_NAMES[1], (ThrottleType)ThrottleType.REQUEST_SIZE, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.unthrottleTableByThrottleType((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER));
        Assert.assertEquals((long)3L, (long)this.getQuotaSettingCount(admin));
        admin.setQuota(QuotaSettingsFactory.unthrottleTableByThrottleType((TableName)TABLE_NAMES[0], (ThrottleType)ThrottleType.REQUEST_SIZE));
        Assert.assertEquals((long)2L, (long)this.getQuotaSettingCount(admin));
        admin.setQuota(QuotaSettingsFactory.unthrottleTable((TableName)TABLE_NAMES[1]));
        Assert.assertEquals((long)0L, (long)this.getQuotaSettingCount(admin));
    }

    @Test
    public void testNameSpaceUnThrottleByType() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String userName = User.getCurrent().getShortName();
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)NAMESPACES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)NAMESPACES[0], (ThrottleType)ThrottleType.REQUEST_SIZE, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)NAMESPACES[1], (ThrottleType)ThrottleType.REQUEST_NUMBER, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleNamespace((String)NAMESPACES[1], (ThrottleType)ThrottleType.REQUEST_SIZE, (long)6L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.unthrottleNamespaceByThrottleType((String)NAMESPACES[0], (ThrottleType)ThrottleType.REQUEST_NUMBER));
        Assert.assertEquals((long)3L, (long)this.getQuotaSettingCount(admin));
        admin.setQuota(QuotaSettingsFactory.unthrottleNamespaceByThrottleType((String)NAMESPACES[0], (ThrottleType)ThrottleType.REQUEST_SIZE));
        Assert.assertEquals((long)2L, (long)this.getQuotaSettingCount(admin));
        admin.setQuota(QuotaSettingsFactory.unthrottleNamespace((String)NAMESPACES[1]));
        Assert.assertEquals((long)0L, (long)this.getQuotaSettingCount(admin));
    }

    @Test
    public void testRegionServerUnThrottleByType() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        String[] REGIONSERVER = new String[]{"RS01", "RS02"};
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)REGIONSERVER[0], (ThrottleType)ThrottleType.READ_NUMBER, (long)4L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)REGIONSERVER[0], (ThrottleType)ThrottleType.WRITE_NUMBER, (long)4L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)REGIONSERVER[1], (ThrottleType)ThrottleType.READ_NUMBER, (long)4L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.throttleRegionServer((String)REGIONSERVER[1], (ThrottleType)ThrottleType.WRITE_NUMBER, (long)4L, (TimeUnit)TimeUnit.MINUTES));
        admin.setQuota(QuotaSettingsFactory.unthrottleRegionServerByThrottleType((String)REGIONSERVER[0], (ThrottleType)ThrottleType.READ_NUMBER));
        Assert.assertEquals((long)3L, (long)this.getQuotaSettingCount(admin));
        admin.setQuota(QuotaSettingsFactory.unthrottleRegionServerByThrottleType((String)REGIONSERVER[0], (ThrottleType)ThrottleType.WRITE_NUMBER));
        Assert.assertEquals((long)2L, (long)this.getQuotaSettingCount(admin));
        admin.setQuota(QuotaSettingsFactory.unthrottleRegionServer((String)REGIONSERVER[1]));
        Assert.assertEquals((long)0L, (long)this.getQuotaSettingCount(admin));
    }

    public int getQuotaSettingCount(Admin admin) throws IOException {
        List list_quotas = admin.getQuota(new QuotaFilter());
        int quotaSettingCount = 0;
        for (QuotaSettings setting : list_quotas) {
            ++quotaSettingCount;
            LOG.info("Quota Setting:" + setting);
        }
        return quotaSettingCount;
    }

    @Test
    public void testQuotaTableDisableAndEnable() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        admin.disableTable(QuotaUtil.QUOTA_TABLE_NAME);
        try {
            admin.enableTable(QuotaUtil.QUOTA_TABLE_NAME);
        }
        catch (Exception ex) {
            Assert.fail((String)("Got an exception while enabling table: " + QuotaUtil.QUOTA_TABLE_NAME));
        }
    }
}

