/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheFactory;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CacheTestUtils;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.DataTieringException;
import org.apache.hadoop.hbase.regionserver.DataTieringManager;
import org.apache.hadoop.hbase.regionserver.DataTieringType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreContext;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTracker;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestDataTieringManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDataTieringManager.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Logger LOG = LoggerFactory.getLogger(TestDataTieringManager.class);
    private static final long DAY = 86400000L;
    private static Configuration defaultConf;
    private static FileSystem fs;
    private static BlockCache blockCache;
    private static CacheConfig cacheConf;
    private static Path testDir;
    private static final Map<String, HRegion> testOnlineRegions;
    private static DataTieringManager dataTieringManager;
    private static final List<HStoreFile> hStoreFiles;
    private static String rowKeyString;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        testDir = TEST_UTIL.getDataTestDir(TestDataTieringManager.class.getSimpleName());
        defaultConf = TEST_UTIL.getConfiguration();
        TestDataTieringManager.updateCommonConfigurations();
        Assert.assertTrue((boolean)DataTieringManager.instantiate((Configuration)defaultConf, testOnlineRegions));
        dataTieringManager = DataTieringManager.getInstance();
        rowKeyString = "";
    }

    private static void updateCommonConfigurations() {
        defaultConf.setBoolean("hbase.regionserver.datatiering.enable", true);
        defaultConf.setStrings("hbase.bucketcache.ioengine", new String[]{"offheap"});
        defaultConf.setLong("hbase.bucketcache.size", 32L);
    }

    @Test
    public void testDataTieringEnabledWithKey() throws IOException {
        TestDataTieringManager.initializeTestEnvironment();
        DataTieringMethodCallerWithKey methodCallerWithKey = DataTieringManager::isDataTieringEnabled;
        BlockCacheKey key = new BlockCacheKey(hStoreFiles.get(0).getPath(), 0L, true, BlockType.DATA);
        this.testDataTieringMethodWithKeyNoException(methodCallerWithKey, key, true);
        key = new BlockCacheKey(hStoreFiles.get(1).getPath(), 0L, true, BlockType.DATA);
        this.testDataTieringMethodWithKeyNoException(methodCallerWithKey, key, false);
        key = new BlockCacheKey(hStoreFiles.get(0).getPath().getName(), 0L);
        this.testDataTieringMethodWithKeyExpectingException(methodCallerWithKey, key, new DataTieringException("BlockCacheKey Doesn't Contain HFile Path"));
    }

    @Test
    public void testDataTieringEnabledWithPath() throws IOException {
        TestDataTieringManager.initializeTestEnvironment();
        DataTieringMethodCallerWithPath methodCallerWithPath = DataTieringManager::isDataTieringEnabled;
        Path hFilePath = hStoreFiles.get(1).getPath();
        this.testDataTieringMethodWithPathNoException(methodCallerWithPath, hFilePath, false);
        hFilePath = hStoreFiles.get(3).getPath();
        this.testDataTieringMethodWithPathNoException(methodCallerWithPath, hFilePath, true);
        hFilePath = new Path("incorrectPath");
        this.testDataTieringMethodWithPathExpectingException(methodCallerWithPath, hFilePath, new DataTieringException("Incorrect HFile Path: " + hFilePath));
        Path basePath = hStoreFiles.get(0).getPath().getParent().getParent().getParent();
        hFilePath = new Path(basePath, "incorrectRegion/cf1/filename");
        this.testDataTieringMethodWithPathExpectingException(methodCallerWithPath, hFilePath, new DataTieringException("HRegion corresponding to " + hFilePath + " doesn't exist"));
        basePath = hStoreFiles.get(0).getPath().getParent().getParent();
        hFilePath = new Path(basePath, "incorrectCf/filename");
        this.testDataTieringMethodWithPathExpectingException(methodCallerWithPath, hFilePath, new DataTieringException("HStore corresponding to " + hFilePath + " doesn't exist"));
    }

    @Test
    public void testHotDataWithKey() throws IOException {
        TestDataTieringManager.initializeTestEnvironment();
        DataTieringMethodCallerWithKey methodCallerWithKey = DataTieringManager::isHotData;
        BlockCacheKey key = new BlockCacheKey(hStoreFiles.get(0).getPath(), 0L, true, BlockType.DATA);
        this.testDataTieringMethodWithKeyNoException(methodCallerWithKey, key, true);
        key = new BlockCacheKey(hStoreFiles.get(3).getPath(), 0L, true, BlockType.DATA);
        this.testDataTieringMethodWithKeyNoException(methodCallerWithKey, key, false);
    }

    @Test
    public void testHotDataWithPath() throws IOException {
        TestDataTieringManager.initializeTestEnvironment();
        DataTieringMethodCallerWithPath methodCallerWithPath = DataTieringManager::isHotData;
        Path hFilePath = hStoreFiles.get(2).getPath();
        this.testDataTieringMethodWithPathNoException(methodCallerWithPath, hFilePath, true);
        hFilePath = hStoreFiles.get(3).getPath();
        this.testDataTieringMethodWithPathNoException(methodCallerWithPath, hFilePath, false);
        hFilePath = new Path(hStoreFiles.get(0).getPath().getParent(), "incorrectFileName");
        this.testDataTieringMethodWithPathExpectingException(methodCallerWithPath, hFilePath, new DataTieringException("Store file corresponding to " + hFilePath + " doesn't exist"));
    }

    @Test
    public void testPrefetchWhenDataTieringEnabled() throws IOException {
        this.setPrefetchBlocksOnOpen();
        TestDataTieringManager.initializeTestEnvironment();
        for (HStoreFile file : hStoreFiles) {
            file.closeStoreFile(true);
            file.initReader();
        }
        Optional fullyCachedFiles = blockCache.getFullyCachedFiles();
        Assert.assertTrue((String)"We should get the fully cached files from the cache", (boolean)fullyCachedFiles.isPresent());
        Waiter.waitFor((Configuration)defaultConf, (long)10000L, () -> ((Map)fullyCachedFiles.get()).size() == 3);
        Assert.assertEquals((String)"Number of fully cached files are incorrect", (long)3L, (long)((Map)fullyCachedFiles.get()).size());
    }

    private void setPrefetchBlocksOnOpen() {
        defaultConf.setBoolean("hbase.rs.prefetchblocksonopen", true);
    }

    @Test
    public void testColdDataFiles() throws IOException {
        TestDataTieringManager.initializeTestEnvironment();
        HashSet<BlockCacheKey> allCachedBlocks = new HashSet<BlockCacheKey>();
        for (HStoreFile file : hStoreFiles) {
            allCachedBlocks.add(new BlockCacheKey(file.getPath(), 0L, true, BlockType.DATA));
        }
        DataTieringMethodCallerWithPath methodCallerWithPath = DataTieringManager::isHotData;
        Path hFilePath = hStoreFiles.get(3).getPath();
        this.testDataTieringMethodWithPathNoException(methodCallerWithPath, hFilePath, false);
        for (int i = 0; i < hStoreFiles.size() - 1; ++i) {
            hFilePath = hStoreFiles.get(i).getPath();
            this.testDataTieringMethodWithPathNoException(methodCallerWithPath, hFilePath, true);
        }
        try {
            Set coldFilePaths = dataTieringManager.getColdDataFiles(allCachedBlocks);
            Assert.assertEquals((long)1L, (long)coldFilePaths.size());
        }
        catch (DataTieringException e) {
            Assert.fail((String)("Unexpected DataTieringException: " + e.getMessage()));
        }
    }

    @Test
    public void testCacheCompactedBlocksOnWriteDataTieringDisabled() throws IOException {
        this.setCacheCompactBlocksOnWrite();
        TestDataTieringManager.initializeTestEnvironment();
        HRegion region = TestDataTieringManager.createHRegion("table3");
        this.testCacheCompactedBlocksOnWrite(region, true);
    }

    @Test
    public void testCacheCompactedBlocksOnWriteWithHotData() throws IOException {
        this.setCacheCompactBlocksOnWrite();
        TestDataTieringManager.initializeTestEnvironment();
        HRegion region = TestDataTieringManager.createHRegion("table3", TestDataTieringManager.getConfWithTimeRangeDataTieringEnabled(432000000L));
        this.testCacheCompactedBlocksOnWrite(region, true);
    }

    @Test
    public void testCacheCompactedBlocksOnWriteWithColdData() throws IOException {
        this.setCacheCompactBlocksOnWrite();
        TestDataTieringManager.initializeTestEnvironment();
        HRegion region = TestDataTieringManager.createHRegion("table3", TestDataTieringManager.getConfWithTimeRangeDataTieringEnabled(86400000L));
        this.testCacheCompactedBlocksOnWrite(region, false);
    }

    private void setCacheCompactBlocksOnWrite() {
        defaultConf.setBoolean("hbase.rs.cachecompactedblocksonwrite", true);
    }

    private void testCacheCompactedBlocksOnWrite(HRegion region, boolean expectDataBlocksCached) throws IOException {
        HStore hStore = TestDataTieringManager.createHStore(region, "cf1");
        this.createTestFilesForCompaction(hStore);
        hStore.refreshStoreFiles();
        region.stores.put(Bytes.toBytes((String)"cf1"), hStore);
        testOnlineRegions.put(region.getRegionInfo().getEncodedName(), region);
        long initialStoreFilesCount = hStore.getStorefilesCount();
        long initialCacheDataBlockCount = blockCache.getDataBlockCount();
        Assert.assertEquals((long)3L, (long)initialStoreFilesCount);
        Assert.assertEquals((long)0L, (long)initialCacheDataBlockCount);
        region.compact(true);
        long compactedStoreFilesCount = hStore.getStorefilesCount();
        long compactedCacheDataBlockCount = blockCache.getDataBlockCount();
        Assert.assertEquals((long)1L, (long)compactedStoreFilesCount);
        Assert.assertEquals((Object)expectDataBlocksCached, (Object)(compactedCacheDataBlockCount > 0L ? 1 : 0));
    }

    private void createTestFilesForCompaction(HStore hStore) throws IOException {
        long currentTime = System.currentTimeMillis();
        Path storeDir = hStore.getStoreContext().getFamilyStoreDirectoryPath();
        Configuration configuration = hStore.getReadOnlyConfiguration();
        TestDataTieringManager.createHStoreFile(storeDir, configuration, currentTime - 172800000L, hStore.getHRegion().getRegionFileSystem());
        TestDataTieringManager.createHStoreFile(storeDir, configuration, currentTime - 259200000L, hStore.getHRegion().getRegionFileSystem());
        TestDataTieringManager.createHStoreFile(storeDir, configuration, currentTime - 345600000L, hStore.getHRegion().getRegionFileSystem());
    }

    @Test
    public void testPickColdDataFiles() throws IOException {
        TestDataTieringManager.initializeTestEnvironment();
        Map coldDataFiles = dataTieringManager.getColdFilesList();
        Assert.assertEquals((long)1L, (long)coldDataFiles.size());
        assert (coldDataFiles.containsKey(hStoreFiles.get(3).getFileInfo().getActiveFileName()));
    }

    @Test
    public void testBlockEvictions() throws Exception {
        TestDataTieringManager.initializeTestEnvironment();
        long capacitySize = 40960L;
        int writeThreads = 3;
        int writerQLen = 64;
        int[] bucketSizes = new int[]{9216};
        BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", capacitySize, 8192, bucketSizes, writeThreads, writerQLen, null, 60000, defaultConf);
        HashSet<BlockCacheKey> cacheKeys = new HashSet<BlockCacheKey>();
        cacheKeys.add(new BlockCacheKey(hStoreFiles.get(3).getPath(), 0L, true, BlockType.DATA));
        cacheKeys.add(new BlockCacheKey(hStoreFiles.get(3).getPath(), 8192L, true, BlockType.DATA));
        cacheKeys.add(new BlockCacheKey(hStoreFiles.get(0).getPath(), 0L, true, BlockType.DATA));
        CacheTestUtils.HFileBlockPair[] blocks = CacheTestUtils.generateHFileBlocks(8192, 3);
        int blocksIter = 0;
        for (BlockCacheKey key : cacheKeys) {
            bucketCache.cacheBlock(key, (Cacheable)blocks[blocksIter++].getBlock());
            Waiter.waitFor((Configuration)defaultConf, (long)10000L, (long)100L, () -> bucketCache.getBackingMap().containsKey(key));
        }
        Assert.assertEquals((long)3L, (long)bucketCache.getBackingMap().keySet().size());
        BlockCacheKey newKey = new BlockCacheKey(hStoreFiles.get(2).getPath(), 0L, true, BlockType.DATA);
        CacheTestUtils.HFileBlockPair[] newBlock = CacheTestUtils.generateHFileBlocks(8192, 1);
        bucketCache.cacheBlock(newKey, (Cacheable)newBlock[0].getBlock());
        Waiter.waitFor((Configuration)defaultConf, (long)10000L, (long)100L, () -> bucketCache.getBackingMap().containsKey(newKey));
        this.validateBlocks(bucketCache.getBackingMap().keySet(), 2, 2, 0);
    }

    @Test
    public void testBlockEvictionsAllColdBlocks() throws Exception {
        TestDataTieringManager.initializeTestEnvironment();
        long capacitySize = 40960L;
        int writeThreads = 3;
        int writerQLen = 64;
        int[] bucketSizes = new int[]{9216};
        BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", capacitySize, 8192, bucketSizes, writeThreads, writerQLen, null, 60000, defaultConf);
        HashSet<BlockCacheKey> cacheKeys = new HashSet<BlockCacheKey>();
        cacheKeys.add(new BlockCacheKey(hStoreFiles.get(3).getPath(), 0L, true, BlockType.DATA));
        cacheKeys.add(new BlockCacheKey(hStoreFiles.get(3).getPath(), 8192L, true, BlockType.DATA));
        cacheKeys.add(new BlockCacheKey(hStoreFiles.get(3).getPath(), 16384L, true, BlockType.DATA));
        CacheTestUtils.HFileBlockPair[] blocks = CacheTestUtils.generateHFileBlocks(8192, 3);
        int blocksIter = 0;
        for (BlockCacheKey key : cacheKeys) {
            bucketCache.cacheBlock(key, (Cacheable)blocks[blocksIter++].getBlock());
            Waiter.waitFor((Configuration)defaultConf, (long)10000L, (long)100L, () -> bucketCache.getBackingMap().containsKey(key));
        }
        Assert.assertEquals((long)3L, (long)bucketCache.getBackingMap().keySet().size());
        BlockCacheKey newKey = new BlockCacheKey(hStoreFiles.get(2).getPath(), 0L, true, BlockType.DATA);
        CacheTestUtils.HFileBlockPair[] newBlock = CacheTestUtils.generateHFileBlocks(8192, 1);
        bucketCache.cacheBlock(newKey, (Cacheable)newBlock[0].getBlock());
        Waiter.waitFor((Configuration)defaultConf, (long)10000L, (long)100L, () -> bucketCache.getBackingMap().containsKey(newKey));
        this.validateBlocks(bucketCache.getBackingMap().keySet(), 2, 1, 1);
    }

    @Test
    public void testBlockEvictionsHotBlocks() throws Exception {
        TestDataTieringManager.initializeTestEnvironment();
        long capacitySize = 40960L;
        int writeThreads = 3;
        int writerQLen = 64;
        int[] bucketSizes = new int[]{9216};
        BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", capacitySize, 8192, bucketSizes, writeThreads, writerQLen, null, 60000, defaultConf);
        HashSet<BlockCacheKey> cacheKeys = new HashSet<BlockCacheKey>();
        cacheKeys.add(new BlockCacheKey(hStoreFiles.get(0).getPath(), 0L, true, BlockType.DATA));
        cacheKeys.add(new BlockCacheKey(hStoreFiles.get(0).getPath(), 8192L, true, BlockType.DATA));
        cacheKeys.add(new BlockCacheKey(hStoreFiles.get(3).getPath(), 0L, true, BlockType.DATA));
        CacheTestUtils.HFileBlockPair[] blocks = CacheTestUtils.generateHFileBlocks(8192, 3);
        int blocksIter = 0;
        for (BlockCacheKey key : cacheKeys) {
            bucketCache.cacheBlock(key, (Cacheable)blocks[blocksIter++].getBlock());
            Waiter.waitFor((Configuration)defaultConf, (long)10000L, (long)100L, () -> bucketCache.getBackingMap().containsKey(key));
        }
        Assert.assertEquals((long)3L, (long)bucketCache.getBackingMap().keySet().size());
        BlockCacheKey newKey = new BlockCacheKey(hStoreFiles.get(2).getPath(), 0L, true, BlockType.DATA);
        CacheTestUtils.HFileBlockPair[] newBlock = CacheTestUtils.generateHFileBlocks(8192, 1);
        bucketCache.cacheBlock(newKey, (Cacheable)newBlock[0].getBlock());
        Waiter.waitFor((Configuration)defaultConf, (long)10000L, (long)100L, () -> bucketCache.getBackingMap().containsKey(newKey));
        this.validateBlocks(bucketCache.getBackingMap().keySet(), 2, 2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFeatureKeyDisabled() throws Exception {
        DataTieringManager.resetForTestingOnly();
        defaultConf.setBoolean("hbase.regionserver.datatiering.enable", false);
        TestDataTieringManager.initializeTestEnvironment();
        try {
            Assert.assertFalse((boolean)DataTieringManager.instantiate((Configuration)defaultConf, testOnlineRegions));
            Assert.assertNull((Object)DataTieringManager.getInstance());
            long capacitySize = 40960L;
            int writeThreads = 3;
            int writerQLen = 64;
            int[] bucketSizes = new int[]{9216};
            BucketCache bucketCache = new BucketCache("file:" + testDir + "/bucket.cache", capacitySize, 8192, bucketSizes, writeThreads, writerQLen, null, 60000, defaultConf);
            ArrayList<BlockCacheKey> cacheKeys = new ArrayList<BlockCacheKey>();
            cacheKeys.add(new BlockCacheKey(hStoreFiles.get(0).getPath(), 0L, true, BlockType.DATA));
            cacheKeys.add(new BlockCacheKey(hStoreFiles.get(0).getPath(), 8192L, true, BlockType.DATA));
            cacheKeys.add(new BlockCacheKey(hStoreFiles.get(3).getPath(), 0L, true, BlockType.DATA));
            CacheTestUtils.HFileBlockPair[] blocks = CacheTestUtils.generateHFileBlocks(8192, 3);
            int blocksIter = 0;
            for (BlockCacheKey key : cacheKeys) {
                LOG.info("Adding {}", (Object)key);
                bucketCache.cacheBlock(key, (Cacheable)blocks[blocksIter++].getBlock());
                Waiter.waitFor((Configuration)defaultConf, (long)10000L, (long)100L, () -> bucketCache.getBackingMap().containsKey(key));
            }
            Assert.assertEquals((long)3L, (long)bucketCache.getBackingMap().keySet().size());
            BlockCacheKey newKey = new BlockCacheKey(hStoreFiles.get(2).getPath(), 0L, true, BlockType.DATA);
            CacheTestUtils.HFileBlockPair[] newBlock = CacheTestUtils.generateHFileBlocks(8192, 1);
            bucketCache.cacheBlock(newKey, (Cacheable)newBlock[0].getBlock());
            Waiter.waitFor((Configuration)defaultConf, (long)10000L, (long)100L, () -> bucketCache.getBackingMap().containsKey(newKey));
            this.validateBlocks(bucketCache.getBackingMap().keySet(), 2, 1, 1);
        }
        finally {
            DataTieringManager.resetForTestingOnly();
            defaultConf.setBoolean("hbase.regionserver.datatiering.enable", true);
            Assert.assertTrue((boolean)DataTieringManager.instantiate((Configuration)defaultConf, testOnlineRegions));
        }
    }

    @Test
    public void testCacheConfigShouldCacheFile() throws Exception {
        for (HStoreFile file : hStoreFiles) {
            file.closeStoreFile(true);
        }
        try {
            Assert.assertTrue((boolean)cacheConf.shouldCacheBlockOnRead(BlockType.BlockCategory.DATA, hStoreFiles.get(0).getFileInfo().getHFileInfo(), hStoreFiles.get(0).getFileInfo().getConf()));
            Assert.assertTrue((boolean)cacheConf.shouldCacheBlockOnRead(BlockType.BlockCategory.DATA, hStoreFiles.get(1).getFileInfo().getHFileInfo(), hStoreFiles.get(1).getFileInfo().getConf()));
            Assert.assertTrue((boolean)cacheConf.shouldCacheBlockOnRead(BlockType.BlockCategory.DATA, hStoreFiles.get(2).getFileInfo().getHFileInfo(), hStoreFiles.get(2).getFileInfo().getConf()));
            Assert.assertFalse((boolean)cacheConf.shouldCacheBlockOnRead(BlockType.BlockCategory.DATA, hStoreFiles.get(3).getFileInfo().getHFileInfo(), hStoreFiles.get(3).getFileInfo().getConf()));
        }
        finally {
            for (HStoreFile file : hStoreFiles) {
                file.initReader();
            }
        }
    }

    @Test
    public void testCacheOnReadColdFile() throws Exception {
        TestDataTieringManager.initializeTestEnvironment();
        HStoreFile hStoreFile = hStoreFiles.get(3);
        BlockCacheKey cacheKey = new BlockCacheKey(hStoreFile.getPath(), 0L, true, BlockType.DATA);
        this.testCacheOnRead(hStoreFile, cacheKey, -1L, false);
    }

    @Test
    public void testCacheOnReadHotFile() throws Exception {
        TestDataTieringManager.initializeTestEnvironment();
        HStoreFile hStoreFile = hStoreFiles.get(0);
        BlockCacheKey cacheKey = new BlockCacheKey(hStoreFiles.get(0).getPath(), 0L, true, BlockType.DATA);
        this.testCacheOnRead(hStoreFile, cacheKey, -1L, true);
    }

    private void testCacheOnRead(HStoreFile hStoreFile, BlockCacheKey key, long onDiskBlockSize, boolean expectedCached) throws Exception {
        hStoreFile.getReader().getHFileReader().readBlock(key.getOffset(), onDiskBlockSize, true, false, false, false, key.getBlockType(), DataBlockEncoding.NONE);
        HFileBlock block = (HFileBlock)blockCache.getBlock(key, false, false, false);
        if (expectedCached) {
            Assert.assertNotNull((Object)block);
        } else {
            Assert.assertNull((Object)block);
        }
    }

    private void validateBlocks(Set<BlockCacheKey> keys, int expectedTotalKeys, int expectedHotBlocks, int expectedColdBlocks) {
        int numHotBlocks = 0;
        int numColdBlocks = 0;
        Waiter.waitFor((Configuration)defaultConf, (long)10000L, (long)100L, () -> expectedTotalKeys == keys.size());
        boolean iter = false;
        for (BlockCacheKey key : keys) {
            try {
                if (dataTieringManager.isHotData(key)) {
                    ++numHotBlocks;
                    continue;
                }
                ++numColdBlocks;
            }
            catch (Exception e) {
                Assert.fail((String)"Unexpected exception!");
            }
        }
        Assert.assertEquals((long)expectedHotBlocks, (long)numHotBlocks);
        Assert.assertEquals((long)expectedColdBlocks, (long)numColdBlocks);
    }

    private void testDataTieringMethodWithPath(DataTieringMethodCallerWithPath caller, Path path, boolean expectedResult, DataTieringException exception) {
        try {
            boolean value = caller.call(dataTieringManager, path);
            if (exception != null) {
                Assert.fail((String)"Expected DataTieringException to be thrown");
            }
            Assert.assertEquals((Object)expectedResult, (Object)value);
        }
        catch (DataTieringException e) {
            if (exception == null) {
                Assert.fail((String)("Unexpected DataTieringException: " + e.getMessage()));
            }
            Assert.assertEquals((Object)exception.getMessage(), (Object)e.getMessage());
        }
    }

    private void testDataTieringMethodWithKey(DataTieringMethodCallerWithKey caller, BlockCacheKey key, boolean expectedResult, DataTieringException exception) {
        try {
            boolean value = caller.call(dataTieringManager, key);
            if (exception != null) {
                Assert.fail((String)"Expected DataTieringException to be thrown");
            }
            Assert.assertEquals((Object)expectedResult, (Object)value);
        }
        catch (DataTieringException e) {
            if (exception == null) {
                Assert.fail((String)("Unexpected DataTieringException: " + e.getMessage()));
            }
            Assert.assertEquals((Object)exception.getMessage(), (Object)e.getMessage());
        }
    }

    private void testDataTieringMethodWithPathExpectingException(DataTieringMethodCallerWithPath caller, Path path, DataTieringException exception) {
        this.testDataTieringMethodWithPath(caller, path, false, exception);
    }

    private void testDataTieringMethodWithPathNoException(DataTieringMethodCallerWithPath caller, Path path, boolean expectedResult) {
        this.testDataTieringMethodWithPath(caller, path, expectedResult, null);
    }

    private void testDataTieringMethodWithKeyExpectingException(DataTieringMethodCallerWithKey caller, BlockCacheKey key, DataTieringException exception) {
        this.testDataTieringMethodWithKey(caller, key, false, exception);
    }

    private void testDataTieringMethodWithKeyNoException(DataTieringMethodCallerWithKey caller, BlockCacheKey key, boolean expectedResult) {
        this.testDataTieringMethodWithKey(caller, key, expectedResult, null);
    }

    private static void initializeTestEnvironment() throws IOException {
        TestDataTieringManager.setupFileSystemAndCache();
        TestDataTieringManager.setupOnlineRegions();
    }

    private static void setupFileSystemAndCache() throws IOException {
        fs = HFileSystem.get((Configuration)defaultConf);
        blockCache = BlockCacheFactory.createBlockCache((Configuration)defaultConf);
        cacheConf = new CacheConfig(defaultConf, blockCache);
    }

    private static void setupOnlineRegions() throws IOException {
        testOnlineRegions.clear();
        hStoreFiles.clear();
        long day = 86400000L;
        long currentTime = System.currentTimeMillis();
        HRegion region1 = TestDataTieringManager.createHRegion("table1");
        HStore hStore11 = TestDataTieringManager.createHStore(region1, "cf1", TestDataTieringManager.getConfWithTimeRangeDataTieringEnabled(day));
        hStoreFiles.add(TestDataTieringManager.createHStoreFile(hStore11.getStoreContext().getFamilyStoreDirectoryPath(), hStore11.getReadOnlyConfiguration(), currentTime, region1.getRegionFileSystem()));
        hStore11.refreshStoreFiles();
        HStore hStore12 = TestDataTieringManager.createHStore(region1, "cf2");
        hStoreFiles.add(TestDataTieringManager.createHStoreFile(hStore12.getStoreContext().getFamilyStoreDirectoryPath(), hStore12.getReadOnlyConfiguration(), currentTime - day, region1.getRegionFileSystem()));
        hStore12.refreshStoreFiles();
        region1.stores.put(Bytes.toBytes((String)"cf1"), hStore11);
        region1.stores.put(Bytes.toBytes((String)"cf2"), hStore12);
        HRegion region2 = TestDataTieringManager.createHRegion("table2", TestDataTieringManager.getConfWithTimeRangeDataTieringEnabled((long)(2.5 * (double)day)));
        HStore hStore21 = TestDataTieringManager.createHStore(region2, "cf1");
        hStoreFiles.add(TestDataTieringManager.createHStoreFile(hStore21.getStoreContext().getFamilyStoreDirectoryPath(), hStore21.getReadOnlyConfiguration(), currentTime - 2L * day, region2.getRegionFileSystem()));
        hStore21.refreshStoreFiles();
        HStore hStore22 = TestDataTieringManager.createHStore(region2, "cf2");
        hStoreFiles.add(TestDataTieringManager.createHStoreFile(hStore22.getStoreContext().getFamilyStoreDirectoryPath(), hStore22.getReadOnlyConfiguration(), currentTime - 3L * day, region2.getRegionFileSystem()));
        hStore22.refreshStoreFiles();
        region2.stores.put(Bytes.toBytes((String)"cf1"), hStore21);
        region2.stores.put(Bytes.toBytes((String)"cf2"), hStore22);
        for (HStoreFile file : hStoreFiles) {
            file.initReader();
        }
        testOnlineRegions.put(region1.getRegionInfo().getEncodedName(), region1);
        testOnlineRegions.put(region2.getRegionInfo().getEncodedName(), region2);
    }

    private static HRegion createHRegion(String table) throws IOException {
        return TestDataTieringManager.createHRegion(table, defaultConf);
    }

    private static HRegion createHRegion(String table, Configuration conf) throws IOException {
        TableName tableName = TableName.valueOf((String)table);
        TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tableName).setValue("hbase.hstore.datatiering.type", conf.get("hbase.hstore.datatiering.type")).setValue("hbase.hstore.datatiering.hot.age.millis", conf.get("hbase.hstore.datatiering.hot.age.millis")).build();
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)tableName).build();
        Configuration testConf = new Configuration(conf);
        CommonFSUtils.setRootDir((Configuration)testConf, (Path)testDir);
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)testConf, (FileSystem)fs, (Path)CommonFSUtils.getTableDir((Path)testDir, (TableName)hri.getTable()), (RegionInfo)hri);
        HRegion region = new HRegion(regionFs, null, conf, htd, null);
        region.setBlockCache(blockCache);
        return region;
    }

    private static HStore createHStore(HRegion region, String columnFamily) throws IOException {
        return TestDataTieringManager.createHStore(region, columnFamily, defaultConf);
    }

    private static HStore createHStore(HRegion region, String columnFamily, Configuration conf) throws IOException {
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)columnFamily)).setValue("hbase.hstore.datatiering.type", conf.get("hbase.hstore.datatiering.type")).setValue("hbase.hstore.datatiering.hot.age.millis", conf.get("hbase.hstore.datatiering.hot.age.millis")).build();
        return new HStore(region, columnFamilyDescriptor, conf, false);
    }

    private static Configuration getConfWithTimeRangeDataTieringEnabled(long hotDataAge) {
        Configuration conf = new Configuration(defaultConf);
        conf.set("hbase.hstore.datatiering.type", DataTieringType.TIME_RANGE.name());
        conf.set("hbase.hstore.datatiering.hot.age.millis", String.valueOf(hotDataAge));
        return conf;
    }

    static HStoreFile createHStoreFile(Path storeDir, Configuration conf, long timestamp, HRegionFileSystem regionFs) throws IOException {
        String columnFamily = storeDir.getName();
        StoreFileWriter storeFileWriter = new StoreFileWriter.Builder(conf, cacheConf, fs).withOutputDir(storeDir).withFileContext(new HFileContextBuilder().build()).build();
        TestDataTieringManager.writeStoreFileRandomData(storeFileWriter, Bytes.toBytes((String)columnFamily), timestamp);
        StoreContext storeContext = StoreContext.getBuilder().withRegionFileSystem(regionFs).build();
        StoreFileTracker sft = StoreFileTrackerFactory.create((Configuration)conf, (boolean)true, (StoreContext)storeContext);
        return new HStoreFile(fs, storeFileWriter.getPath(), conf, cacheConf, BloomType.NONE, true, sft);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStoreFileRandomData(StoreFileWriter writer, byte[] columnFamily, long timestamp) throws IOException {
        int cellsPerFile = 10;
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = TestDataTieringManager.generateRandomBytes(4096);
        try {
            for (int i = 0; i < cellsPerFile; ++i) {
                byte[] row = Bytes.toBytes((String)TestDataTieringManager.nextString());
                writer.append((Cell)new KeyValue(row, columnFamily, qualifier, timestamp, value));
            }
        }
        finally {
            writer.appendTrackedTimestampsToMetadata();
            writer.close();
        }
    }

    private static byte[] generateRandomBytes(int sizeInBytes) {
        Random random = new Random();
        byte[] randomBytes = new byte[sizeInBytes];
        random.nextBytes(randomBytes);
        return randomBytes;
    }

    private static String nextString() {
        char lastChar;
        if (rowKeyString == null || rowKeyString.isEmpty()) {
            rowKeyString = "a";
        }
        rowKeyString = (lastChar = rowKeyString.charAt(rowKeyString.length() - 1)) < 'z' ? rowKeyString.substring(0, rowKeyString.length() - 1) + (char)(lastChar + '\u0001') : rowKeyString + "a";
        return rowKeyString;
    }

    static {
        testOnlineRegions = new HashMap<String, HRegion>();
        hStoreFiles = new ArrayList<HStoreFile>();
    }

    @FunctionalInterface
    static interface DataTieringMethodCallerWithKey {
        public boolean call(DataTieringManager var1, BlockCacheKey var2) throws DataTieringException;
    }

    @FunctionalInterface
    static interface DataTieringMethodCallerWithPath {
        public boolean call(DataTieringManager var1, Path var2) throws DataTieringException;
    }
}

