/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.CustomTieredStoreEngine;
import org.apache.hadoop.hbase.regionserver.CustomTieringMultiFileWriter;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestCustomCellTieredCompactor {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCustomCellTieredCompactor.class);
    public static final byte[] FAMILY = Bytes.toBytes((String)"cf");
    protected HBaseTestingUtility utility;
    protected Admin admin;

    @Before
    public void setUp() throws Exception {
        this.utility = new HBaseTestingUtility();
        this.utility.getConfiguration().setInt("hbase.hfile.compaction.discharger.interval", 10);
        this.utility.startMiniCluster();
    }

    @After
    public void tearDown() throws Exception {
        this.utility.shutdownMiniCluster();
    }

    @Test
    public void testCustomCellTieredCompactor() throws Exception {
        ColumnFamilyDescriptorBuilder clmBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY);
        clmBuilder.setValue("hbase.hstore.engine.class", CustomTieredStoreEngine.class.getName());
        clmBuilder.setValue("TIERING_CELL_QUALIFIER", "date");
        TableName tableName = TableName.valueOf((String)"testCustomCellTieredCompactor");
        TableDescriptorBuilder tblBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        tblBuilder.setColumnFamily(clmBuilder.build());
        this.utility.getAdmin().createTable(tblBuilder.build());
        this.utility.waitTableAvailable(tableName);
        Connection connection = this.utility.getConnection();
        Table table = connection.getTable(tableName);
        long recordTime = System.currentTimeMillis();
        for (int i = 0; i < 6; ++i) {
            ArrayList<Put> puts = new ArrayList<Put>(2);
            Put put = new Put(Bytes.toBytes((int)i));
            put.addColumn(FAMILY, Bytes.toBytes((String)"val"), Bytes.toBytes((String)("v" + i)));
            put.addColumn(FAMILY, Bytes.toBytes((String)"date"), Bytes.toBytes((long)(recordTime - 347846400000L)));
            puts.add(put);
            put = new Put(Bytes.toBytes((int)(i + 1000)));
            put.addColumn(FAMILY, Bytes.toBytes((String)"val"), Bytes.toBytes((String)("v" + (i + 1000))));
            put.addColumn(FAMILY, Bytes.toBytes((String)"date"), Bytes.toBytes((long)recordTime));
            puts.add(put);
            table.put(puts);
            this.utility.flush(tableName);
        }
        table.close();
        long firstCompactionTime = System.currentTimeMillis();
        this.utility.getAdmin().majorCompact(tableName);
        Waiter.waitFor((Configuration)this.utility.getConfiguration(), (long)5000L, () -> this.utility.getMiniHBaseCluster().getMaster().getLastMajorCompactionTimestamp(tableName) > firstCompactionTime);
        long numHFiles = this.utility.getNumHFiles(tableName, FAMILY);
        Assert.assertEquals((long)1L, (long)numHFiles);
        this.utility.getMiniHBaseCluster().getRegions(tableName).get(0).getStore(FAMILY).getStorefiles().forEach(file -> {
            byte[] rangeBytes = file.getMetadataValue(CustomTieringMultiFileWriter.CUSTOM_TIERING_TIME_RANGE);
            Assert.assertNotNull((Object)rangeBytes);
            try {
                TimeRangeTracker timeRangeTracker = TimeRangeTracker.parseFrom((byte[])rangeBytes);
                Assert.assertEquals((long)(recordTime - 347846400000L), (long)timeRangeTracker.getMin());
                Assert.assertEquals((long)recordTime, (long)timeRangeTracker.getMax());
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
        long secondCompactionTime = System.currentTimeMillis();
        this.utility.getAdmin().majorCompact(tableName);
        Waiter.waitFor((Configuration)this.utility.getConfiguration(), (long)5000L, () -> this.utility.getMiniHBaseCluster().getMaster().getLastMajorCompactionTimestamp(tableName) > secondCompactionTime);
        numHFiles = this.utility.getNumHFiles(tableName, FAMILY);
        Assert.assertEquals((long)2L, (long)numHFiles);
        this.utility.getMiniHBaseCluster().getRegions(tableName).get(0).getStore(FAMILY).getStorefiles().forEach(file -> {
            byte[] rangeBytes = file.getMetadataValue(CustomTieringMultiFileWriter.CUSTOM_TIERING_TIME_RANGE);
            Assert.assertNotNull((Object)rangeBytes);
            try {
                TimeRangeTracker timeRangeTracker = TimeRangeTracker.parseFrom((byte[])rangeBytes);
                Assert.assertEquals((long)timeRangeTracker.getMin(), (long)timeRangeTracker.getMax());
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        });
    }
}

