/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.storefiletracker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileListFilePrettyPrinter;
import org.apache.hadoop.hbase.regionserver.storefiletracker.StoreFileTrackerFactory;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestStoreFileListFilePrinter {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStoreFileListFilePrinter.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    @Rule
    public final TableNameTestRule tableName = new TableNameTestRule();
    public static byte[] family = Bytes.toBytes((String)"F");

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testPrintWithDirectPath() throws IOException {
        this.createTable();
        TableName tn = this.tableName.getTableName();
        String fileName = this.getStoreFileName(tn, family);
        String cf = new String(family);
        Configuration conf = UTIL.getConfiguration();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(stream);
        System.setOut(ps);
        StoreFileListFilePrettyPrinter sftPrinter = new StoreFileListFilePrettyPrinter(conf);
        FileSystem fs = ((HRegion)Iterables.getOnlyElement(UTIL.getMiniHBaseCluster().getRegions(tn))).getRegionFileSystem().getFileSystem();
        Path regionPath = ((HRegion)Iterables.getOnlyElement(UTIL.getMiniHBaseCluster().getRegions(tn))).getRegionFileSystem().getRegionDir();
        Path cfPath = new Path(regionPath, cf);
        Path path = new Path(cfPath, ".filelist");
        RemoteIterator iterator = fs.listFiles(path, false);
        while (iterator.hasNext()) {
            LocatedFileStatus lfs = (LocatedFileStatus)iterator.next();
            if (!lfs.getPath().getName().contains("f2") && !lfs.getPath().getName().contains("f1")) continue;
            String[] argsF = new String[]{"-f", lfs.getPath().toString()};
            sftPrinter.run(argsF);
            String result = new String(stream.toByteArray());
            String expect = fileName + "\n";
            Assert.assertEquals((Object)expect, (Object)result);
        }
    }

    @Test
    public void testPrintWithRegionOption() throws IOException {
        this.createTable();
        String cf = new String(family);
        TableName tn = this.tableName.getTableName();
        String fileName = this.getStoreFileName(tn, family);
        List<HRegion> regions = UTIL.getMiniHBaseCluster().getRegions(this.tableName.getTableName());
        String rn = regions.get(0).getRegionInfo().getEncodedName();
        String table = this.tableName.getTableName().toString();
        Configuration conf = UTIL.getConfiguration();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(stream);
        System.setOut(ps);
        StoreFileListFilePrettyPrinter sftPrinter = new StoreFileListFilePrettyPrinter(conf);
        String[] args = new String[]{"-r", rn, "-t", table, "-cf", cf};
        sftPrinter.run(args);
        String result = new String(stream.toByteArray());
        FileSystem fs = ((HRegion)Iterables.getOnlyElement(UTIL.getMiniHBaseCluster().getRegions(tn))).getRegionFileSystem().getFileSystem();
        Path regionPath = ((HRegion)Iterables.getOnlyElement(UTIL.getMiniHBaseCluster().getRegions(tn))).getRegionFileSystem().getRegionDir();
        Path cfPath = new Path(regionPath, cf);
        Path path = new Path(cfPath, ".filelist");
        RemoteIterator iterator = fs.listFiles(path, false);
        String expect = "";
        while (iterator.hasNext()) {
            LocatedFileStatus lfs = (LocatedFileStatus)iterator.next();
            if (!lfs.getPath().getName().contains("f2") && !lfs.getPath().getName().contains("f1")) continue;
            expect = expect + "Printing contents for file " + lfs.getPath() + "\n" + fileName + "\n";
        }
        Assert.assertEquals((Object)expect, (Object)result);
    }

    private String getStoreFileName(TableName table, byte[] family) {
        return ((HStoreFile)Iterables.getOnlyElement((Iterable)((HRegion)Iterables.getOnlyElement(UTIL.getMiniHBaseCluster().getRegions(table))).getStore(family).getStorefiles())).getPath().getName();
    }

    private void createTable() throws IOException {
        TableName tn = this.tableName.getTableName();
        byte[] row = Bytes.toBytes((String)"row");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        byte[] value = Bytes.toBytes((String)"value");
        TableDescriptor td = TableDescriptorBuilder.newBuilder((TableName)tn).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])family)).setValue("hbase.store.file-tracker.impl", StoreFileTrackerFactory.Trackers.FILE.name()).build();
        UTIL.getAdmin().createTable(td);
        try (Table table = UTIL.getConnection().getTable(tn);){
            table.put(new Put(row).addColumn(family, qualifier, value));
        }
        UTIL.flush(tn);
    }
}

