/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.access;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.AuthUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNameTestRule;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessor;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.access.PermissionStorage;
import org.apache.hadoop.hbase.security.access.SecureTestUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.SecurityTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SecurityTests.class, MediumTests.class})
public class TestCellACLWithMultipleVersions
extends SecureTestUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCellACLWithMultipleVersions.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCellACLWithMultipleVersions.class);
    @Rule
    public TableNameTestRule testTable = new TableNameTestRule();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] TEST_FAMILY1 = Bytes.toBytes((String)"f1");
    private static final byte[] TEST_FAMILY2 = Bytes.toBytes((String)"f2");
    private static final byte[] TEST_ROW = Bytes.toBytes((String)"cellpermtest");
    private static final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
    private static final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
    private static final byte[] ZERO = Bytes.toBytes((long)0L);
    private static final byte[] ONE = Bytes.toBytes((long)1L);
    private static final byte[] TWO = Bytes.toBytes((long)2L);
    private static Configuration conf;
    private static final String GROUP = "group";
    private static User GROUP_USER;
    private static User USER_OWNER;
    private static User USER_OTHER;
    private static User USER_OTHER2;
    private static String[] usersAndGroups;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        TestCellACLWithMultipleVersions.enableSecurity(conf);
        TestCellACLWithMultipleVersions.verifyConfiguration(conf);
        conf.setBoolean("hbase.security.access.early_out", false);
        TEST_UTIL.startMiniCluster();
        MasterCoprocessorHost cpHost = TEST_UTIL.getMiniHBaseCluster().getMaster().getMasterCoprocessorHost();
        cpHost.load(AccessController.class, 0, conf);
        AccessController ac = (AccessController)cpHost.findCoprocessor(AccessController.class);
        cpHost.createEnvironment((MasterCoprocessor)ac, 0, 1, conf);
        RegionServerCoprocessorHost rsHost = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getRegionServerCoprocessorHost();
        rsHost.createEnvironment((RegionServerCoprocessor)ac, 0, 1, conf);
        TEST_UTIL.waitTableEnabled(PermissionStorage.ACL_TABLE_NAME);
        USER_OWNER = User.createUserForTesting((Configuration)conf, (String)"owner", (String[])new String[0]);
        USER_OTHER = User.createUserForTesting((Configuration)conf, (String)"other", (String[])new String[0]);
        USER_OTHER2 = User.createUserForTesting((Configuration)conf, (String)"other2", (String[])new String[0]);
        GROUP_USER = User.createUserForTesting((Configuration)conf, (String)"group_user", (String[])new String[]{GROUP});
        usersAndGroups = new String[]{USER_OTHER.getShortName(), AuthUtil.toGroupEntry((String)GROUP)};
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(this.testTable.getTableName());
        HColumnDescriptor hcd = new HColumnDescriptor(TEST_FAMILY1);
        hcd.setMaxVersions(4);
        htd.setOwner(USER_OWNER);
        htd.addFamily(hcd);
        hcd = new HColumnDescriptor(TEST_FAMILY2);
        hcd.setMaxVersions(4);
        htd.setOwner(USER_OWNER);
        htd.addFamily(hcd);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());
             Admin admin = connection.getAdmin();){
            admin.createTable((TableDescriptor)htd, (byte[][])new byte[][]{Bytes.toBytes((String)"s")});
        }
        TEST_UTIL.waitTableEnabled(this.testTable.getTableName());
        LOG.info("Sleeping a second because of HBASE-12581");
        Threads.sleep((long)1000L);
    }

    @Test
    public void testCellPermissionwithVersions() throws Exception {
        final Map<String, Permission> writePerms = this.prepareCellPermissions(usersAndGroups, Permission.Action.WRITE);
        final Map<String, Permission> readPerms = this.prepareCellPermissions(usersAndGroups, Permission.Action.READ);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    long now = EnvironmentEdgeManager.currentTime();
                    Put p = new Put(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q1, now, ZERO);
                    p.setACL(writePerms);
                    t.put(p);
                    p = new Put(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q1, now + 1L, ZERO);
                    p.setACL(readPerms);
                    t.put(p);
                    p = new Put(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q1, now + 2L, ZERO);
                    p.setACL(writePerms);
                    t.put(p);
                    p = new Put(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q1, now + 3L, ZERO);
                    p.setACL(readPerms);
                    t.put(p);
                    p = new Put(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q1, now + 4L, ZERO);
                    p.setACL(writePerms);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        SecureTestUtil.AccessTestAction getQ1 = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        SecureTestUtil.AccessTestAction get2 = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        TestCellACLWithMultipleVersions.verifyAllowed(GROUP_USER, getQ1, 2);
        TestCellACLWithMultipleVersions.verifyAllowed(USER_OTHER, getQ1, 2);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Put p = new Put(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(writePerms);
                    t.put(p);
                    p = new Put(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(readPerms);
                    t.put(p);
                    p = new Put(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.setACL(writePerms);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        TestCellACLWithMultipleVersions.verifyAllowed(USER_OTHER, get2, 1);
        TestCellACLWithMultipleVersions.verifyAllowed(GROUP_USER, get2, 1);
    }

    private Map<String, Permission> prepareCellPermissions(String[] users, Permission.Action ... action) {
        HashMap<String, Permission> perms = new HashMap<String, Permission>(2);
        for (String user : users) {
            perms.put(user, new Permission(action));
        }
        return perms;
    }

    @Test
    public void testCellPermissionsWithDeleteMutipleVersions() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_ROW2 = Bytes.toBytes((String)"r2");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Put p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                    p = new Put(TEST_ROW2);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(user1.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Put p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, ZERO);
                    Map perms = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), user2.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP)}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    p.setACL(perms);
                    t.put(p);
                    p = new Put(TEST_ROW2);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, ZERO);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(perms);
                    t.put(p);
                }
                return null;
            }
        }, user1);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Delete d = new Delete(TEST_ROW1);
                    d.addColumns(TEST_FAMILY1, TEST_Q1);
                    d.addColumns(TEST_FAMILY1, TEST_Q2);
                    t.delete(d);
                }
                return null;
            }
        });
        this.verifyUserDeniedForDeleteMultipleVersions(user2, TEST_ROW2, TEST_Q1, TEST_Q2);
        this.verifyUserDeniedForDeleteMultipleVersions(GROUP_USER, TEST_ROW2, TEST_Q1, TEST_Q2);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Delete d = new Delete(TEST_ROW2);
                    d.addFamily(TEST_FAMILY1);
                    t.delete(d);
                }
                return null;
            }
        });
    }

    private void verifyUserDeniedForDeleteMultipleVersions(final User user, final byte[] row, final byte[] q1, final byte[] q2) throws IOException, InterruptedException {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    try (Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                        Delete d = new Delete(row);
                        d.addColumns(TEST_FAMILY1, q1);
                        d.addColumns(TEST_FAMILY1, q2);
                        t.delete(d);
                        Assert.fail((String)(user.getShortName() + " should not be allowed to delete the row"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    @Test
    public void testDeleteWithFutureTimestamp() throws Exception {
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Put p = new Put(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q2, ONE);
                    Map readAndWritePerms = TestCellACLWithMultipleVersions.this.prepareCellPermissions(usersAndGroups, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    p.setACL(readAndWritePerms);
                    t.put(p);
                    p = new Put(TEST_ROW).addColumn(TEST_FAMILY2, TEST_Q2, ONE);
                    p.setACL(readAndWritePerms);
                    t.put(p);
                    LOG.info("Stored at current time");
                    p = new Put(TEST_ROW).addColumn(TEST_FAMILY1, TEST_Q1, EnvironmentEdgeManager.currentTime() + 1000000L, ZERO);
                    p.setACL(TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{USER_OTHER.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP)}, new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        SecureTestUtil.AccessTestAction getQ1 = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        SecureTestUtil.AccessTestAction getQ2 = new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        TestCellACLWithMultipleVersions.verifyAllowed(getQ1, USER_OWNER, USER_OTHER, GROUP_USER);
        TestCellACLWithMultipleVersions.verifyAllowed(getQ2, USER_OWNER, USER_OTHER, GROUP_USER);
        SecureTestUtil.AccessTestAction deleteFamily1 = this.getDeleteFamilyAction(TEST_FAMILY1);
        SecureTestUtil.AccessTestAction deleteFamily2 = this.getDeleteFamilyAction(TEST_FAMILY2);
        TestCellACLWithMultipleVersions.verifyAllowed(deleteFamily1, USER_OTHER);
        TestCellACLWithMultipleVersions.verifyAllowed(deleteFamily2, GROUP_USER);
        TestCellACLWithMultipleVersions.verifyAllowed(getQ1, USER_OWNER, USER_OTHER, GROUP_USER);
        TestCellACLWithMultipleVersions.verifyIfNull(getQ2, USER_OTHER, GROUP_USER);
    }

    private SecureTestUtil.AccessTestAction getDeleteFamilyAction(final byte[] fam) {
        SecureTestUtil.AccessTestAction deleteFamilyAction = new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                Delete delete = new Delete(TEST_ROW).addFamily(fam);
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    t.delete(delete);
                }
                return null;
            }
        };
        return deleteFamilyAction;
    }

    @Test
    public void testCellPermissionsWithDeleteWithUserTs() throws Exception {
        USER_OWNER.runAs((PrivilegedExceptionAction)new SecureTestUtil.AccessTestAction(){

            /*
             * Exception decompiling
             */
            @Override
            public Object run() throws Exception {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        USER_OTHER2.runAs((PrivilegedExceptionAction)new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Delete d = new Delete(TEST_ROW, 124L);
                    d.addColumns(TEST_FAMILY1, TEST_Q1);
                    t.delete(d);
                }
                return null;
            }
        });
        USER_OTHER2.runAs((PrivilegedExceptionAction)new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Delete d = new Delete(TEST_ROW);
                    d.addColumns(TEST_FAMILY1, TEST_Q2, 124L);
                    t.delete(d);
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsWithDeleteExactVersion() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Map permsU1andOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Map permsU2andGUandOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user2.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Put p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY2, TEST_Q1, 123L, ZERO);
                    p.addColumn(TEST_FAMILY2, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY2, TEST_Q1, 125L, ZERO);
                    p.addColumn(TEST_FAMILY2, TEST_Q2, 125L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY2, TEST_Q1, 129L, ZERO);
                    p.addColumn(TEST_FAMILY2, TEST_Q2, 129L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Delete d = new Delete(TEST_ROW1);
                    d.addColumn(TEST_FAMILY1, TEST_Q1, 123L);
                    d.addColumn(TEST_FAMILY1, TEST_Q2);
                    d.addFamilyVersion(TEST_FAMILY2, 125L);
                    t.delete(d);
                }
                return null;
            }
        });
        this.verifyUserDeniedForDeleteExactVersion(user2, TEST_ROW1, TEST_Q1, TEST_Q2);
        this.verifyUserDeniedForDeleteExactVersion(GROUP_USER, TEST_ROW1, TEST_Q1, TEST_Q2);
    }

    private void verifyUserDeniedForDeleteExactVersion(final User user, final byte[] row, final byte[] q1, final byte[] q2) throws IOException, InterruptedException {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    try (Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                        Delete d = new Delete(row, 127L);
                        d.addColumns(TEST_FAMILY1, q1);
                        d.addColumns(TEST_FAMILY1, q2);
                        d.addFamily(TEST_FAMILY2, 129L);
                        t.delete(d);
                        Assert.fail((String)(user.getShortName() + " can not do the delete"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsForIncrementWithMultipleVersions() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Map permsU1andOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Map permsU2andGUandOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user2.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Put p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Increment inc = new Increment(TEST_ROW1);
                    inc.setTimeRange(0L, 123L);
                    inc.addColumn(TEST_FAMILY1, TEST_Q1, 2L);
                    t.increment(inc);
                    t.incrementColumnValue(TEST_ROW1, TEST_FAMILY1, TEST_Q2, 1L);
                }
                return null;
            }
        });
        this.verifyUserDeniedForIncrementMultipleVersions(user2, TEST_ROW1, TEST_Q2);
        this.verifyUserDeniedForIncrementMultipleVersions(GROUP_USER, TEST_ROW1, TEST_Q2);
    }

    private void verifyUserDeniedForIncrementMultipleVersions(final User user, final byte[] row, final byte[] q1) throws IOException, InterruptedException {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    try (Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                        Increment inc = new Increment(row);
                        inc.setTimeRange(0L, 127L);
                        inc.addColumn(TEST_FAMILY1, q1, 2L);
                        t.increment(inc);
                        Assert.fail((String)(user.getShortName() + " cannot do the increment."));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsForPutWithMultipleVersions() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q1 = Bytes.toBytes((String)"q1");
        final byte[] TEST_Q2 = Bytes.toBytes((String)"q2");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Map permsU1andOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Map permsU2andGUandOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    permsU2andGUandOwner.put(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    permsU2andGUandOwner.put(USER_OWNER.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    Put p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Put p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, 125L, ZERO);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, ZERO);
                    p.setACL(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE}));
                    t.put(p);
                }
                return null;
            }
        });
        this.verifyUserDeniedForPutMultipleVersions(user2, TEST_ROW1, TEST_Q1, TEST_Q2, ZERO);
        this.verifyUserDeniedForPutMultipleVersions(GROUP_USER, TEST_ROW1, TEST_Q1, TEST_Q2, ZERO);
    }

    private void verifyUserDeniedForPutMultipleVersions(final User user, final byte[] row, final byte[] q1, final byte[] q2, final byte[] value) throws IOException, InterruptedException {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    try (Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                        Put p = new Put(row);
                        p.addColumn(TEST_FAMILY1, q1, 124L, value);
                        p.addColumn(TEST_FAMILY1, q2, value);
                        t.put(p);
                        Assert.fail((String)(user.getShortName() + " cannot do the put."));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    @Test
    public void testCellPermissionsForCheckAndDelete() throws Exception {
        final byte[] TEST_ROW1 = Bytes.toBytes((String)"r1");
        final byte[] TEST_Q3 = Bytes.toBytes((String)"q3");
        final byte[] ZERO = Bytes.toBytes((long)0L);
        final User user1 = User.createUserForTesting((Configuration)conf, (String)"user1", (String[])new String[0]);
        final User user2 = User.createUserForTesting((Configuration)conf, (String)"user2", (String[])new String[0]);
        TestCellACLWithMultipleVersions.verifyAllowed(new SecureTestUtil.AccessTestAction(){

            @Override
            public Object run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Map permsU1andOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Map permsU1andU2andGUandOwner = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), user2.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP), USER_OWNER.getShortName()}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Map permsU1_U2andGU = TestCellACLWithMultipleVersions.this.prepareCellPermissions(new String[]{user1.getShortName(), user2.getShortName(), AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP)}, new Permission.Action[]{Permission.Action.READ, Permission.Action.WRITE});
                    Put p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, 120L, ZERO);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, 120L, ZERO);
                    p.addColumn(TEST_FAMILY1, TEST_Q3, 120L, ZERO);
                    p.setACL(permsU1andU2andGUandOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, 123L, ZERO);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, 123L, ZERO);
                    p.addColumn(TEST_FAMILY1, TEST_Q3, 123L, ZERO);
                    p.setACL(permsU1andOwner);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q1, 127L, ZERO);
                    p.setACL(permsU1_U2andGU);
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q2, 127L, ZERO);
                    p.setACL(user2.getShortName(), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                    p = new Put(TEST_ROW1);
                    p.addColumn(TEST_FAMILY1, TEST_Q3, 127L, ZERO);
                    p.setACL(AuthUtil.toGroupEntry((String)TestCellACLWithMultipleVersions.GROUP), new Permission(new Permission.Action[]{Permission.Action.READ}));
                    t.put(p);
                }
                return null;
            }
        }, USER_OWNER);
        user1.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Delete d = new Delete(TEST_ROW1);
                    d.addColumns(TEST_FAMILY1, TEST_Q1, 120L);
                    t.checkAndMutate(TEST_ROW1, TEST_FAMILY1).qualifier(TEST_Q1).ifEquals(ZERO).thenDelete(d);
                }
                return null;
            }
        });
        this.verifyUserDeniedForCheckAndDelete(user2, TEST_ROW1, ZERO);
        this.verifyUserDeniedForCheckAndDelete(GROUP_USER, TEST_ROW1, ZERO);
        this.verifyUserAllowedforCheckAndDelete(user2, TEST_ROW1, TEST_Q2, ZERO);
        this.verifyUserAllowedforCheckAndDelete(GROUP_USER, TEST_ROW1, TEST_Q3, ZERO);
    }

    private void verifyUserAllowedforCheckAndDelete(User user, final byte[] row, final byte[] q1, final byte[] value) throws IOException, InterruptedException {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);
                     Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                    Delete d = new Delete(row);
                    d.addColumn(TEST_FAMILY1, q1, 120L);
                    t.checkAndMutate(row, TEST_FAMILY1).qualifier(q1).ifEquals(value).thenDelete(d);
                }
                return null;
            }
        });
    }

    private void verifyUserDeniedForCheckAndDelete(final User user, final byte[] row, final byte[] value) throws IOException, InterruptedException {
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try (Connection connection = ConnectionFactory.createConnection((Configuration)conf);){
                    try (Table t = connection.getTable(TestCellACLWithMultipleVersions.this.testTable.getTableName());){
                        Delete d = new Delete(row);
                        d.addColumns(TEST_FAMILY1, TEST_Q1);
                        t.checkAndMutate(row, TEST_FAMILY1).qualifier(TEST_Q1).ifEquals(value).thenDelete(d);
                        Assert.fail((String)(user.getShortName() + " should not be allowed to do checkAndDelete"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return null;
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        try {
            TEST_UTIL.deleteTable(this.testTable.getTableName());
        }
        catch (TableNotFoundException ex) {
            LOG.info("Test deleted table " + this.testTable.getTableName());
        }
        Assert.assertEquals((long)0L, (long)PermissionStorage.getTablePermissions((Configuration)conf, (TableName)this.testTable.getTableName()).size());
    }

    static /* synthetic */ User access$1200() {
        return USER_OTHER2;
    }

    static /* synthetic */ byte[] access$1300() {
        return TWO;
    }
}

