/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.balancer.BalancerTestBase;
import org.apache.hadoop.hbase.master.balancer.ServerAndLoad;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfoManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.ArrayListMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.Assert;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class RSGroupableBalancerTestBase
extends BalancerTestBase {
    static String[] groups = new String[]{"default", "dg2", "dg3", "dg4"};
    static TableName table0 = TableName.valueOf((String)"dt0");
    static TableName[] tables = new TableName[]{TableName.valueOf((String)"dt1"), TableName.valueOf((String)"dt2"), TableName.valueOf((String)"dt3"), TableName.valueOf((String)"dt4")};
    static List<ServerName> servers;
    static Map<String, RSGroupInfo> groupMap;
    static Map<TableName, String> tableMap;
    static List<TableDescriptor> tableDescs;
    int[] regionAssignment = new int[]{2, 5, 7, 10, 4, 3, 1};
    static int regionId;
    static Configuration conf;

    protected void assertClusterAsBalanced(ArrayListMultimap<String, ServerAndLoad> groupLoadMap) {
        for (String gName : groupLoadMap.keySet()) {
            List groupLoad = groupLoadMap.get((Object)gName);
            int numServers = groupLoad.size();
            int numRegions = 0;
            int maxRegions = 0;
            int minRegions = Integer.MAX_VALUE;
            for (ServerAndLoad server : groupLoad) {
                int nr = server.getLoad();
                if (nr > maxRegions) {
                    maxRegions = nr;
                }
                if (nr < minRegions) {
                    minRegions = nr;
                }
                numRegions += nr;
            }
            if (maxRegions - minRegions < 2) {
                return;
            }
            int min = numRegions / numServers;
            int max = numRegions % numServers == 0 ? min : min + 1;
            for (ServerAndLoad server : groupLoad) {
                Assert.assertTrue((server.getLoad() <= max ? 1 : 0) != 0);
                Assert.assertTrue((server.getLoad() >= min ? 1 : 0) != 0);
            }
        }
    }

    protected void assertImmediateAssignment(List<RegionInfo> regions, List<ServerName> servers, Map<RegionInfo, ServerName> assignments) throws IOException {
        for (RegionInfo region : regions) {
            Assert.assertTrue((boolean)assignments.containsKey(region));
            ServerName server = assignments.get(region);
            TableName tableName = region.getTable();
            String groupName = RSGroupableBalancerTestBase.getMockedGroupInfoManager().getRSGroupOfTable(tableName);
            Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)groupName));
            RSGroupInfo gInfo = RSGroupableBalancerTestBase.getMockedGroupInfoManager().getRSGroup(groupName);
            Assert.assertTrue((String)"Region is not correctly assigned to group servers.", (boolean)gInfo.containsServer(server.getAddress()));
        }
    }

    protected void assertRetainedAssignment(Map<RegionInfo, ServerName> existing, List<ServerName> servers, Map<ServerName, List<RegionInfo>> assignment) throws FileNotFoundException, IOException {
        TreeSet<ServerName> onlineServerSet = new TreeSet<ServerName>(servers);
        TreeSet<RegionInfo> assignedRegions = new TreeSet<RegionInfo>(RegionInfo.COMPARATOR);
        for (Map.Entry<ServerName, List<RegionInfo>> a : assignment.entrySet()) {
            Assert.assertTrue((String)"Region assigned to server that was not listed as online", (boolean)onlineServerSet.contains(a.getKey()));
            for (RegionInfo r : a.getValue()) {
                assignedRegions.add(r);
            }
        }
        Assert.assertEquals((long)existing.size(), (long)assignedRegions.size());
        TreeSet<String> onlineHostNames = new TreeSet<String>();
        for (ServerName serverName : servers) {
            onlineHostNames.add(serverName.getHostname());
        }
        for (Map.Entry entry : assignment.entrySet()) {
            ServerName currentServer = (ServerName)entry.getKey();
            for (RegionInfo r : (List)entry.getValue()) {
                ServerName oldAssignedServer = existing.get(r);
                TableName tableName = r.getTable();
                String groupName = RSGroupableBalancerTestBase.getMockedGroupInfoManager().getRSGroupOfTable(tableName);
                Assert.assertTrue((boolean)StringUtils.isNotEmpty((CharSequence)groupName));
                RSGroupInfo gInfo = RSGroupableBalancerTestBase.getMockedGroupInfoManager().getRSGroup(groupName);
                Assert.assertTrue((String)"Region is not correctly assigned to group servers.", (boolean)gInfo.containsServer(currentServer.getAddress()));
                if (oldAssignedServer == null || !onlineHostNames.contains(oldAssignedServer.getHostname()) || oldAssignedServer.getAddress().equals((Object)currentServer.getAddress())) continue;
                Assert.assertFalse((boolean)gInfo.containsServer(oldAssignedServer.getAddress()));
            }
        }
    }

    protected String printStats(ArrayListMultimap<String, ServerAndLoad> groupBasedLoad) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (String groupName : groupBasedLoad.keySet()) {
            sb.append("Stats for group: " + groupName);
            sb.append("\n");
            sb.append(groupMap.get(groupName).getServers());
            sb.append("\n");
            List groupLoad = groupBasedLoad.get((Object)groupName);
            int numServers = groupLoad.size();
            int totalRegions = 0;
            sb.append("Per Server Load: \n");
            for (ServerAndLoad sLoad : groupLoad) {
                sb.append("Server :" + sLoad.getServerName() + " Load : " + sLoad.getLoad() + "\n");
                totalRegions += sLoad.getLoad();
            }
            sb.append(" Group Statistics : \n");
            float average = (float)totalRegions / (float)numServers;
            int max = (int)Math.ceil(average);
            int min = (int)Math.floor(average);
            sb.append("[srvr=" + numServers + " rgns=" + totalRegions + " avg=" + average + " max=" + max + " min=" + min + "]");
            sb.append("\n");
            sb.append("===============================");
            sb.append("\n");
        }
        return sb.toString();
    }

    protected ArrayListMultimap<String, ServerAndLoad> convertToGroupBasedMap(Map<ServerName, List<RegionInfo>> serversMap) throws IOException {
        ArrayListMultimap loadMap = ArrayListMultimap.create();
        for (RSGroupInfo gInfo : RSGroupableBalancerTestBase.getMockedGroupInfoManager().listRSGroups()) {
            Set groupServers = gInfo.getServers();
            for (Address hostPort : groupServers) {
                ServerName actual = null;
                for (ServerName entry : servers) {
                    if (!entry.getAddress().equals((Object)hostPort)) continue;
                    actual = entry;
                    break;
                }
                List<RegionInfo> regions = serversMap.get(actual);
                Assert.assertTrue((String)("No load for " + actual), (regions != null ? 1 : 0) != 0);
                loadMap.put((Object)gInfo.getName(), (Object)new ServerAndLoad(actual, regions.size()));
            }
        }
        return loadMap;
    }

    protected ArrayListMultimap<String, ServerAndLoad> reconcile(ArrayListMultimap<String, ServerAndLoad> previousLoad, List<RegionPlan> plans) {
        ArrayListMultimap result = ArrayListMultimap.create();
        result.putAll(previousLoad);
        if (plans != null) {
            for (RegionPlan plan : plans) {
                ServerName source = plan.getSource();
                this.updateLoad((ArrayListMultimap<String, ServerAndLoad>)result, source, -1);
                ServerName destination = plan.getDestination();
                this.updateLoad((ArrayListMultimap<String, ServerAndLoad>)result, destination, 1);
            }
        }
        return result;
    }

    protected void updateLoad(ArrayListMultimap<String, ServerAndLoad> previousLoad, ServerName sn, int diff) {
        for (String groupName : previousLoad.keySet()) {
            ServerAndLoad newSAL = null;
            ServerAndLoad oldSAL = null;
            for (ServerAndLoad sal : previousLoad.get((Object)groupName)) {
                if (!ServerName.isSameAddress((ServerName)sn, (ServerName)sal.getServerName())) continue;
                oldSAL = sal;
                newSAL = new ServerAndLoad(sn, sal.getLoad() + diff);
                break;
            }
            if (newSAL == null) continue;
            previousLoad.remove((Object)groupName, oldSAL);
            previousLoad.put((Object)groupName, newSAL);
            break;
        }
    }

    protected Map<ServerName, List<RegionInfo>> mockClusterServers() throws IOException {
        Assert.assertTrue((servers.size() == this.regionAssignment.length ? 1 : 0) != 0);
        TreeMap<ServerName, List<RegionInfo>> assignment = new TreeMap<ServerName, List<RegionInfo>>();
        for (int i = 0; i < servers.size(); ++i) {
            int numRegions = this.regionAssignment[i];
            List<RegionInfo> regions = this.assignedRegions(numRegions, servers.get(i));
            assignment.put(servers.get(i), regions);
        }
        return assignment;
    }

    protected List<RegionInfo> randomRegions(int numRegions) {
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(numRegions);
        byte[] start = new byte[16];
        Bytes.random((byte[])start);
        byte[] end = new byte[16];
        Bytes.random((byte[])end);
        int regionIdx = ThreadLocalRandom.current().nextInt(tables.length);
        for (int i = 0; i < numRegions; ++i) {
            Bytes.putInt((byte[])start, (int)0, (int)(numRegions << 1));
            Bytes.putInt((byte[])end, (int)0, (int)((numRegions << 1) + 1));
            int tableIndex = (i + regionIdx) % tables.length;
            regions.add(RegionInfoBuilder.newBuilder((TableName)tables[tableIndex]).setStartKey(start).setEndKey(end).setSplit(false).setRegionId((long)regionId++).build());
        }
        return regions;
    }

    protected List<RegionInfo> assignedRegions(int numRegions, ServerName sn) throws IOException {
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>(numRegions);
        byte[] start = new byte[16];
        byte[] end = new byte[16];
        Bytes.putInt((byte[])start, (int)0, (int)(numRegions << 1));
        Bytes.putInt((byte[])end, (int)0, (int)((numRegions << 1) + 1));
        for (int i = 0; i < numRegions; ++i) {
            TableName tableName = this.getTableName(sn);
            regions.add(RegionInfoBuilder.newBuilder((TableName)tableName).setStartKey(start).setEndKey(end).setSplit(false).setRegionId((long)regionId++).build());
        }
        return regions;
    }

    protected static List<ServerName> generateServers(int numServers) {
        ArrayList<ServerName> servers = new ArrayList<ServerName>(numServers);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < numServers; ++i) {
            String host = "server" + ((Random)rand).nextInt(100000);
            int port = ((Random)rand).nextInt(60000);
            servers.add(ServerName.valueOf((String)host, (int)port, (long)-1L));
        }
        return servers;
    }

    protected static Map<String, RSGroupInfo> constructGroupInfo(List<ServerName> servers, String[] groups) {
        Assert.assertTrue((servers != null ? 1 : 0) != 0);
        Assert.assertTrue((servers.size() >= groups.length ? 1 : 0) != 0);
        int index = 0;
        HashMap<String, RSGroupInfo> groupMap = new HashMap<String, RSGroupInfo>();
        for (String grpName : groups) {
            RSGroupInfo RSGroupInfo2 = new RSGroupInfo(grpName);
            RSGroupInfo2.addServer(servers.get(index).getAddress());
            groupMap.put(grpName, RSGroupInfo2);
            ++index;
        }
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        while (index < servers.size()) {
            int grpIndex = ((Random)rand).nextInt(groups.length);
            ((RSGroupInfo)groupMap.get(groups[grpIndex])).addServer(servers.get(index).getAddress());
            ++index;
        }
        return groupMap;
    }

    protected static List<TableDescriptor> constructTableDesc(boolean hasBogusTable) {
        ArrayList tds = Lists.newArrayList();
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        int index = ((Random)rand).nextInt(groups.length);
        for (int i = 0; i < tables.length; ++i) {
            TableDescriptor htd = TableDescriptorBuilder.newBuilder((TableName)tables[i]).build();
            int grpIndex = (i + index) % groups.length;
            String groupName = groups[grpIndex];
            tableMap.put(tables[i], groupName);
            tds.add(htd);
        }
        if (hasBogusTable) {
            tableMap.put(table0, "");
            tds.add(TableDescriptorBuilder.newBuilder((TableName)table0).build());
        }
        return tds;
    }

    protected static MasterServices getMockedMaster() throws IOException {
        TableDescriptors tds = (TableDescriptors)Mockito.mock(TableDescriptors.class);
        Mockito.when((Object)tds.get(tables[0])).thenReturn((Object)tableDescs.get(0));
        Mockito.when((Object)tds.get(tables[1])).thenReturn((Object)tableDescs.get(1));
        Mockito.when((Object)tds.get(tables[2])).thenReturn((Object)tableDescs.get(2));
        Mockito.when((Object)tds.get(tables[3])).thenReturn((Object)tableDescs.get(3));
        MasterServices services = (MasterServices)Mockito.mock(HMaster.class);
        Mockito.when((Object)services.getTableDescriptors()).thenReturn((Object)tds);
        AssignmentManager am = (AssignmentManager)Mockito.mock(AssignmentManager.class);
        Mockito.when((Object)services.getAssignmentManager()).thenReturn((Object)am);
        Mockito.when((Object)services.getConfiguration()).thenReturn((Object)conf);
        return services;
    }

    protected static RSGroupInfoManager getMockedGroupInfoManager() throws IOException {
        RSGroupInfoManager gm = (RSGroupInfoManager)Mockito.mock(RSGroupInfoManager.class);
        Mockito.when((Object)gm.getRSGroup((String)Mockito.any())).thenAnswer((Answer)new Answer<RSGroupInfo>(){

            public RSGroupInfo answer(InvocationOnMock invocation) throws Throwable {
                return groupMap.get(invocation.getArgument(0));
            }
        });
        Mockito.when((Object)gm.listRSGroups()).thenReturn((Object)Lists.newLinkedList(groupMap.values()));
        Mockito.when((Object)gm.isOnline()).thenReturn((Object)true);
        Mockito.when((Object)gm.getRSGroupOfTable((TableName)Mockito.any())).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return tableMap.get(invocation.getArgument(0));
            }
        });
        return gm;
    }

    protected TableName getTableName(ServerName sn) throws IOException {
        TableName tableName = null;
        RSGroupInfoManager gm = RSGroupableBalancerTestBase.getMockedGroupInfoManager();
        RSGroupInfo groupOfServer = null;
        for (RSGroupInfo gInfo : gm.listRSGroups()) {
            if (!gInfo.containsServer(sn.getAddress())) continue;
            groupOfServer = gInfo;
            break;
        }
        for (TableDescriptor desc : tableDescs) {
            if (!gm.getRSGroupOfTable(desc.getTableName()).endsWith(groupOfServer.getName())) continue;
            tableName = desc.getTableName();
        }
        return tableName;
    }

    static {
        tableMap = new HashMap<TableName, String>();
        regionId = 0;
        conf = HBaseConfiguration.create();
    }
}

