/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.backup.regionserver;

import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.backup.impl.BackupManager;
import org.apache.hadoop.hbase.backup.regionserver.LogRollBackupSubprocedure;
import org.apache.hadoop.hbase.backup.regionserver.LogRollBackupSubprocedurePool;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hadoop.hbase.procedure.ProcedureMemberRpcs;
import org.apache.hadoop.hbase.procedure.RegionServerProcedureManager;
import org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hadoop.hbase.procedure.SubprocedureFactory;
import org.apache.hadoop.hbase.procedure.ZKProcedureCoordinationManager;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class LogRollRegionServerProcedureManager
extends RegionServerProcedureManager {
    private static final Logger LOG = LoggerFactory.getLogger(LogRollRegionServerProcedureManager.class);
    public static final String BACKUP_REQUEST_THREADS_KEY = "hbase.backup.region.pool.threads";
    public static final int BACKUP_REQUEST_THREADS_DEFAULT = 10;
    public static final String BACKUP_TIMEOUT_MILLIS_KEY = "hbase.backup.timeout";
    public static final long BACKUP_TIMEOUT_MILLIS_DEFAULT = 60000L;
    public static final String BACKUP_REQUEST_WAKE_MILLIS_KEY = "hbase.backup.region.wakefrequency";
    private static final long BACKUP_REQUEST_WAKE_MILLIS_DEFAULT = 500L;
    private RegionServerServices rss;
    private ProcedureMemberRpcs memberRpcs;
    private ProcedureMember member;
    private boolean started = false;

    public void start() {
        if (!BackupManager.isBackupEnabled(this.rss.getConfiguration())) {
            LOG.warn("Backup is not enabled. Check your hbase.backup.enable setting");
            return;
        }
        this.memberRpcs.start(this.rss.getServerName().toString(), this.member);
        this.started = true;
        LOG.info("Started region server backup manager.");
    }

    public void stop(boolean force) throws IOException {
        if (!this.started) {
            return;
        }
        String mode = force ? "abruptly" : "gracefully";
        LOG.info("Stopping RegionServerBackupManager " + mode + ".");
        try {
            this.member.close();
        }
        finally {
            this.memberRpcs.close();
        }
    }

    public Subprocedure buildSubprocedure(byte[] data) {
        if (this.rss.isStopping() || this.rss.isStopped()) {
            throw new IllegalStateException("Can't start backup procedure on RS: " + this.rss.getServerName() + ", because stopping/stopped!");
        }
        LOG.info("Attempting to run a roll log procedure for backup.");
        ForeignExceptionDispatcher errorDispatcher = new ForeignExceptionDispatcher();
        Configuration conf = this.rss.getConfiguration();
        long timeoutMillis = conf.getLong(BACKUP_TIMEOUT_MILLIS_KEY, 60000L);
        long wakeMillis = conf.getLong(BACKUP_REQUEST_WAKE_MILLIS_KEY, 500L);
        LogRollBackupSubprocedurePool taskManager = new LogRollBackupSubprocedurePool(this.rss.getServerName().toString(), conf);
        return new LogRollBackupSubprocedure(this.rss, this.member, errorDispatcher, wakeMillis, timeoutMillis, taskManager, data);
    }

    public void initialize(RegionServerServices rss) throws KeeperException {
        this.rss = rss;
        if (!BackupManager.isBackupEnabled(rss.getConfiguration())) {
            LOG.warn("Backup is not enabled. Check your hbase.backup.enable setting");
            return;
        }
        ZKProcedureCoordinationManager coordManager = new ZKProcedureCoordinationManager((Server)rss);
        this.memberRpcs = coordManager.getProcedureMemberRpcs("rolllog-proc");
        Configuration conf = rss.getConfiguration();
        long keepAlive = conf.getLong(BACKUP_TIMEOUT_MILLIS_KEY, 60000L);
        int opThreads = conf.getInt(BACKUP_REQUEST_THREADS_KEY, 10);
        ThreadPoolExecutor pool = ProcedureMember.defaultPool((String)rss.getServerName().toString(), (int)opThreads, (long)keepAlive);
        this.member = new ProcedureMember(this.memberRpcs, pool, (SubprocedureFactory)new BackupSubprocedureBuilder());
    }

    public String getProcedureSignature() {
        return "backup-proc";
    }

    public class BackupSubprocedureBuilder
    implements SubprocedureFactory {
        public Subprocedure buildSubprocedure(String name, byte[] data) {
            return LogRollRegionServerProcedureManager.this.buildSubprocedure(data);
        }
    }
}

