/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.client.AsyncBufferedMutator;
import org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public interface AsyncBufferedMutatorBuilder {
    public AsyncBufferedMutatorBuilder setOperationTimeout(long var1, TimeUnit var3);

    public AsyncBufferedMutatorBuilder setRpcTimeout(long var1, TimeUnit var3);

    public AsyncBufferedMutatorBuilder setRetryPause(long var1, TimeUnit var3);

    default public AsyncBufferedMutatorBuilder setWriteBufferPeriodicFlush(long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException("Not implemented");
    }

    default public AsyncBufferedMutatorBuilder disableWriteBufferPeriodicFlush() {
        return this.setWriteBufferPeriodicFlush(0L, TimeUnit.NANOSECONDS);
    }

    default public AsyncBufferedMutatorBuilder setMaxRetries(int maxRetries) {
        return this.setMaxAttempts(ConnectionUtils.retries2Attempts(maxRetries));
    }

    public AsyncBufferedMutatorBuilder setMaxAttempts(int var1);

    public AsyncBufferedMutatorBuilder setStartLogErrorsCnt(int var1);

    public AsyncBufferedMutatorBuilder setWriteBufferSize(long var1);

    public AsyncBufferedMutatorBuilder setMaxKeyValueSize(int var1);

    default public AsyncBufferedMutatorBuilder setRequestAttribute(String key, byte[] value) {
        throw new UnsupportedOperationException("Not implemented");
    }

    default public AsyncBufferedMutatorBuilder setRequestAttributes(Map<String, byte[]> requestAttributes) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public AsyncBufferedMutatorBuilder setMaxMutations(int var1);

    public AsyncBufferedMutator build();
}

