/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestIngest;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessController;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.test.LoadTestDataGeneratorWithACL;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestIngestWithACL
extends IntegrationTestIngest {
    private static final char COLON = ':';
    public static final char HYPHEN = '-';
    private static final int SPECIAL_PERM_CELL_INSERTION_FACTOR = 100;
    public static final String OPT_SUPERUSER = "superuser";
    public static final String OPT_USERS = "userlist";
    public static final String OPT_AUTHN = "authinfo";
    private String superUser = "owner";
    private String userNames = "user1,user2,user3,user4";
    private String authnFileName;

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(null);
        Configuration conf = this.util.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.coprocessor.master.classes", AccessController.class.getName());
        conf.set("hbase.coprocessor.region.classes", AccessController.class.getName());
        conf.setBoolean("hbase.security.access.early_out", false);
        super.setUpCluster();
    }

    @Override
    protected String[] getArgsForLoadTestTool(String mode, String modeSpecificArg, long startKey, long numKeys) {
        String[] args = super.getArgsForLoadTestTool(mode, modeSpecificArg, startKey, numKeys);
        ArrayList<String> tmp = new ArrayList<String>(Arrays.asList(args));
        tmp.add("-generator");
        StringBuilder sb = new StringBuilder(LoadTestDataGeneratorWithACL.class.getName());
        sb.append(':');
        if (User.isHBaseSecurityEnabled((Configuration)this.getConf())) {
            sb.append(this.authnFileName);
            sb.append(':');
        }
        sb.append(this.superUser);
        sb.append(':');
        sb.append(this.userNames);
        sb.append(':');
        sb.append(Integer.toString(100));
        tmp.add(sb.toString());
        return tmp.toArray(new String[tmp.size()]);
    }

    @Override
    protected void addOptions() {
        super.addOptions();
        super.addOptWithArg(OPT_SUPERUSER, "Super user name used to add the ACL permissions");
        super.addOptWithArg(OPT_USERS, "List of users to be added with the ACLs.  Should be comma seperated.");
        super.addOptWithArg(OPT_AUTHN, "The name of the properties file that contains kerberos key tab file and principal definitions. The principal key in the file should be of the form hbase.<username>.kerberos.principal. The keytab key in the file should be of the form hbase.<username>.keytab.file. Example:  hbase.user1.kerberos.principal=user1/fully.qualified.domain.name@YOUR-REALM.COM, hbase.user1.keytab.file=<filelocation>.");
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        super.processOptions(cmd);
        if (cmd.hasOption(OPT_SUPERUSER)) {
            this.superUser = cmd.getOptionValue(OPT_SUPERUSER);
        }
        if (cmd.hasOption(OPT_USERS)) {
            this.userNames = cmd.getOptionValue(OPT_USERS);
        }
        if (User.isHBaseSecurityEnabled((Configuration)this.getConf())) {
            boolean authFileNotFound = false;
            if (cmd.hasOption(OPT_AUTHN)) {
                this.authnFileName = cmd.getOptionValue(OPT_AUTHN);
                if (StringUtils.isEmpty((CharSequence)this.authnFileName)) {
                    authFileNotFound = true;
                }
            } else {
                authFileNotFound = true;
            }
            if (authFileNotFound) {
                super.printUsage();
                System.exit(1);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestIngestWithACL(), (String[])args);
        System.exit(ret);
    }
}

