/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode.snapshot;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Array;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import org.junit.Assert;
import org.junit.Test;

public class TestSnapshotStatsMXBean {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSnapshotStatsMXBeanInfo() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = null;
        String pathName = "/snapshot";
        Path path = new Path(pathName);
        try {
            cluster = new MiniDFSCluster.Builder(conf).build();
            cluster.waitActive();
            SnapshotManager sm = cluster.getNamesystem().getSnapshotManager();
            DistributedFileSystem dfs = cluster.getFileSystem();
            dfs.mkdirs(path);
            dfs.allowSnapshot(path);
            dfs.createSnapshot(path);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mxbeanName = new ObjectName("Hadoop:service=NameNode,name=SnapshotInfo");
            CompositeData[] directories = (CompositeData[])mbs.getAttribute(mxbeanName, "SnapshottableDirectories");
            int numDirectories = Array.getLength(directories);
            Assert.assertEquals((long)sm.getNumSnapshottableDirs(), (long)numDirectories);
            CompositeData[] snapshots = (CompositeData[])mbs.getAttribute(mxbeanName, "Snapshots");
            int numSnapshots = Array.getLength(snapshots);
            Assert.assertEquals((long)sm.getNumSnapshots(), (long)numSnapshots);
            CompositeData d = (CompositeData)Array.get(directories, 0);
            CompositeData s = (CompositeData)Array.get(snapshots, 0);
            Assert.assertTrue((boolean)((String)d.get("path")).contains(pathName));
            Assert.assertTrue((boolean)((String)s.get("snapshotDirectory")).contains(pathName));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }
}

