/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.EncodingState;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.encoding.NoneEncoder;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NoOpDataBlockEncoder
implements HFileDataBlockEncoder {
    public static final NoOpDataBlockEncoder INSTANCE = new NoOpDataBlockEncoder();

    private NoOpDataBlockEncoder() {
    }

    @Override
    public void encode(Cell cell, HFileBlockEncodingContext encodingCtx, DataOutputStream out) throws IOException {
        NoneEncodingState state = (NoneEncodingState)encodingCtx.getEncodingState();
        NoneEncoder encoder = state.encoder;
        int size = encoder.write(cell);
        state.postCellEncode(size, size);
    }

    @Override
    public boolean useEncodedScanner() {
        return false;
    }

    @Override
    public void saveMetadata(HFile.Writer writer) {
    }

    @Override
    public DataBlockEncoding getDataBlockEncoding() {
        return DataBlockEncoding.NONE;
    }

    @Override
    public DataBlockEncoding getEffectiveEncodingInCache(boolean isCompaction) {
        return DataBlockEncoding.NONE;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public HFileBlockEncodingContext newDataBlockEncodingContext(Configuration conf, byte[] dummyHeader, HFileContext meta) {
        return new HFileBlockDefaultEncodingContext(conf, null, dummyHeader, meta);
    }

    @Override
    public HFileBlockDecodingContext newDataBlockDecodingContext(Configuration conf, HFileContext meta) {
        return new HFileBlockDefaultDecodingContext(conf, meta);
    }

    @Override
    public void startBlockEncoding(HFileBlockEncodingContext blkEncodingCtx, DataOutputStream out) throws IOException {
        if (blkEncodingCtx.getClass() != HFileBlockDefaultEncodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultEncodingContext.class.getName() + " as the encoding context.");
        }
        HFileBlockDefaultEncodingContext encodingCtx = (HFileBlockDefaultEncodingContext)blkEncodingCtx;
        encodingCtx.prepareEncoding(out);
        NoneEncoder encoder = new NoneEncoder(out, encodingCtx);
        NoneEncodingState state = new NoneEncodingState();
        state.encoder = encoder;
        blkEncodingCtx.setEncodingState((EncodingState)state);
    }

    @Override
    public void endBlockEncoding(HFileBlockEncodingContext encodingCtx, DataOutputStream out, byte[] uncompressedBytesWithHeader, BlockType blockType) throws IOException {
        encodingCtx.postEncoding(BlockType.DATA);
    }

    private static class NoneEncodingState
    extends EncodingState {
        NoneEncoder encoder = null;

        private NoneEncodingState() {
        }
    }
}

