/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import org.apache.hadoop.hbase.io.hfile.BlockCompressedSizePredicator;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class PreviousBlockCompressionRatePredicator
implements BlockCompressedSizePredicator {
    private int adjustedBlockSize;
    private int compressionRatio = 1;
    private int configuredMaxBlockSize;

    @Override
    public void updateLatestBlockSizes(HFileContext context, int uncompressed, int compressed) {
        this.configuredMaxBlockSize = context.getBlocksize();
        this.compressionRatio = uncompressed / compressed;
        this.adjustedBlockSize = context.getBlocksize() * this.compressionRatio;
    }

    @Override
    public boolean shouldFinishBlock(int uncompressed) {
        if (uncompressed >= this.configuredMaxBlockSize) {
            return uncompressed >= this.adjustedBlockSize;
        }
        return false;
    }
}

