/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure.flush;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.procedure.MasterProcedureManager;
import org.apache.hadoop.hbase.procedure.Procedure;
import org.apache.hadoop.hbase.procedure.ProcedureCoordinator;
import org.apache.hadoop.hbase.procedure.ZKProcedureCoordinator;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.access.AccessChecker;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class MasterFlushTableProcedureManager
extends MasterProcedureManager {
    public static final String FLUSH_TABLE_PROCEDURE_SIGNATURE = "flush-table-proc";
    public static final String FLUSH_PROCEDURE_ENABLED = "hbase.flush.procedure.enabled";
    public static final boolean FLUSH_PROCEDURE_ENABLED_DEFAULT = true;
    private static final String FLUSH_TIMEOUT_MILLIS_KEY = "hbase.flush.master.timeoutMillis";
    private static final int FLUSH_TIMEOUT_MILLIS_DEFAULT = 60000;
    private static final String FLUSH_WAKE_MILLIS_KEY = "hbase.flush.master.wakeMillis";
    private static final int FLUSH_WAKE_MILLIS_DEFAULT = 500;
    private static final String FLUSH_PROC_POOL_THREADS_KEY = "hbase.flush.procedure.master.threads";
    private static final int FLUSH_PROC_POOL_THREADS_DEFAULT = 1;
    private static final Logger LOG = LoggerFactory.getLogger(MasterFlushTableProcedureManager.class);
    private MasterServices master;
    private ProcedureCoordinator coordinator;
    private Map<TableName, Procedure> procMap = new HashMap<TableName, Procedure>();
    private boolean stopped;

    public void stop(String why) {
        LOG.info("stop: " + why);
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void initialize(MasterServices master, MetricsMaster metricsMaster) throws KeeperException, IOException, UnsupportedOperationException {
        this.master = master;
        Configuration conf = master.getConfiguration();
        long wakeFrequency = conf.getInt(FLUSH_WAKE_MILLIS_KEY, 500);
        long timeoutMillis = conf.getLong(FLUSH_TIMEOUT_MILLIS_KEY, 60000L);
        int threads = conf.getInt(FLUSH_PROC_POOL_THREADS_KEY, 1);
        String name = master.getServerName().toString();
        ThreadPoolExecutor tpool = ProcedureCoordinator.defaultPool(name, threads);
        ZKProcedureCoordinator comms = new ZKProcedureCoordinator(master.getZooKeeper(), this.getProcedureSignature(), name);
        this.coordinator = new ProcedureCoordinator(comms, tpool, timeoutMillis, wakeFrequency);
    }

    @Override
    public String getProcedureSignature() {
        return FLUSH_TABLE_PROCEDURE_SIGNATURE;
    }

    @Override
    public void execProcedure(HBaseProtos.ProcedureDescription desc) throws IOException {
        byte[] procArgs;
        TableName tableName = TableName.valueOf((String)desc.getInstance());
        MasterCoprocessorHost cpHost = this.master.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preTableFlush(tableName);
        }
        List<Pair<RegionInfo, ServerName>> regionsAndLocations = this.master.getAssignmentManager().getTableRegionsAndLocations(tableName, false);
        HashSet<String> regionServers = new HashSet<String>(regionsAndLocations.size());
        for (Pair<RegionInfo, ServerName> region : regionsAndLocations) {
            RegionInfo hri;
            if (region == null || region.getFirst() == null || region.getSecond() == null || (hri = (RegionInfo)region.getFirst()).isOffline() && (hri.isSplit() || hri.isSplitParent())) continue;
            regionServers.add(((ServerName)region.getSecond()).toString());
        }
        ForeignExceptionDispatcher monitor = new ForeignExceptionDispatcher(desc.getInstance());
        HBaseProtos.NameStringPair families = null;
        for (HBaseProtos.NameStringPair nsp : desc.getConfigurationList()) {
            if (!"family".equals(nsp.getName())) continue;
            families = nsp;
        }
        if (families != null) {
            TableDescriptor tableDescriptor = this.master.getTableDescriptors().get(tableName);
            List noSuchFamilies = StreamSupport.stream(Strings.SPLITTER.split((CharSequence)families.getValue()).spliterator(), false).filter(cf -> !tableDescriptor.hasColumnFamily(Bytes.toBytes((String)cf))).collect(Collectors.toList());
            if (!noSuchFamilies.isEmpty()) {
                throw new NoSuchColumnFamilyException("Column families " + noSuchFamilies + " don't exist in table " + tableName.getNameAsString());
            }
            procArgs = families.toByteArray();
        } else {
            procArgs = new byte[]{};
        }
        Procedure proc = this.coordinator.startProcedure(monitor, desc.getInstance(), procArgs, Lists.newArrayList(regionServers));
        monitor.rethrowException();
        if (proc == null) {
            String msg = "Failed to submit distributed procedure " + desc.getSignature() + " for '" + desc.getInstance() + "'. Another flush procedure is running?";
            LOG.error(msg);
            throw new IOException(msg);
        }
        this.procMap.put(tableName, proc);
        try {
            proc.waitForCompleted();
            LOG.info("Done waiting - exec procedure " + desc.getSignature() + " for '" + desc.getInstance() + "'");
            LOG.info("Master flush table procedure is successful!");
        }
        catch (InterruptedException e) {
            ForeignException ee = new ForeignException("Interrupted while waiting for flush table procdure to finish", e);
            monitor.receive(ee);
            Thread.currentThread().interrupt();
        }
        catch (ForeignException e) {
            ForeignException ee = new ForeignException("Exception while waiting for flush table procdure to finish", e);
            monitor.receive(ee);
        }
        monitor.rethrowException();
    }

    @Override
    public void checkPermissions(HBaseProtos.ProcedureDescription desc, AccessChecker accessChecker, User user) throws IOException {
    }

    @Override
    public synchronized boolean isProcedureDone(HBaseProtos.ProcedureDescription desc) throws IOException {
        TableName tableName = TableName.valueOf((String)desc.getInstance());
        Procedure proc = this.procMap.get(tableName);
        if (proc == null) {
            return false;
        }
        return proc.isCompleted();
    }
}

