/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hbase.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class BootstrapNodeManager {
    private static final Logger LOG = LoggerFactory.getLogger(BootstrapNodeManager.class);
    public static final String REQUEST_MASTER_INTERVAL_SECS = "hbase.server.bootstrap.request_master_interval.secs";
    public static final long DEFAULT_REQUEST_MASTER_INTERVAL_SECS = TimeUnit.MINUTES.toSeconds(10L);
    public static final String REQUEST_MASTER_MIN_INTERVAL_SECS = "hbase.server.bootstrap.request_master_min_interval.secs";
    public static final long DEFAULT_REQUEST_MASTER_MIN_INTERVAL_SECS = 30L;
    public static final String REQUEST_REGIONSERVER_INTERVAL_SECS = "hbase.server.bootstrap.request_regionserver_interval.secs";
    public static final long DEFAULT_REQUEST_REGIONSERVER_INTERVAL_SECS = 30L;
    private static final float JITTER = 0.2f;
    private volatile List<ServerName> nodes = Collections.emptyList();
    private final ClusterConnection conn;
    private final MasterAddressTracker masterAddrTracker;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.getClass().getSimpleName()).build());
    private final long requestMasterIntervalSecs;
    private final long requestMasterMinIntervalSecs;
    private final long requestRegionServerIntervalSecs;
    private final int maxNodeCount;
    private final RetryCounterFactory retryCounterFactory;
    private RetryCounter retryCounter;
    private long lastRequestMasterTime;

    public BootstrapNodeManager(ClusterConnection conn, MasterAddressTracker masterAddrTracker) {
        this.conn = conn;
        this.masterAddrTracker = masterAddrTracker;
        Configuration conf = conn.getConfiguration();
        this.requestMasterIntervalSecs = conf.getLong(REQUEST_MASTER_INTERVAL_SECS, DEFAULT_REQUEST_MASTER_INTERVAL_SECS);
        this.requestMasterMinIntervalSecs = conf.getLong(REQUEST_MASTER_MIN_INTERVAL_SECS, 30L);
        this.requestRegionServerIntervalSecs = conf.getLong(REQUEST_REGIONSERVER_INTERVAL_SECS, 30L);
        this.maxNodeCount = conf.getInt("hbase.client.bootstrap.node.limit", 10);
        this.retryCounterFactory = new RetryCounterFactory(new RetryCounter.RetryConfig().setBackoffPolicy((RetryCounter.BackoffPolicy)new RetryCounter.ExponentialBackoffPolicyWithLimit()).setJitter(0.2f).setSleepInterval(this.requestMasterMinIntervalSecs).setMaxSleepTime(this.requestMasterIntervalSecs).setTimeUnit(TimeUnit.SECONDS));
        this.executor.schedule(this::getFromMaster, this.getDelay(this.requestMasterMinIntervalSecs), TimeUnit.SECONDS);
    }

    private long getDelay(long delay) {
        long jitterDelay = (long)((float)delay * ThreadLocalRandom.current().nextFloat() * 0.2f);
        return delay + jitterDelay;
    }

    private void getFromMaster() {
        List liveRegionServers;
        try {
            liveRegionServers = this.conn.getLiveRegionServers(() -> this.masterAddrTracker.getMasterAddress(), this.maxNodeCount * 2);
        }
        catch (IOException e) {
            LOG.warn("failed to get live region servers from master", (Throwable)e);
            if (this.retryCounter == null) {
                this.retryCounter = this.retryCounterFactory.create();
            }
            this.executor.schedule(this::getFromMaster, this.retryCounter.getBackoffTimeAndIncrementAttempts(), TimeUnit.SECONDS);
            return;
        }
        this.retryCounter = null;
        this.lastRequestMasterTime = EnvironmentEdgeManager.currentTime();
        this.nodes = Collections.unmodifiableList(liveRegionServers);
        if (liveRegionServers.size() < this.maxNodeCount) {
            this.executor.schedule(this::getFromMaster, this.getDelay(this.requestMasterMinIntervalSecs), TimeUnit.SECONDS);
            return;
        }
        this.executor.schedule(this::getFromRegionServer, this.getDelay(this.requestRegionServerIntervalSecs), TimeUnit.SECONDS);
    }

    private void getFromRegionServer() {
        List otherList;
        if (EnvironmentEdgeManager.currentTime() - this.lastRequestMasterTime >= TimeUnit.SECONDS.toMillis(this.requestMasterIntervalSecs)) {
            this.executor.execute(this::getFromMaster);
            return;
        }
        List<ServerName> currentList = this.nodes;
        ServerName peer = currentList.get(ThreadLocalRandom.current().nextInt(currentList.size()));
        try {
            otherList = this.conn.getAllBootstrapNodes(peer);
        }
        catch (IOException e) {
            List newList;
            LOG.warn("failed to request region server {}", (Object)peer, (Object)e);
            this.nodes = newList = currentList.stream().filter(sn -> sn != peer).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
            if (newList.size() < this.maxNodeCount) {
                this.executor.execute(this::getFromMaster);
            } else {
                this.executor.schedule(this::getFromRegionServer, this.getDelay(this.requestRegionServerIntervalSecs), TimeUnit.SECONDS);
            }
            return;
        }
        HashSet<ServerName> newRegionServers = new HashSet<ServerName>(currentList);
        newRegionServers.addAll(otherList);
        ArrayList<ServerName> newList = new ArrayList<ServerName>(newRegionServers);
        Collections.shuffle(newList, ThreadLocalRandom.current());
        int expectedListSize = this.maxNodeCount * 2;
        this.nodes = newList.size() <= expectedListSize ? Collections.unmodifiableList(newList) : Collections.unmodifiableList(new ArrayList(newList.subList(0, expectedListSize)));
        this.executor.schedule(this::getFromRegionServer, this.requestRegionServerIntervalSecs, TimeUnit.SECONDS);
    }

    public void stop() {
        this.executor.shutdownNow();
    }

    public List<ServerName> getBootstrapNodes() {
        return this.nodes;
    }
}

