/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.namequeues.NamedQueueRecorder;
import org.apache.hadoop.hbase.namequeues.WALEventTrackerPayload;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class WALEventTrackerListener
implements WALActionsListener {
    private final Configuration conf;
    private final NamedQueueRecorder namedQueueRecorder;
    private final String serverName;

    public WALEventTrackerListener(Configuration conf, NamedQueueRecorder namedQueueRecorder, ServerName serverName) {
        this.conf = conf;
        this.namedQueueRecorder = namedQueueRecorder;
        this.serverName = serverName.getHostname();
    }

    @Override
    public void preLogRoll(Path oldPath, Path newPath) {
        if (oldPath != null) {
            WALEventTrackerPayload payloadForOldPath = this.getPayload(oldPath.getName(), WalState.ROLLING.name(), 0L);
            this.namedQueueRecorder.addRecord(payloadForOldPath);
        }
    }

    @Override
    public void postLogRoll(Path oldPath, Path newPath) {
        if (oldPath != null) {
            long fileLength = 0L;
            try {
                FileSystem fs = oldPath.getFileSystem(this.conf);
                fileLength = fs.getFileStatus(oldPath).getLen();
            }
            catch (IOException fs) {
                // empty catch block
            }
            WALEventTrackerPayload payloadForOldPath = this.getPayload(oldPath.getName(), WalState.ROLLED.name(), fileLength);
            this.namedQueueRecorder.addRecord(payloadForOldPath);
        }
        WALEventTrackerPayload payloadForNewPath = this.getPayload(newPath.getName(), WalState.ACTIVE.name(), 0L);
        this.namedQueueRecorder.addRecord(payloadForNewPath);
    }

    private WALEventTrackerPayload getPayload(String path, String state, long walLength) {
        long timestamp = EnvironmentEdgeManager.currentTime();
        WALEventTrackerPayload payload = new WALEventTrackerPayload(this.serverName, path, timestamp, state, walLength);
        return payload;
    }

    public static enum WalState {
        ROLLING,
        ROLLED,
        ACTIVE;

    }
}

