/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.text.MessageFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class Waiter {
    private static final Logger LOG = LoggerFactory.getLogger(Waiter.class);
    public static final String HBASE_TEST_WAIT_FOR_RATIO = "hbase.test.wait.for.ratio";
    private static float HBASE_WAIT_FOR_RATIO_DEFAULT = 1.0f;
    private static float waitForRatio = -1.0f;

    private Waiter() {
    }

    public static float getWaitForRatio(Configuration conf) {
        if (waitForRatio < 0.0f) {
            waitForRatio = System.getProperty(HBASE_TEST_WAIT_FOR_RATIO) != null ? Float.parseFloat(System.getProperty(HBASE_TEST_WAIT_FOR_RATIO)) : conf.getFloat(HBASE_TEST_WAIT_FOR_RATIO, HBASE_WAIT_FOR_RATIO_DEFAULT);
        }
        return waitForRatio;
    }

    public static void sleep(Configuration conf, long time) {
        try {
            Thread.sleep((long)(Waiter.getWaitForRatio(conf) * (float)time));
        }
        catch (InterruptedException ex) {
            LOG.warn(MessageFormat.format("Sleep interrupted, {0}", ex.toString()));
        }
    }

    public static <E extends Exception> long waitFor(Configuration conf, long timeout, Predicate<E> predicate) {
        return Waiter.waitFor(conf, timeout, 100L, true, predicate);
    }

    public static <E extends Exception> long waitFor(Configuration conf, long timeout, long interval, Predicate<E> predicate) {
        return Waiter.waitFor(conf, timeout, interval, true, predicate);
    }

    public static <E extends Exception> long waitFor(Configuration conf, long timeout, long interval, boolean failIfTimeout, Predicate<E> predicate) {
        long started = EnvironmentEdgeManager.currentTime();
        long adjustedTimeout = (long)(Waiter.getWaitForRatio(conf) * (float)timeout);
        long mustEnd = started + adjustedTimeout;
        boolean interrupted = false;
        try {
            long remainderWait;
            boolean eval;
            LOG.info(MessageFormat.format("Waiting up to [{0}] milli-secs(wait.for.ratio=[{1}])", adjustedTimeout, Float.valueOf(Waiter.getWaitForRatio(conf))));
            while (!(eval = predicate.evaluate()) && (remainderWait = mustEnd - EnvironmentEdgeManager.currentTime()) > 0L) {
                try {
                    long sleepInterval = Math.min(remainderWait, interval);
                    Thread.sleep(sleepInterval);
                }
                catch (InterruptedException e) {
                    eval = predicate.evaluate();
                    interrupted = true;
                    break;
                }
            }
            if (!eval) {
                if (interrupted) {
                    LOG.warn(MessageFormat.format("Waiting interrupted after [{0}] msec", EnvironmentEdgeManager.currentTime() - started));
                } else if (failIfTimeout) {
                    String msg = Waiter.getExplanation(predicate);
                    Assert.fail((String)(MessageFormat.format("Waiting timed out after [{0}] msec", adjustedTimeout) + msg));
                } else {
                    String msg = Waiter.getExplanation(predicate);
                    LOG.warn(MessageFormat.format("Waiting timed out after [{0}] msec", adjustedTimeout) + msg);
                }
            }
            return eval || interrupted ? EnvironmentEdgeManager.currentTime() - started : -1L;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getExplanation(Predicate<?> explain) {
        if (explain instanceof ExplainingPredicate) {
            try {
                return " " + ((ExplainingPredicate)explain).explainFailure();
            }
            catch (Exception e) {
                LOG.error("Failed to get explanation, ", (Throwable)e);
                return e.getMessage();
            }
        }
        return "";
    }

    @InterfaceAudience.Private
    public static interface ExplainingPredicate<E extends Exception>
    extends Predicate<E> {
        public String explainFailure() throws E;
    }

    @InterfaceAudience.Private
    public static interface Predicate<E extends Exception> {
        public boolean evaluate() throws E;
    }
}

