/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.UUID;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.ElementHolder;
import org.apache.directory.mavibot.btree.exception.BTreeAlreadyManagedException;

public class DuplicateKeyMemoryHolder<K, V>
implements ElementHolder<V, K, V> {
    private BTree<K, V> btree;
    private long valContainerOffset = -1L;
    private BTree<V, V> valueContainer;
    private SoftReference<BTree<V, V>> reference;

    public DuplicateKeyMemoryHolder(BTree<K, V> btree, V value) {
        this.btree = btree;
        try {
            BTree<V, V> valueContainer = new BTree<V, V>(UUID.randomUUID().toString(), btree.getValueSerializer(), btree.getValueSerializer());
            if (btree.isManaged()) {
                try {
                    btree.getRecordManager().manage(valueContainer, true);
                    this.valContainerOffset = valueContainer.getBtreeOffset();
                }
                catch (BTreeAlreadyManagedException e) {
                    throw new RuntimeException(e);
                }
                this.reference = new SoftReference<BTree<V, V>>(valueContainer);
            } else {
                this.valueContainer = valueContainer;
            }
            valueContainer.insert(value, null, 0L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    DuplicateKeyMemoryHolder(BTree<K, V> btree, BTree<V, V> valueContainer) {
        this.btree = btree;
        if (btree.isManaged()) {
            this.valContainerOffset = valueContainer.getBtreeOffset();
            this.reference = new SoftReference<BTree<V, V>>(valueContainer);
        } else {
            this.valueContainer = valueContainer;
        }
    }

    @Override
    public V getValue(BTree<K, V> btree) {
        if (!btree.isManaged()) {
            return (V)this.valueContainer;
        }
        BTree valueContainer = this.reference.get();
        if (valueContainer == null) {
            valueContainer = btree.getRecordManager().loadDupsBTree(this.valContainerOffset);
            this.reference = new SoftReference<BTree>(valueContainer);
        }
        return (V)valueContainer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        V value = this.getValue(this.btree);
        sb.append(value);
        sb.append("'");
        return sb.toString();
    }
}

