/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree.serializer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.directory.mavibot.btree.comparator.LongArrayComparator;
import org.apache.directory.mavibot.btree.serializer.BufferHandler;
import org.apache.directory.mavibot.btree.serializer.ElementSerializer;
import org.apache.directory.mavibot.btree.serializer.IntSerializer;

public class LongArraySerializer
implements ElementSerializer<long[]> {
    private final Comparator<long[]> comparator = new LongArrayComparator();

    @Override
    public byte[] serialize(long[] element) {
        int len = -1;
        if (element != null) {
            len = element.length;
        }
        byte[] bytes = null;
        switch (len) {
            case 0: {
                bytes = new byte[]{0, 0, 0, 0};
                break;
            }
            case -1: {
                bytes = new byte[]{-1, -1, -1, -1};
                break;
            }
            default: {
                bytes = new byte[len * 8 + 4];
                int pos = 0;
                bytes[pos++] = (byte)(len >>> 24);
                bytes[pos++] = (byte)(len >>> 16);
                bytes[pos++] = (byte)(len >>> 8);
                bytes[pos++] = (byte)len;
                for (long value : element) {
                    bytes[pos++] = (byte)(value >>> 56);
                    bytes[pos++] = (byte)(value >>> 48);
                    bytes[pos++] = (byte)(value >>> 40);
                    bytes[pos++] = (byte)(value >>> 32);
                    bytes[pos++] = (byte)(value >>> 24);
                    bytes[pos++] = (byte)(value >>> 16);
                    bytes[pos++] = (byte)(value >>> 8);
                    bytes[pos++] = (byte)value;
                }
            }
        }
        return bytes;
    }

    @Override
    public long[] deserialize(BufferHandler bufferHandler) throws IOException {
        byte[] in = bufferHandler.read(4);
        int len = IntSerializer.deserialize(in);
        switch (len) {
            case 0: {
                return new long[0];
            }
            case -1: {
                return null;
            }
        }
        long[] longs = new long[len];
        int pos = 4;
        for (int i = 0; i < len; ++i) {
            longs[i] = ((long)in[pos++] << 56) + (((long)in[pos++] & 0xFFL) << 48) + (((long)in[pos++] & 0xFFL) << 40) + (((long)in[pos++] & 0xFFL) << 32) + (((long)in[pos++] & 0xFFL) << 24) + (((long)in[pos++] & 0xFFL) << 16) + (((long)in[pos++] & 0xFFL) << 8) + ((long)in[pos++] & 0xFFL);
        }
        return longs;
    }

    @Override
    public long[] deserialize(ByteBuffer buffer) throws IOException {
        int len = buffer.getInt();
        switch (len) {
            case 0: {
                return new long[0];
            }
            case -1: {
                return null;
            }
        }
        long[] longs = new long[len];
        for (int i = 0; i < len; ++i) {
            longs[i] = buffer.getLong();
        }
        return longs;
    }

    @Override
    public int compare(long[] type1, long[] type2) {
        if (type1 == type2) {
            return 0;
        }
        if (type1 == null) {
            if (type2 == null) {
                return 0;
            }
            return -1;
        }
        if (type2 == null) {
            return 1;
        }
        if (type1.length < type2.length) {
            int pos = 0;
            for (long b1 : type1) {
                long b2 = type2[pos];
                if (b1 == b2) {
                    ++pos;
                    continue;
                }
                if (b1 < b2) {
                    return -1;
                }
                return 1;
            }
            return 1;
        }
        int pos = 0;
        long[] arr$ = type2;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long b1 = type1[pos];
            long b2 = arr$[i$];
            if (b1 == b2) {
                ++pos;
                continue;
            }
            if (b1 < b2) {
                return -1;
            }
            return 1;
        }
        return -11;
    }

    @Override
    public Comparator<long[]> getComparator() {
        return this.comparator;
    }
}

