/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.procedure.MasterFailoverWithProceduresTestBase;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureTestingUtility;
import org.apache.hadoop.hbase.master.procedure.TruncateTableProcedure;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestTruncateTableWithMasterFailover
extends MasterFailoverWithProceduresTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTruncateTableWithMasterFailover.class);

    @Test
    public void testTruncateWithFailover() throws Exception {
        this.testTruncateWithFailoverAtStep(true, MasterProcedureProtos.TruncateTableState.TRUNCATE_TABLE_ADD_TO_META.ordinal());
    }

    private void testTruncateWithFailoverAtStep(boolean preserveSplits, int step) throws Exception {
        TableName tableName = TableName.valueOf((String)("testTruncateWithFailoverAtStep" + step));
        String[] families = new String[]{"f1", "f2"};
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c")};
        RegionInfo[] regions = MasterProcedureTestingUtility.createTable(TestTruncateTableWithMasterFailover.getMasterProcedureExecutor(), tableName, splitKeys, families);
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 100, splitKeys, families);
        Assert.assertEquals((long)100L, (long)UTIL.countRows(tableName));
        UTIL.getAdmin().disableTable(tableName);
        ProcedureExecutor<MasterProcedureEnv> procExec = TestTruncateTableWithMasterFailover.getMasterProcedureExecutor();
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = procExec.submitProcedure((Procedure)new TruncateTableProcedure((MasterProcedureEnv)procExec.getEnvironment(), tableName, preserveSplits));
        TestTruncateTableWithMasterFailover.testRecoveryAndDoubleExecution(UTIL, procId, step);
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        UTIL.waitUntilAllRegionsAssigned(tableName);
        regions = UTIL.getAdmin().getRegions(tableName).toArray(new RegionInfo[0]);
        if (preserveSplits) {
            Assert.assertEquals((long)(1 + splitKeys.length), (long)regions.length);
        } else {
            Assert.assertEquals((long)1L, (long)regions.length);
        }
        MasterProcedureTestingUtility.validateTableCreation(UTIL.getHBaseCluster().getMaster(), tableName, regions, families);
        Assert.assertEquals((long)0L, (long)UTIL.countRows(tableName));
        MasterProcedureTestingUtility.loadData(UTIL.getConnection(), tableName, 50, splitKeys, families);
        Assert.assertEquals((long)50L, (long)UTIL.countRows(tableName));
    }
}

