/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hbase.thirdparty.com.google.common.base.MoreObjects;
import org.mockito.Mockito;

class MockStoreFileGenerator {
    private static final int FILENAME_LENGTH = 10;

    MockStoreFileGenerator() {
    }

    protected List<HStoreFile> createStoreFileList(int[] fs) {
        LinkedList<HStoreFile> storeFiles = new LinkedList<HStoreFile>();
        for (int fileSize : fs) {
            storeFiles.add(this.createMockStoreFile(fileSize));
        }
        return storeFiles;
    }

    protected HStoreFile createMockStoreFile(long size) {
        return this.createMockStoreFile(size * 1024L * 1024L, -1L);
    }

    protected HStoreFile createMockStoreFileBytes(long size) {
        return this.createMockStoreFile(size, -1L);
    }

    protected HStoreFile createMockStoreFile(long sizeInBytes, long seqId) {
        HStoreFile mockSf = (HStoreFile)Mockito.mock(HStoreFile.class);
        StoreFileReader reader = (StoreFileReader)Mockito.mock(StoreFileReader.class);
        String stringPath = "/hbase/testTable/regionA/" + RandomStringUtils.random((int)10, (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)ThreadLocalRandom.current());
        Path path = new Path(stringPath);
        Mockito.when((Object)reader.getSequenceID()).thenReturn((Object)seqId);
        Mockito.when((Object)reader.getTotalUncompressedBytes()).thenReturn((Object)sizeInBytes);
        Mockito.when((Object)reader.length()).thenReturn((Object)sizeInBytes);
        Mockito.when((Object)mockSf.getPath()).thenReturn((Object)path);
        Mockito.when((Object)mockSf.excludeFromMinorCompaction()).thenReturn((Object)false);
        Mockito.when((Object)mockSf.isReference()).thenReturn((Object)false);
        Mockito.when((Object)mockSf.getReader()).thenReturn((Object)reader);
        String toString = MoreObjects.toStringHelper((String)"MockStoreFile").add("isReference", false).add("fileSize", (Object)Strings.humanReadableInt((long)sizeInBytes)).add("seqId", seqId).add("path", (Object)stringPath).toString();
        Mockito.when((Object)mockSf.toString()).thenReturn((Object)toString);
        return mockSf;
    }
}

