/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.server.timelineservice.collector.AppLevelTimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollector;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AppLevelTimelineCollectorWithAgg
extends AppLevelTimelineCollector {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineCollector.class);
    private static final int AGGREGATION_EXECUTOR_NUM_THREADS = 1;
    private static final int AGGREGATION_EXECUTOR_EXEC_INTERVAL_SECS = 15;
    private static Set<String> entityTypesSkipAggregation = AppLevelTimelineCollectorWithAgg.initializeSkipSet();
    private ScheduledThreadPoolExecutor appAggregationExecutor;
    private AppLevelAggregator appAggregator;

    public AppLevelTimelineCollectorWithAgg(ApplicationId appId, String user) {
        super(appId, user);
    }

    private static Set<String> initializeSkipSet() {
        HashSet<String> result = new HashSet<String>();
        result.add(TimelineEntityType.YARN_APPLICATION.toString());
        result.add(TimelineEntityType.YARN_FLOW_RUN.toString());
        result.add(TimelineEntityType.YARN_FLOW_ACTIVITY.toString());
        return result;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        this.appAggregationExecutor = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setNameFormat("TimelineCollector Aggregation thread #%d").build());
        this.appAggregator = new AppLevelAggregator();
        this.appAggregationExecutor.scheduleAtFixedRate(this.appAggregator, 15L, 15L, TimeUnit.SECONDS);
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        this.appAggregationExecutor.shutdown();
        if (!this.appAggregationExecutor.awaitTermination(10L, TimeUnit.SECONDS)) {
            LOG.info("App-level aggregator shutdown timed out, shutdown now. ");
            this.appAggregationExecutor.shutdownNow();
        }
        this.appAggregator.aggregate();
        super.serviceStop();
    }

    @Override
    protected Set<String> getEntityTypesSkipAggregation() {
        return entityTypesSkipAggregation;
    }

    private class AppLevelAggregator
    implements Runnable {
        private AppLevelAggregator() {
        }

        private void aggregate() {
            LOG.debug("App-level real-time aggregating");
            if (!AppLevelTimelineCollectorWithAgg.this.isReadyToAggregate()) {
                LOG.warn("App-level collector is not ready, skip aggregation. ");
                return;
            }
            try {
                TimelineCollectorContext currContext = AppLevelTimelineCollectorWithAgg.this.getTimelineEntityContext();
                Map<String, TimelineCollector.AggregationStatusTable> aggregationGroups = AppLevelTimelineCollectorWithAgg.this.getAggregationGroups();
                if (aggregationGroups == null || aggregationGroups.isEmpty()) {
                    LOG.debug("App-level collector is empty, skip aggregation. ");
                    return;
                }
                TimelineEntity resultEntity = TimelineCollector.aggregateWithoutGroupId(aggregationGroups, currContext.getAppId(), TimelineEntityType.YARN_APPLICATION.toString());
                TimelineEntities entities = new TimelineEntities();
                entities.addEntity(resultEntity);
                AppLevelTimelineCollectorWithAgg.this.putEntitiesAsync(entities, AppLevelTimelineCollectorWithAgg.this.getCurrentUser());
            }
            catch (Exception e) {
                LOG.error("Error aggregating timeline metrics", (Throwable)e);
            }
            LOG.debug("App-level real-time aggregation complete");
        }

        @Override
        public void run() {
            this.aggregate();
        }
    }
}

