/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.AbstractPreemptionEntity;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempAppPerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.monitor.capacity.TempUserPerPartition;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

public class TempQueuePerPartition
extends AbstractPreemptionEntity {
    final String partition;
    private final Resource killable;
    private final float absCapacity;
    private final float absMaxCapacity;
    final Resource totalPartitionResource;
    Resource untouchableExtra;
    Resource preemptableExtra;
    double[] normalizedGuarantee;
    final ArrayList<TempQueuePerPartition> children;
    private Collection<TempAppPerPartition> apps;
    LeafQueue leafQueue;
    boolean preemptionDisabled;
    protected Resource pendingDeductReserved;
    int relativePriority = 0;
    TempQueuePerPartition parent = null;
    Map<String, TempUserPerPartition> usersPerPartition = new LinkedHashMap<String, TempUserPerPartition>();

    TempQueuePerPartition(String queueName, Resource current, boolean preemptionDisabled, String partition, Resource killable, float absCapacity, float absMaxCapacity, Resource totalPartitionResource, Resource reserved, CSQueue queue) {
        super(queueName, current, Resource.newInstance((int)0, (int)0), reserved, Resource.newInstance((int)0, (int)0));
        if (queue instanceof LeafQueue) {
            LeafQueue l = (LeafQueue)queue;
            this.pending = l.getTotalPendingResourcesConsideringUserLimit(totalPartitionResource, partition, false);
            this.pendingDeductReserved = l.getTotalPendingResourcesConsideringUserLimit(totalPartitionResource, partition, true);
            this.leafQueue = l;
        } else {
            this.pending = Resources.createResource((int)0);
            this.pendingDeductReserved = Resources.createResource((int)0);
        }
        this.normalizedGuarantee = new double[ResourceUtils.getNumberOfKnownResourceTypes()];
        this.children = new ArrayList();
        this.apps = new ArrayList<TempAppPerPartition>();
        this.untouchableExtra = Resource.newInstance((int)0, (int)0);
        this.preemptableExtra = Resource.newInstance((int)0, (int)0);
        this.preemptionDisabled = preemptionDisabled;
        this.partition = partition;
        this.killable = killable;
        this.absCapacity = absCapacity;
        this.absMaxCapacity = absMaxCapacity;
        this.totalPartitionResource = totalPartitionResource;
    }

    public void setLeafQueue(LeafQueue l) {
        assert (this.children.size() == 0);
        this.leafQueue = l;
    }

    public void addChild(TempQueuePerPartition q) {
        assert (this.leafQueue == null);
        this.children.add(q);
        Resources.addTo((Resource)this.pending, (Resource)q.pending);
        Resources.addTo((Resource)this.pendingDeductReserved, (Resource)q.pendingDeductReserved);
    }

    public ArrayList<TempQueuePerPartition> getChildren() {
        return this.children;
    }

    Resource offer(Resource avail, ResourceCalculator rc, Resource clusterResource, boolean considersReservedResource) {
        Resource absMaxCapIdealAssignedDelta = Resources.componentwiseMax((Resource)Resources.subtract((Resource)this.getMax(), (Resource)this.idealAssigned), (Resource)Resource.newInstance((int)0, (int)0));
        Resource accepted = Resources.componentwiseMin((Resource)absMaxCapIdealAssignedDelta, (Resource)Resources.min((ResourceCalculator)rc, (Resource)clusterResource, (Resource)avail, (Resource)Resources.subtract((Resource)Resources.add((Resource)this.getUsed(), (Resource)(considersReservedResource ? this.pending : this.pendingDeductReserved)), (Resource)this.idealAssigned)));
        if (null == this.children || this.children.isEmpty()) {
            Resource maxOfGuranteedAndUsedDeductAssigned = Resources.subtract((Resource)Resources.max((ResourceCalculator)rc, (Resource)clusterResource, (Resource)this.getUsed(), (Resource)this.getGuaranteed()), (Resource)this.idealAssigned);
            maxOfGuranteedAndUsedDeductAssigned = Resources.max((ResourceCalculator)rc, (Resource)clusterResource, (Resource)maxOfGuranteedAndUsedDeductAssigned, (Resource)Resources.none());
            accepted = Resources.min((ResourceCalculator)rc, (Resource)clusterResource, (Resource)accepted, (Resource)maxOfGuranteedAndUsedDeductAssigned);
        }
        accepted = Resources.componentwiseMax((Resource)accepted, (Resource)Resources.none());
        accepted = Resources.componentwiseMin((Resource)accepted, (Resource)avail);
        Resource remain = Resources.subtract((Resource)avail, (Resource)accepted);
        Resources.addTo((Resource)this.idealAssigned, (Resource)accepted);
        return remain;
    }

    public Resource getGuaranteed() {
        return Resources.multiply((Resource)this.totalPartitionResource, (double)this.absCapacity);
    }

    public Resource getMax() {
        return Resources.multiply((Resource)this.totalPartitionResource, (double)this.absMaxCapacity);
    }

    public void updatePreemptableExtras(ResourceCalculator rc) {
        this.untouchableExtra = Resources.none();
        this.preemptableExtra = Resources.none();
        Resource extra = Resources.subtract((Resource)this.getUsed(), (Resource)this.getGuaranteed());
        if (Resources.lessThan((ResourceCalculator)rc, (Resource)this.totalPartitionResource, (Resource)extra, (Resource)Resources.none())) {
            extra = Resources.none();
        }
        if (null == this.children || this.children.isEmpty()) {
            if (this.preemptionDisabled) {
                this.untouchableExtra = extra;
            } else {
                this.preemptableExtra = extra;
            }
        } else {
            Resource childrensPreemptable = Resource.newInstance((int)0, (int)0);
            for (TempQueuePerPartition child : this.children) {
                Resources.addTo((Resource)childrensPreemptable, (Resource)child.preemptableExtra);
            }
            this.untouchableExtra = Resources.greaterThanOrEqual((ResourceCalculator)rc, (Resource)this.totalPartitionResource, (Resource)childrensPreemptable, (Resource)extra) ? Resource.newInstance((int)0, (int)0) : Resources.subtract((Resource)extra, (Resource)childrensPreemptable);
            this.preemptableExtra = Resources.min((ResourceCalculator)rc, (Resource)this.totalPartitionResource, (Resource)childrensPreemptable, (Resource)extra);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" NAME: " + this.queueName).append(" CUR: ").append(this.current).append(" PEN: ").append(this.pending).append(" RESERVED: ").append(this.reserved).append(" GAR: ").append(this.getGuaranteed()).append(" NORM: ").append(Arrays.toString(this.normalizedGuarantee)).append(" IDEAL_ASSIGNED: ").append(this.idealAssigned).append(" IDEAL_PREEMPT: ").append(this.toBePreempted).append(" ACTUAL_PREEMPT: ").append(this.getActuallyToBePreempted()).append(" UNTOUCHABLE: ").append(this.untouchableExtra).append(" PREEMPTABLE: ").append(this.preemptableExtra).append("\n");
        return sb.toString();
    }

    public void assignPreemption(float scalingFactor, ResourceCalculator rc, Resource clusterResource) {
        Resource totalResource;
        Resource minimumQueueResource;
        Resource usedDeductKillable = Resources.subtract((Resource)this.getUsed(), (Resource)this.killable);
        this.toBePreempted = Resources.greaterThan((ResourceCalculator)rc, (Resource)clusterResource, (Resource)usedDeductKillable, (Resource)(minimumQueueResource = Resources.max((ResourceCalculator)rc, (Resource)clusterResource, (Resource)Resources.min((ResourceCalculator)rc, (Resource)clusterResource, (Resource)(totalResource = Resources.add((Resource)this.getUsed(), (Resource)this.pending)), (Resource)this.getGuaranteed()), (Resource)this.idealAssigned))) ? Resources.multiply((Resource)Resources.subtract((Resource)usedDeductKillable, (Resource)minimumQueueResource), (double)scalingFactor) : Resources.none();
    }

    public void deductActuallyToBePreempted(ResourceCalculator rc, Resource cluster, Resource toBeDeduct) {
        if (Resources.greaterThan((ResourceCalculator)rc, (Resource)cluster, (Resource)this.getActuallyToBePreempted(), (Resource)toBeDeduct)) {
            Resources.subtractFrom((Resource)this.getActuallyToBePreempted(), (Resource)toBeDeduct);
        }
        this.setActuallyToBePreempted(Resources.max((ResourceCalculator)rc, (Resource)cluster, (Resource)this.getActuallyToBePreempted(), (Resource)Resources.none()));
    }

    void appendLogString(StringBuilder sb) {
        sb.append(this.queueName).append(", ").append(this.current.getMemorySize()).append(", ").append(this.current.getVirtualCores()).append(", ").append(this.pending.getMemorySize()).append(", ").append(this.pending.getVirtualCores()).append(", ").append(this.getGuaranteed().getMemorySize()).append(", ").append(this.getGuaranteed().getVirtualCores()).append(", ").append(this.idealAssigned.getMemorySize()).append(", ").append(this.idealAssigned.getVirtualCores()).append(", ").append(this.toBePreempted.getMemorySize()).append(", ").append(this.toBePreempted.getVirtualCores()).append(", ").append(this.getActuallyToBePreempted().getMemorySize()).append(", ").append(this.getActuallyToBePreempted().getVirtualCores());
    }

    public void addAllApps(Collection<TempAppPerPartition> orderedApps) {
        this.apps = orderedApps;
    }

    public Collection<TempAppPerPartition> getApps() {
        return this.apps;
    }

    public void addUserPerPartition(String userName, TempUserPerPartition tmpUser) {
        this.usersPerPartition.put(userName, tmpUser);
    }

    public Map<String, TempUserPerPartition> getUsersPerPartition() {
        return this.usersPerPartition;
    }
}

