/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerHealth;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CapacitySchedulerHealthInfo {
    long lastrun;
    Map<String, OperationInformation> operationsInfo;
    List<LastRunDetails> lastRunDetails;

    CapacitySchedulerHealthInfo() {
    }

    public long getLastrun() {
        return this.lastrun;
    }

    CapacitySchedulerHealthInfo(CapacityScheduler cs) {
        SchedulerHealth ht = cs.getSchedulerHealth();
        this.lastrun = ht.getLastSchedulerRunTime();
        this.operationsInfo = new HashMap<String, OperationInformation>();
        this.operationsInfo.put("last-allocation", new OperationInformation(ht.getLastAllocationDetails()));
        this.operationsInfo.put("last-release", new OperationInformation(ht.getLastReleaseDetails()));
        this.operationsInfo.put("last-preemption", new OperationInformation(ht.getLastPreemptionDetails()));
        this.operationsInfo.put("last-reservation", new OperationInformation(ht.getLastReservationDetails()));
        this.lastRunDetails = new ArrayList<LastRunDetails>();
        this.lastRunDetails.add(new LastRunDetails("releases", ht.getReleaseCount(), ht.getResourcesReleased()));
        this.lastRunDetails.add(new LastRunDetails("allocations", ht.getAllocationCount(), ht.getResourcesAllocated()));
        this.lastRunDetails.add(new LastRunDetails("reservations", ht.getReservationCount(), ht.getResourcesReserved()));
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class LastRunDetails {
        String operation;
        long count;
        ResourceInfo resources;

        LastRunDetails() {
        }

        LastRunDetails(String operation, long count, Resource resource) {
            this.operation = operation;
            this.count = count;
            this.resources = new ResourceInfo(resource);
        }

        public String getOperation() {
            return this.operation;
        }

        public long getCount() {
            return this.count;
        }

        public ResourceInfo getResources() {
            return this.resources;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class OperationInformation {
        String nodeId;
        String containerId;
        String queue;

        OperationInformation() {
        }

        OperationInformation(SchedulerHealth.DetailedInformation di) {
            this.nodeId = di.getNodeId() == null ? "N/A" : di.getNodeId().toString();
            this.containerId = di.getContainerId() == null ? "N/A" : di.getContainerId().toString();
            this.queue = di.getQueue() == null ? "N/A" : di.getQueue();
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public String getQueue() {
            return this.queue;
        }
    }
}

