/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.workflow;

import java.util.List;
import org.apache.hop.core.Const;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.HopGuiExtensionPoint;
import org.apache.hop.ui.hopgui.delegates.HopGuiFileOpenedExtension;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.hopgui.file.workflow.context.HopGuiWorkflowContext;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.workflow.ActionWorkflow;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;

@GuiPlugin
public class ActionWorkflowGuiPlugin {
    @GuiContextAction(id="workflow-graph-workflow-copy-action", parentId="HopGuiWorkflowContext", type=GuiActionType.Modify, name="Copy as workflow action", tooltip="Copy this workflow as an action so you can paste it in another workflow", image="ui/images/copy.svg", category="Basic", categoryOrder="1")
    public void copyAsActionToClipboard(HopGuiWorkflowContext context) {
        WorkflowMeta workflowMeta = context.getWorkflowMeta();
        HopGuiWorkflowGraph workflowGraph = context.getWorkflowGraph();
        HopGui hopGui = workflowGraph.getHopGui();
        IVariables variables = workflowGraph.getVariables();
        ActionWorkflow actionWorkflow = new ActionWorkflow(workflowMeta.getName());
        HopGuiFileOpenedExtension ext = new HopGuiFileOpenedExtension(null, variables, workflowMeta.getFilename());
        try {
            ExtensionPointHandler.callExtensionPoint((ILogChannel)LogChannel.UI, (IVariables)variables, (String)HopGuiExtensionPoint.HopGuiFileOpenedDialog.id, (Object)ext);
        }
        catch (Exception xe) {
            LogChannel.UI.logError("Error handling extension point 'HopGuiFileOpenDialog'", (Throwable)xe);
        }
        actionWorkflow.setFileName(ext.filename);
        try {
            MultiMetadataProvider metadataProvider = workflowGraph.getHopGui().getMetadataProvider();
            IHopMetadataSerializer serializer = metadataProvider.getSerializer(WorkflowRunConfiguration.class);
            List configNames = serializer.listObjectNames();
            if (!configNames.isEmpty()) {
                if (configNames.size() == 1) {
                    actionWorkflow.setRunConfiguration((String)configNames.get(0));
                } else {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(workflowGraph.getShell(), configNames.toArray(new String[0]), "Select run configuration", "Select the workflow run configuration to use in the action:");
                    String configName = dialog.open();
                    if (configName != null) {
                        actionWorkflow.setRunConfiguration(configName);
                    }
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(workflowGraph.getShell(), "Error", "Error selecting workflow run configurations", e);
        }
        ActionMeta actionMeta = new ActionMeta((IAction)actionWorkflow);
        StringBuilder xml = new StringBuilder(5000).append(XmlHandler.getXmlHeader());
        xml.append(XmlHandler.openTag((String)"workflow-actions")).append(Const.CR);
        xml.append(XmlHandler.openTag((String)"actions")).append(Const.CR);
        xml.append(actionMeta.getXml());
        xml.append(XmlHandler.closeTag((String)"actions")).append(Const.CR);
        xml.append(XmlHandler.closeTag((String)"workflow-actions")).append(Const.CR);
        workflowGraph.workflowClipboardDelegate.toClipboard(xml.toString());
    }
}

