/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import com.healthmarketscience.jackcess.Database;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.JackcessOpenerInterface;
import net.ucanaccess.jdbc.UcanaccessDriver;

public final class DBReferenceSingleton {
    private static DBReferenceSingleton singletonObject;
    private Map<String, DBReference> dbRegistry = Collections.synchronizedMap(new HashMap());

    private DBReferenceSingleton() {
    }

    public static DBReferenceSingleton getInstance() {
        if (singletonObject == null) {
            singletonObject = new DBReferenceSingleton();
        }
        return singletonObject;
    }

    public DBReference getReference(File ref) {
        return this.dbRegistry.get(ref.getAbsolutePath());
    }

    public boolean loaded(File fl) throws IOException, SQLException {
        return this.dbRegistry.containsKey(fl.getAbsolutePath());
    }

    public DBReference loadReference(File fl, Database.FileFormat ff, JackcessOpenerInterface jko, String pwd) throws IOException, SQLException {
        DBReference ref = new DBReference(fl, ff, jko, pwd);
        return ref;
    }

    public DBReference put(String path, DBReference dbr) {
        return this.dbRegistry.put(path, dbr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBReference remove(String path) throws IOException, SQLException {
        Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
        synchronized (UcanaccessDriver.class) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.dbRegistry.remove(path);
        }
    }
}

