/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.api.services.bigquery.model.TableRow;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.values.TypeDescriptor;

public class TableRowJsonCoder
extends AtomicCoder<TableRow> {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new JavaTimeModule()).registerModule((Module)new JodaModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    private static final TableRowJsonCoder INSTANCE = new TableRowJsonCoder();
    private static final TypeDescriptor<TableRow> TYPE_DESCRIPTOR = new TypeDescriptor<TableRow>(){};

    public static TableRowJsonCoder of() {
        return INSTANCE;
    }

    public void encode(TableRow value, OutputStream outStream) throws IOException {
        this.encode(value, outStream, Coder.Context.NESTED);
    }

    public void encode(TableRow value, OutputStream outStream, Coder.Context context) throws IOException {
        String strValue = MAPPER.writeValueAsString((Object)value);
        StringUtf8Coder.of().encode(strValue, outStream, context);
    }

    public TableRow decode(InputStream inStream) throws IOException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    public TableRow decode(InputStream inStream, Coder.Context context) throws IOException {
        String strValue = StringUtf8Coder.of().decode(inStream, context);
        return (TableRow)MAPPER.readValue(strValue, TableRow.class);
    }

    public long getEncodedElementByteSize(TableRow value) throws Exception {
        String strValue = MAPPER.writeValueAsString((Object)value);
        return StringUtf8Coder.of().getEncodedElementByteSize(strValue);
    }

    private TableRowJsonCoder() {
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException((Coder)this, "TableCell can hold arbitrary instances, which may be non-deterministic.");
    }

    public TypeDescriptor<TableRow> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }
}

