/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dao;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PartitionMetadataAdminDao {
    public static final String COLUMN_PARTITION_TOKEN = "PartitionToken";
    public static final String COLUMN_PARENT_TOKENS = "ParentTokens";
    public static final String COLUMN_START_TIMESTAMP = "StartTimestamp";
    public static final String COLUMN_END_TIMESTAMP = "EndTimestamp";
    public static final String COLUMN_HEARTBEAT_MILLIS = "HeartbeatMillis";
    public static final String COLUMN_STATE = "State";
    public static final String COLUMN_WATERMARK = "Watermark";
    public static final String COLUMN_CREATED_AT = "CreatedAt";
    public static final String COLUMN_SCHEDULED_AT = "ScheduledAt";
    public static final String COLUMN_RUNNING_AT = "RunningAt";
    public static final String COLUMN_FINISHED_AT = "FinishedAt";
    private static final int TIMEOUT_MINUTES = 10;
    private static final int TTL_AFTER_PARTITION_FINISHED_DAYS = 1;
    private final DatabaseAdminClient databaseAdminClient;
    private final String instanceId;
    private final String databaseId;
    private final String tableName;

    PartitionMetadataAdminDao(DatabaseAdminClient databaseAdminClient, String instanceId, String databaseId, String tableName) {
        this.databaseAdminClient = databaseAdminClient;
        this.instanceId = instanceId;
        this.databaseId = databaseId;
        this.tableName = tableName;
    }

    public void createPartitionMetadataTable() {
        String metadataCreateStmt = "CREATE TABLE " + this.tableName + " (" + COLUMN_PARTITION_TOKEN + " STRING(MAX) NOT NULL," + COLUMN_PARENT_TOKENS + " ARRAY<STRING(MAX)> NOT NULL," + COLUMN_START_TIMESTAMP + " TIMESTAMP NOT NULL," + COLUMN_END_TIMESTAMP + " TIMESTAMP NOT NULL," + COLUMN_HEARTBEAT_MILLIS + " INT64 NOT NULL," + COLUMN_STATE + " STRING(MAX) NOT NULL," + COLUMN_WATERMARK + " TIMESTAMP NOT NULL," + COLUMN_CREATED_AT + " TIMESTAMP NOT NULL OPTIONS (allow_commit_timestamp=true)," + COLUMN_SCHEDULED_AT + " TIMESTAMP OPTIONS (allow_commit_timestamp=true)," + COLUMN_RUNNING_AT + " TIMESTAMP OPTIONS (allow_commit_timestamp=true)," + COLUMN_FINISHED_AT + " TIMESTAMP OPTIONS (allow_commit_timestamp=true),) PRIMARY KEY (PartitionToken), ROW DELETION POLICY (OLDER_THAN(" + COLUMN_FINISHED_AT + ", INTERVAL " + 1 + " DAY))";
        OperationFuture op = this.databaseAdminClient.updateDatabaseDdl(this.instanceId, this.databaseId, Collections.singletonList(metadataCreateStmt), null);
        try {
            op.get(10L, TimeUnit.MINUTES);
        }
        catch (ExecutionException | TimeoutException e) {
            if (e.getCause() != null) {
                throw (SpannerException)e.getCause();
            }
            throw SpannerExceptionFactory.asSpannerException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
        }
    }

    public void deletePartitionMetadataTable() {
        String metadataDropStmt = "DROP TABLE " + this.tableName;
        OperationFuture op = this.databaseAdminClient.updateDatabaseDdl(this.instanceId, this.databaseId, Collections.singletonList(metadataDropStmt), null);
        try {
            op.get(10L, TimeUnit.MINUTES);
        }
        catch (ExecutionException | TimeoutException e) {
            if (e.getCause() != null) {
                throw (SpannerException)e.getCause();
            }
            throw SpannerExceptionFactory.asSpannerException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw SpannerExceptionFactory.propagateInterrupt((InterruptedException)e);
        }
    }
}

