/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.metadata;

import java.io.Serializable;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class FieldDefinition
implements Serializable {
    @HopMetadataProperty
    private String name;
    @HopMetadataProperty
    private String hopType;
    @HopMetadataProperty
    private int length;
    @HopMetadataProperty
    private int precision;
    @HopMetadataProperty
    private String formatMask;

    public FieldDefinition() {
    }

    public FieldDefinition(String name, String hopType, int length, int precision) {
        this.name = name;
        this.hopType = hopType;
        this.length = length;
        this.precision = precision;
    }

    public FieldDefinition(String name, String hopType, int length, int precision, String formatMask) {
        this.name = name;
        this.hopType = hopType;
        this.length = length;
        this.precision = precision;
        this.formatMask = formatMask;
    }

    public IValueMeta getValueMeta() throws HopPluginException {
        int type = ValueMetaFactory.getIdForValueMeta((String)this.hopType);
        IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)this.name, (int)type, (int)this.length, (int)this.precision);
        valueMeta.setConversionMask(this.formatMask);
        return valueMeta;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHopType() {
        return this.hopType;
    }

    public void setHopType(String hopType) {
        this.hopType = hopType;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public String getFormatMask() {
        return this.formatMask;
    }

    public void setFormatMask(String formatMask) {
        this.formatMask = formatMask;
    }
}

