/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.credentials;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

class MSIToken {
    private static DateTime epoch = new DateTime(1970, 1, 1, 0, 0, 0, DateTimeZone.UTC);
    @JsonProperty(value="token_type")
    private String tokenType;
    @JsonProperty(value="access_token")
    private String accessToken;
    @JsonProperty(value="expires_on")
    private String expiresOn;

    MSIToken() {
    }

    String accessToken() {
        return this.accessToken;
    }

    String tokenType() {
        return this.tokenType;
    }

    boolean isExpired() {
        DateTime now = DateTime.now((DateTimeZone)DateTimeZone.UTC);
        DateTime expireOn = epoch.plusSeconds(Integer.parseInt(this.expiresOn));
        return now.plusMinutes(5).isAfter(expireOn.getMillis());
    }
}

