/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.splunk;

import com.splunk.Service;
import com.splunk.ServiceArgs;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;

@HopMetadata(key="splunk", name="Splunk Connection", description="This metadata type describes how you can connect to Splunk", image="splunk.svg", documentationUrl="/metadata-types/splunk-connection.html")
public class SplunkConnection
extends HopMetadataBase
implements Cloneable,
IHopMetadata {
    @HopMetadataProperty
    private String hostname;
    @HopMetadataProperty
    private String port;
    @HopMetadataProperty
    private String username;
    @HopMetadataProperty(password=true)
    private String password;

    public SplunkConnection() {
    }

    public SplunkConnection(SplunkConnection source) {
        this.name = source.name;
        this.hostname = source.hostname;
        this.port = source.port;
        this.username = source.username;
        this.password = source.password;
    }

    public SplunkConnection(String name, String hostname, String port, String username, String password) {
        this.name = name;
        this.hostname = hostname;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public SplunkConnection clone() {
        return new SplunkConnection(this);
    }

    public void test(IVariables variables) throws HopException {
        try {
            Service.connect((Map)this.getServiceArgs(variables));
        }
        catch (Exception e) {
            throw new HopException("Error connecting to Splunk connection '" + this.name + "' on host '" + this.getRealHostname(variables) + "' and port '" + this.getRealPort(variables) + "' with user '" + this.getRealUsername(variables) + "'", (Throwable)e);
        }
    }

    public ServiceArgs getServiceArgs(IVariables variables) {
        ServiceArgs args = new ServiceArgs();
        args.setUsername(this.getRealUsername(variables));
        args.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)this.getRealPassword(variables)));
        args.setHost(this.getRealHostname(variables));
        args.setPort(Const.toInt((String)this.getRealPort(variables), (int)8089));
        return args;
    }

    public String getRealHostname(IVariables variables) {
        return variables.resolve(this.hostname);
    }

    public String getRealPort(IVariables variables) {
        return variables.resolve(this.port);
    }

    public String getRealUsername(IVariables variables) {
        return variables.resolve(this.username);
    }

    public String getRealPassword(IVariables variables) {
        return Encr.decryptPasswordOptionallyEncrypted((String)variables.resolve(this.password));
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

